/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.ScoreSumWayEnum;
import kd.data.rsa.helper.CodeRuleHelper;
import kd.data.rsa.helper.MessageSendHelper;
import kd.data.rsa.helper.OccurPossibilityHelper;
import kd.data.rsa.helper.ResultEffectHelper;
import kd.data.rsa.helper.RiskLevelEvalCriteriaHelper;
import kd.data.rsa.helper.UserHelper;

public class EvalWithHelper {
    private static final Log logger = LogFactory.getLog(EvalWithHelper.class);
    private static final String ALGO_KEY = EvalWithHelper.class.getName();

    private EvalWithHelper() {
    }

    public static void judgeCreateEvalAck(String evalNo) {
        block21: {
            DynamicObject untreatedEval = BusinessDataServiceHelper.loadSingle((String)"rsa_evalwith", (QFilter[])new QFilter[]{new QFilter("evalno", "=", (Object)evalNo).and("billstatus", "=", (Object)"A")});
            if (untreatedEval == null) {
                try (DLock dLock = DLock.create((String)("macc/rsa/" + evalNo));){
                    if (!dLock.tryLock(1000L)) break block21;
                    List allCodeRuleByEntity = CodeRuleHelper.getAllCodeRuleByEntity((String)"rsa_evalwith");
                    boolean noCodeRule = true;
                    for (CodeRuleInfo codeRuleInfo : allCodeRuleByEntity) {
                        if (!ResManager.loadKDString((String)"\u8bc4\u4f30\u7ed3\u679c\u786e\u8ba4\u5355", (String)"EvalWithHelper_0", (String)"data-rsa-business", (Object[])new Object[0]).equals(codeRuleInfo.getName())) continue;
                        noCodeRule = false;
                    }
                    if (noCodeRule) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u98ce\u9669\u8bc4\u4f30\u786e\u8ba4\u5355\u7684\u53ef\u7528\u7684\u7f16\u53f7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u7f16\u53f7\u89c4\u5219\u914d\u7f6e\u60c5\u51b5\u3002", (String)"EvalWithHelper_1", (String)"data-rsa-business", (Object[])new Object[0]));
                    }
                    try {
                        Object[] save;
                        Map evalWithDynMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_evalwith", (QFilter[])new QFilter[]{new QFilter("evalno", "=", (Object)evalNo).and("billstatus", "=", (Object)"C")});
                        DynamicObject evalAck = EvalWithHelper.createEvalAck(evalWithDynMap);
                        DynamicObject evalAckDyn = BusinessDataServiceHelper.loadSingle((String)"rsa_evalwith", (QFilter[])new QFilter[]{new QFilter("evalno", "=", (Object)evalNo).and("billtype.number", "=", (Object)"rsa_evalack_BT_S")});
                        if (evalAckDyn == null && (save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{evalAck})) != null && save.length == 1) {
                            logger.info("[DATA-RSA] SendMessageEval\uff1a" + ((DynamicObject)save[0]).getLong("ackuser.id"));
                            MessageSendHelper.sendEvalAckMessage((DynamicObject)((DynamicObject)save[0]));
                        }
                    }
                    catch (Exception e) {
                        logger.error("[DATA-RSA] CreateEvalAckError" + e.getMessage());
                        throw new KDBizException(e.getMessage());
                    }
                    finally {
                        dLock.unlock();
                    }
                }
            }
        }
    }

    private static DynamicObject createEvalAck(Map<Object, DynamicObject> evalWithDynMap) {
        Object dutyOrgId;
        ScoreSumWayEnum scoreSumWayEnum;
        DynamicObject evalAck = BusinessDataServiceHelper.newDynamicObject((String)"rsa_evalwith");
        LinkedHashMap<Long, DynamicObject> ackEntryMap = new LinkedHashMap<Long, DynamicObject>(10);
        Map<String, String> userWeigthMap = null;
        String scoreSumWayText = null;
        String noResponSumWayText = null;
        Optional<DynamicObject> first = evalWithDynMap.values().stream().findFirst();
        if (first.isPresent()) {
            DynamicObject evalWith = first.get();
            String scoreSumWay = evalWith.getString("scoresumway");
            Long ackUserId = evalWith.getLong("ackuser.id");
            scoreSumWayEnum = ScoreSumWayEnum.getScoreSumWayEnum(scoreSumWay);
            evalAck.set("dutyorg", (Object)UserHelper.getUserMainOrg((Long)ackUserId));
            evalAck.set("ackuser", evalWith.get("ackuser"));
            evalAck.set("evalno", evalWith.get("evalno"));
            evalAck.set("billstatus", (Object)"A");
            switch (scoreSumWayEnum) {
                case PERSON_WEIGHT: {
                    List weightMap = (List)JSON.parseObject((String)evalWith.getString("weightjson_tag"), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
                    if (weightMap == null) break;
                    userWeigthMap = weightMap.stream().collect(Collectors.toMap(map -> (String)map.get("evalUserId"), map -> (String)map.get("evalWeight")));
                    scoreSumWayText = ResManager.loadKDString((String)"\u6309\u4eba\u5458\u6743\u91cd\u6c47\u603b\uff1a%s %%", (String)"EvalWithHelper_2", (String)"data-rsa-business", (Object[])new Object[0]);
                    break;
                }
                case AVERAGE: {
                    scoreSumWayText = ResManager.loadKDString((String)"\u53d6\u5e73\u5747\u503c", (String)"EvalWithHelper_3", (String)"data-rsa-business", (Object[])new Object[0]);
                    break;
                }
                case MAXIMUM: {
                    scoreSumWayText = ResManager.loadKDString((String)"\u53d6\u6700\u9ad8\u503c", (String)"EvalWithHelper_4", (String)"data-rsa-business", (Object[])new Object[0]);
                    break;
                }
                case ORG_WEIGHT: {
                    List weightMap = (List)JSON.parseObject((String)evalWith.getString("weightjson_tag"), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
                    if (weightMap == null) break;
                    userWeigthMap = weightMap.stream().collect(Collectors.toMap(map -> (String)map.get("orgType"), map -> (String)map.get("evalWeight")));
                    scoreSumWayText = ResManager.loadKDString((String)"\u6309\u90e8\u95e8\u6743\u91cd\u6c47\u603b\uff1a\u8d23\u4efb\u90e8\u95e8\uff0c%s %%", (String)"EvalWithHelper_5", (String)"data-rsa-business", (Object[])new Object[0]);
                    noResponSumWayText = ResManager.loadKDString((String)"\u6309\u90e8\u95e8\u6743\u91cd\u6c47\u603b\uff1a\u975e\u8d23\u4efb\u90e8\u95e8\uff0c%s %%", (String)"EvalWithHelper_6", (String)"data-rsa-business", (Object[])new Object[0]);
                    break;
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u518d\u6b21\u63d0\u4ea4\u8bc4\u4f30\u7ed3\u679c\u3002", (String)"EvalWithHelper_7", (String)"data-rsa-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection ackEntry = evalAck.getDynamicObjectCollection("entryentity");
        QFilter numberFilter = new QFilter("number", "=", (Object)"rsa_evalack_BT_S");
        DynamicObject billTypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (String)"id,number", (QFilter[])new QFilter[]{numberFilter});
        evalAck.set("billtype", (Object)billTypeDy);
        List allCodeRuleByEntity = CodeRuleHelper.getAllCodeRuleByEntity((String)"rsa_evalwith");
        for (Object codeRuleInfo : allCodeRuleByEntity) {
            if (!"3JME+=5IQ6KU".equals(codeRuleInfo.getId())) continue;
            String billNo = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)evalAck);
            evalAck.set("billno", (Object)billNo);
        }
        HashMap orgWeightMap = new HashMap(10);
        if (scoreSumWayEnum == ScoreSumWayEnum.ORG_WEIGHT) {
            for (DynamicObject evalWith : evalWithDynMap.values()) {
                DynamicObjectCollection entryEntity = evalWith.getDynamicObjectCollection("entryentity");
                dutyOrgId = evalWith.getString("dutyorg");
                for (DynamicObject entry : entryEntity) {
                    Long riskId = entry.getLong("e_risk.id");
                    int index = 0;
                    ArrayList<Integer> eRisk = (ArrayList<Integer>)orgWeightMap.get(riskId);
                    if (eRisk == null) {
                        eRisk = new ArrayList<Integer>(4);
                        eRisk.add(0, 0);
                        eRisk.add(1, 0);
                    }
                    if (!((String)dutyOrgId).equals(entry.getString("e_dutyorg"))) {
                        index = 1;
                    }
                    eRisk.set(index, (Integer)eRisk.get(index) + 1);
                    orgWeightMap.put(riskId, eRisk);
                }
            }
        }
        int i = 0;
        for (DynamicObject value : evalWithDynMap.values()) {
            dutyOrgId = value.getLong("dutyorg.id");
            DynamicObjectCollection entryEntity = value.getDynamicObjectCollection("entryentity");
            Long evalUserId = value.getLong("evaluser.id");
            for (DynamicObject entry : entryEntity) {
                Long eDutyOrgId = entry.getLong("e_dutyorg.id");
                boolean responsible = ((Long)dutyOrgId).equals(eDutyOrgId);
                Long riskId = entry.getLong("e_risk.id");
                DynamicObject ackDyn = ackEntryMap.computeIfAbsent(riskId, k -> new DynamicObject(ackEntry.getDynamicObjectType()));
                List<String> needCalculateFields = Arrays.asList("e_occscore", "e_resultscore");
                EvalWithHelper.calculateWeight(ackDyn, entry, scoreSumWayEnum, needCalculateFields, userWeigthMap, evalUserId, evalWithDynMap.size(), i, responsible, (List)orgWeightMap.get(riskId));
                ackDyn.set("e_risk", (Object)riskId);
                ackDyn.set("e_riskname", entry.get("e_riskname"));
                ackDyn.set("e_riskdesc", entry.get("e_riskdesc"));
                ackDyn.set("e_dutyorg", entry.get("e_dutyorg"));
                if (i == evalWithDynMap.size() - 1) {
                    DynamicObject riskLevelEvaDy;
                    BigDecimal occScore = ackDyn.getBigDecimal("e_occscore");
                    occScore = occScore.setScale(1, RoundingMode.HALF_UP);
                    ackDyn.set("e_occscore", (Object)occScore);
                    DynamicObject occDy = OccurPossibilityHelper.getSingle(occScore);
                    if (occDy != null) {
                        ackDyn.set("e_occdesc", (Object)occDy.getString("name"));
                    }
                    BigDecimal resultScore = ackDyn.getBigDecimal("e_resultscore");
                    resultScore = resultScore.setScale(1, RoundingMode.HALF_UP);
                    ackDyn.set("e_resultscore", (Object)resultScore);
                    DynamicObject resultDy = ResultEffectHelper.getSingle(resultScore);
                    if (resultDy != null) {
                        ackDyn.set("e_resultdesc", (Object)resultDy.getString("name"));
                    }
                    if (occDy != null && resultDy != null && (riskLevelEvaDy = RiskLevelEvalCriteriaHelper.getSingle(occDy.getLong("id"), resultDy.getLong("id"))) != null) {
                        ackDyn.set("e_level", riskLevelEvaDy.get("risklevelid.id"));
                    }
                    ackDyn.set("e_score", (Object)occScore.multiply(resultScore).setScale(2, RoundingMode.HALF_UP));
                }
                ackEntryMap.put(riskId, ackDyn);
                DynamicObjectCollection subEntryEntity = ackDyn.getDynamicObjectCollection("subentryentity");
                DynamicObject subEntry = new DynamicObject(subEntryEntity.getDynamicObjectType());
                subEntry.set("se_evaluser", (Object)evalUserId);
                subEntry.set("se_dutyorg", dutyOrgId);
                subEntry.set("se_occscore", entry.get("e_occscore"));
                subEntry.set("se_occdesc", entry.get("e_occdesc"));
                subEntry.set("se_resultscore", entry.get("e_resultscore"));
                subEntry.set("se_resultdesc", entry.get("e_resultdesc"));
                subEntry.set("se_score", entry.get("e_score"));
                subEntry.set("se_level", entry.get("e_level"));
                if (userWeigthMap != null && scoreSumWayEnum == ScoreSumWayEnum.PERSON_WEIGHT) {
                    subEntry.set("se_scoresumwaytext", (Object)String.format(scoreSumWayText, userWeigthMap.get(evalUserId.toString())));
                } else if (userWeigthMap != null && scoreSumWayEnum == ScoreSumWayEnum.ORG_WEIGHT) {
                    if (responsible) {
                        subEntry.set("se_scoresumwaytext", (Object)String.format(scoreSumWayText, userWeigthMap.get("1")));
                    } else {
                        subEntry.set("se_scoresumwaytext", (Object)String.format(noResponSumWayText, userWeigthMap.get("2")));
                    }
                } else {
                    subEntry.set("se_scoresumwaytext", (Object)scoreSumWayText);
                }
                subEntryEntity.add((Object)subEntry);
            }
            ++i;
        }
        ackEntry.addAll(ackEntryMap.values());
        return evalAck;
    }

    private static void calculateWeight(DynamicObject ackEntry, DynamicObject withEntry, ScoreSumWayEnum scoreSumWay, List<String> needCalculateFields, Map<String, String> userWeigthMap, Long evalUserId, int evaluatorCount, int index, boolean responsible, List<Integer> orgWeightList) {
        for (String field : needCalculateFields) {
            BigDecimal score = ackEntry.getBigDecimal(field) == null ? new BigDecimal("0") : ackEntry.getBigDecimal(field);
            String weight = null;
            switch (scoreSumWay) {
                case PERSON_WEIGHT: {
                    if (userWeigthMap == null || (weight = userWeigthMap.get(evalUserId.toString())) == null) break;
                    BigDecimal divide = new BigDecimal(weight).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
                    score = score.add(withEntry.getBigDecimal(field).multiply(divide));
                    break;
                }
                case AVERAGE: {
                    score = score.add(withEntry.getBigDecimal(field));
                    if (index != evaluatorCount - 1) break;
                    score = score.divide(new BigDecimal(evaluatorCount), 4, RoundingMode.HALF_UP);
                    break;
                }
                case MAXIMUM: {
                    if (score.compareTo(withEntry.getBigDecimal(field)) >= 0) break;
                    score = withEntry.getBigDecimal(field);
                    break;
                }
                case ORG_WEIGHT: {
                    int userIndex = responsible ? 0 : 1;
                    int reverseIndex = responsible ? 1 : 0;
                    int personRatio = orgWeightList.get(userIndex);
                    if (userWeigthMap != null && (weight = userWeigthMap.get(responsible ? "1" : "2")) != null && orgWeightList.get(reverseIndex) != 0) {
                        BigDecimal divide = new BigDecimal(weight).divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP);
                        score = score.add(withEntry.getBigDecimal(field).multiply(divide).divide(new BigDecimal(personRatio), 2, RoundingMode.HALF_UP));
                        break;
                    }
                    score = score.add(withEntry.getBigDecimal(field).divide(new BigDecimal(personRatio), 2, RoundingMode.HALF_UP));
                    break;
                }
            }
            ackEntry.set(field, (Object)score);
        }
    }

    /*
     * Exception decompiling
     */
    public static List<String> checkEvalEntry(Set<Object> evalWithIdSet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Tuple2<Boolean, String> evalWithRollBack(Map<String, String> returnDataMap) {
        try (TXHandle h = TX.required((String)"RSA_EvaLack_callBack");){
            String pkIds = returnDataMap.get("pkid");
            String callBackInfo = returnDataMap.get("callbackinfo");
            String evalUser = returnDataMap.get("evaluser");
            if (pkIds == null || callBackInfo == null || StringUtils.isEmpty((String)evalUser)) {
                logger.info("[DATA-RSA] EvalWithHelper.evalWithRollBack data error :" + callBackInfo);
                Tuple2 tuple2 = new Tuple2((Object)Boolean.FALSE, (Object)"");
                return tuple2;
            }
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"rsa_evalwith");
            DynamicObject lackEval = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(pkIds), (DynamicObjectType)entityType);
            if (lackEval == null) {
                Tuple2 tuple2 = new Tuple2((Object)Boolean.FALSE, (Object)ResManager.loadKDString((String)"\u9700\u6253\u56de\u7684\u5355\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"EvalWithHelper_8", (String)"data-rsa-business", (Object[])new Object[0]));
                return tuple2;
            }
            try {
                DynamicObject[] evalWiths = BusinessDataServiceHelper.load((String)"rsa_evalwith", (String)"id, callbackinfo, billstatus, processdate", (QFilter[])new QFilter[]{new QFilter("evalno", "=", (Object)lackEval.getString("evalno")).and("billtype.number", "=", (Object)"rsa_riskeval_BT_S").and("evaluser", "in", SerializationUtils.fromJsonString((String)evalUser, List.class))});
                ArrayList<Object> evalWithIds = new ArrayList<Object>(evalWiths.length);
                for (DynamicObject evalWith : evalWiths) {
                    evalWith.set("billstatus", (Object)"A");
                    evalWith.set("callbackinfo", (Object)(" ".equals(callBackInfo) ? "  " : callBackInfo));
                    evalWith.set("processdate", null);
                    evalWithIds.add(evalWith.get("id"));
                }
                SaveServiceHelper.update((DynamicObject[])evalWiths);
                DeleteServiceHelper.delete((IDataEntityType)entityType, (Object[])new Object[]{Long.parseLong(pkIds)});
                MessageSendHelper.sendCallBackEvalMessage(evalWithIds);
            }
            catch (NumberFormatException e) {
                h.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return new Tuple2((Object)Boolean.TRUE, (Object)"");
    }
}

