/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.RiskNumericalUnitEnum;
import kd.data.rsa.enums.TimeTypeEnum;
import kd.data.rsa.model.RiskCalculateDTO;
import kd.data.rsa.model.RiskScanDTO;
import kd.data.rsa.utils.UnitConversionUtil;

public class RiskCheckHelper {
    private static final Log logger = LogFactory.getLog(RiskCheckHelper.class);

    public static Set<Object> checkAvailableRiskItem(Set<Long> orgSet) {
        HashSet<Object> entityIdRetainSet = new HashSet<Object>(16);
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        for (Long orgId : orgSet) {
            RiskCheckHelper.getRiskItemIdList(orgId, qFilter, entityIdRetainSet);
        }
        if (entityIdRetainSet.isEmpty()) {
            logger.info("[DATA-RSA] AutoScan checkAvailable is empty");
        }
        return entityIdRetainSet;
    }

    public static List<Object> checkAvailableRisk(Set<Long> orgSet) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        qFilter.and("dutyorg", "in", orgSet);
        List riskIdRetainList = QueryServiceHelper.queryPrimaryKeys((String)"rsa_risk", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        if (riskIdRetainList.isEmpty()) {
            logger.info("[DATA-RSA] AutoScan checkAvailableRisk is empty");
        }
        return riskIdRetainList;
    }

    private static void getRiskItemIdList(Long orgId, QFilter baseFilter, Set<Object> retainSet) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"rsa_riskitem", (Long)orgId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"RSARiskCheckFormPlugin.getRiskItemIdList", (String)"rsa_riskitem", (String)"id", (QFilter[])new QFilter[]{baseFilter, orgFilter}, null);){
            if (ds != null) {
                ArrayList<Long> currentEntityIdList = new ArrayList<Long>(16);
                while (ds.hasNext()) {
                    currentEntityIdList.add(ds.next().getLong("id"));
                }
                if (retainSet.isEmpty()) {
                    retainSet.addAll(currentEntityIdList);
                } else {
                    retainSet.retainAll(currentEntityIdList);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"F7\u8fc7\u6ee4\u5f02\u5e38\uff1a%s", (String)"RiskCheckHelper_0", (String)"data-rsa-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkPeriodMatch(String scanObject, String timeTypeMul, Set<Long> riskItemIds, Set<Long> riskIdSet) {
        String[] timeTypes = timeTypeMul.substring(1, timeTypeMul.length() - 1).split(",");
        if (timeTypes.length == 2) {
            return true;
        }
        String timeType = timeTypes[0];
        Map<Long, List> riskItemMap = null;
        if ("2".equals(scanObject)) {
            Map riskItemDynMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_riskitem", (QFilter[])new QFilter[]{new QFilter("id", "in", riskItemIds).and("enable", "=", (Object)"1")});
            if (riskItemDynMap.isEmpty()) return false;
            riskItemMap = riskItemDynMap.values().stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.get("defaultdimension") == null ? null : ((MulBasedataDynamicObjectCollection)x.get("defaultdimension")).stream().map(y -> y.getLong("fbasedataid_id")).collect(Collectors.toList())));
        } else if ("1".equals(scanObject)) {
            if (riskIdSet == null || riskIdSet.isEmpty()) return false;
            Map riskDynMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risk", (String)"riskitem", (QFilter[])new QFilter[]{new QFilter("id", "in", riskIdSet)});
            Set riskItems = riskDynMap.values().stream().flatMap(x -> {
                MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)x.get("riskitem");
                return collection.stream();
            }).collect(Collectors.toSet());
            if (riskItems.isEmpty()) return false;
            riskItemMap = riskItems.stream().collect(Collectors.toMap(x -> x.getLong("fbasedataid_id"), x -> x.get("fbasedataid.defaultdimension") == null ? null : ((MulBasedataDynamicObjectCollection)x.get("fbasedataid.defaultdimension")).stream().map(y -> y.getLong("fbasedataid_id")).collect(Collectors.toList()), (o1, o2) -> o1));
        }
        HashSet dimensionIds = new HashSet();
        if (riskItemMap == null) {
            return false;
        }
        for (List value : riskItemMap.values()) {
            dimensionIds.addAll(value);
        }
        String timeTypeEntity = timeType.equals("1") ? TimeTypeEnum.PA_ANALYSISPERIOD.getCode() : TimeTypeEnum.BD_PERIOD.getCode();
        List timeTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"pa_dimension", (QFilter[])new QFilter[]{new QFilter("id", "in", dimensionIds).and("dimensionsource", "=", (Object)timeTypeEntity)}, null, (int)-1);
        HashSet<Long> notMatchItemIds = new HashSet<Long>(10);
        for (Map.Entry<Long, List> entry : riskItemMap.entrySet()) {
            List value = entry.getValue();
            if (!timeTypeIds.stream().noneMatch(value::contains)) continue;
            notMatchItemIds.add(entry.getKey());
        }
        if (notMatchItemIds.isEmpty()) return notMatchItemIds.isEmpty();
        logger.info("[DATA-RSA] AutoScan checkPeriodMatch error" + notMatchItemIds);
        return notMatchItemIds.isEmpty();
    }

    public static boolean checkOrgFasPermission(RiskScanDTO riskScanDTO) {
        Map riskItemMap = null;
        Set<Long> finalRiskItemIdSet = riskScanDTO.getRiskItemIdSet();
        String scanObject = riskScanDTO.getScanObjectStr();
        Set<Long> orgSet = riskScanDTO.getScanOrgIdSet();
        Set<Long> riskIdSet = riskScanDTO.getRiskIdSet();
        if ("1".equals(scanObject)) {
            if (riskIdSet != null && !riskIdSet.isEmpty()) {
                Map riskDynMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risk", (String)"riskitem", (QFilter[])new QFilter[]{new QFilter("id", "in", riskIdSet).and("billstatus", "=", (Object)"C")});
                if (riskDynMap.isEmpty()) {
                    logger.info("[DATA-RSA] AutoScan checkOrgFasPermission error : riskDynMap.isEmpty");
                    return false;
                }
                finalRiskItemIdSet = riskDynMap.values().stream().flatMap(x -> {
                    MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)x.get("riskitem");
                    return collection.stream();
                }).map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toSet());
            } else {
                logger.info("[DATA-RSA] AutoScan checkOrgFasPermission error : riskIdSet.isEmpty");
                return false;
            }
        }
        if (finalRiskItemIdSet != null && !finalRiskItemIdSet.isEmpty()) {
            riskItemMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_riskitem", (QFilter[])new QFilter[]{new QFilter("id", "in", finalRiskItemIdSet).and("enable", "=", (Object)"1")});
            if (riskItemMap == null || riskItemMap.isEmpty()) {
                return false;
            }
        } else {
            logger.info("[DATA-RSA] AutoScan checkOrgFasPermission error : finalRiskItemIdSet.isEmpty");
            return false;
        }
        riskScanDTO.setRiskItemIdSet(riskItemMap.keySet().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toSet()));
        Map<Object, List<Object>> riskItemOrgMap = RiskCheckHelper.getRiskItemOrgMap(riskItemMap, orgSet.toArray());
        if (riskItemOrgMap.isEmpty()) {
            logger.info("[DATA-RSA] AutoScan checkOrgFasPermission error : riskItemOrgMap.isEmpty");
            return false;
        }
        return true;
    }

    public static List<RiskCalculateDTO> buildCalculateDTOs(Object[] riskItemIds, Object[] orgIds, Object periodId, Object analysisPeriodId, Map<Long, List<Long>> riskMap) {
        String analysisPeriodName;
        String periodName;
        DynamicObject dynamicObject;
        Map<Object, Object> riskDutyOrgMap;
        HashMap<Long, ArrayList<Long>> riskItemRiskMap = new HashMap<Long, ArrayList<Long>>(10);
        if (riskMap != null) {
            for (Map.Entry<Long, List<Long>> entry : riskMap.entrySet()) {
                for (Long riskItemId : entry.getValue()) {
                    if (riskItemRiskMap.get(riskItemId) == null) {
                        riskItemRiskMap.put(riskItemId, new ArrayList<Long>(Collections.singletonList(entry.getKey())));
                        continue;
                    }
                    ((List)riskItemRiskMap.get(riskItemId)).add(entry.getKey());
                }
            }
            Map riskDynMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risk", (String)"id, dutyorg", (QFilter[])new QFilter[]{new QFilter("id", "in", riskMap.keySet())});
            riskDutyOrgMap = riskDynMap.values().stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("dutyorg.id")));
        } else {
            riskDutyOrgMap = new HashMap(10);
        }
        Map riskItems = BusinessDataServiceHelper.loadFromCache((Object[])riskItemIds, (String)"rsa_riskitem");
        Map<Object, List<Object>> riskItemOrgMap = RiskCheckHelper.getRiskItemOrgMap(riskItems, orgIds);
        ArrayList<RiskCalculateDTO> riskCalculateDTOS = new ArrayList<RiskCalculateDTO>(riskItems.size());
        if (periodId != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", periodId)});
            periodName = dynamicObject.getString("name");
        } else {
            periodName = null;
        }
        if (analysisPeriodId != null) {
            dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_analysisperiod", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", analysisPeriodId)});
            analysisPeriodName = dynamicObject.getString("name");
        } else {
            analysisPeriodName = null;
        }
        for (Map.Entry entry : riskItems.entrySet()) {
            Object[] checkOrgIdArray;
            Object k = entry.getKey();
            DynamicObject v2 = (DynamicObject)entry.getValue();
            Long riskItemId = Long.valueOf(k.toString());
            if (riskItemOrgMap.get(k) == null) continue;
            List<Object> orgIdList = riskItemOrgMap.get(k);
            HashMap<Long, Object[]> params = new HashMap<Long, Object[]>(10);
            TimeTypeEnum typeEnum = null;
            String orgNumber = null;
            String periodNumber = null;
            DynamicObjectCollection defaultDims = v2.getDynamicObjectCollection("defaultdimension");
            DynamicObjectCollection otherDims = v2.getDynamicObjectCollection("otherdimension");
            HashMap<String, Long> otherDimensionMap = new HashMap<String, Long>(otherDims.size());
            for (DynamicObject defaultDim : defaultDims) {
                Long baseDataId = defaultDim.getLong("fbasedataid.id");
                if (params.containsKey(baseDataId)) continue;
                String sourceNumber = defaultDim.getString("fbasedataid.dimensionsource.number");
                if ("bos_org".equals(sourceNumber)) {
                    params.put(baseDataId, orgIdList.toArray());
                    orgNumber = defaultDim.getString("fbasedataid.number");
                    continue;
                }
                if ("bd_period".equals(sourceNumber)) {
                    params.put(baseDataId, new Object[]{periodId});
                    periodNumber = defaultDim.getString("fbasedataid.number");
                    typeEnum = TimeTypeEnum.BD_PERIOD;
                    continue;
                }
                if ("pa_analysisperiod".equals(sourceNumber)) {
                    params.put(baseDataId, new Object[]{analysisPeriodId});
                    periodNumber = defaultDim.getString("fbasedataid.number");
                    typeEnum = TimeTypeEnum.PA_ANALYSISPERIOD;
                    continue;
                }
                params.put(baseDataId, new Object[0]);
            }
            if (typeEnum == null) continue;
            for (DynamicObject otherDim : otherDims) {
                params.put(otherDim.getLong("fbasedataid.id"), new Object[0]);
                if (otherDimensionMap.containsKey(otherDim.getString("fbasedataid.number"))) continue;
                otherDimensionMap.put(otherDim.getString("fbasedataid.number"), otherDim.getLong("fbasedataid.id"));
            }
            boolean isNullUnit = false;
            String numericalunit = v2.getString("numericalunit");
            if (StringUtils.isEmpty((String)numericalunit) || RiskNumericalUnitEnum.NULL.getCode().equals(numericalunit)) {
                isNullUnit = true;
            }
            DynamicObjectCollection entryentity = v2.getDynamicObjectCollection("entryentity");
            HashMap<String, ThreeTuple<Long, String, String>> intervalLevelMap = new HashMap<String, ThreeTuple<Long, String, String>>(entryentity.size());
            if (!entryentity.isEmpty()) {
                for (DynamicObject entity : entryentity) {
                    StringBuilder originalRangeSb;
                    StringBuilder conversionRangeSb;
                    String start = entity.getString("start");
                    String end = entity.getString("end");
                    if ("-\u221e".equals(start)) {
                        conversionRangeSb = new StringBuilder("(");
                        originalRangeSb = new StringBuilder("(");
                    } else {
                        conversionRangeSb = new StringBuilder("[");
                        originalRangeSb = new StringBuilder("[");
                    }
                    if (isNullUnit || start.contains("\u221e")) {
                        conversionRangeSb.append(start);
                        originalRangeSb.append(start);
                    } else {
                        conversionRangeSb.append(UnitConversionUtil.originalConversion(new BigDecimal(start), RiskNumericalUnitEnum.getEnum(numericalunit)));
                        originalRangeSb.append(start).append(RiskNumericalUnitEnum.getEnum(numericalunit).getName());
                    }
                    conversionRangeSb.append(", ");
                    originalRangeSb.append(", ");
                    if (isNullUnit || end.contains("\u221e")) {
                        conversionRangeSb.append(end);
                        originalRangeSb.append(end);
                    } else {
                        conversionRangeSb.append(UnitConversionUtil.originalConversion(new BigDecimal(end), RiskNumericalUnitEnum.getEnum(numericalunit)));
                        originalRangeSb.append(end).append(RiskNumericalUnitEnum.getEnum(numericalunit).getName());
                    }
                    conversionRangeSb.append(")");
                    originalRangeSb.append(")");
                    if (intervalLevelMap.containsKey(conversionRangeSb.toString())) continue;
                    intervalLevelMap.put(conversionRangeSb.toString(), (ThreeTuple<Long, String, String>)new ThreeTuple((Object)entity.getLong("level.id"), (Object)entity.getString("influence"), (Object)originalRangeSb.toString()));
                }
            }
            if (!riskItemRiskMap.isEmpty()) {
                List riskIds = (List)riskItemRiskMap.get(v2.getLong("id"));
                ArrayList<Object> dutyOrgIds = new ArrayList<Object>(riskIds.size());
                for (Long riskId : riskIds) {
                    dutyOrgIds.add(riskDutyOrgMap.get(riskId));
                }
                dutyOrgIds.retainAll(orgIdList);
                checkOrgIdArray = dutyOrgIds.toArray();
            } else {
                checkOrgIdArray = orgIdList.toArray();
            }
            riskCalculateDTOS.add(new RiskCalculateDTO(v2.getLong("fasindex.id"), params, orgNumber, periodNumber, v2.getString("fasindex.number"), intervalLevelMap, v2, otherDimensionMap, checkOrgIdArray, riskItemRiskMap.isEmpty() ? null : (List)riskItemRiskMap.get(v2.getLong("id")), typeEnum == TimeTypeEnum.BD_PERIOD ? periodId : analysisPeriodId, typeEnum, typeEnum == TimeTypeEnum.BD_PERIOD ? periodName : analysisPeriodName, riskDutyOrgMap));
        }
        return riskCalculateDTOS;
    }

    public static Map<Object, List<Object>> getRiskItemOrgMap(Map<Object, DynamicObject> riskItems, Object[] orgIds) {
        Set<Object> riskItemSet = riskItems.keySet();
        HashMap fasIndexRiskItemMap = new HashMap(riskItems.size());
        for (Map.Entry<Object, DynamicObject> entry : riskItems.entrySet()) {
            Object[] fasIndexId = entry.getValue().get("fasindex.id");
            ArrayList<Object> list = (ArrayList<Object>)fasIndexRiskItemMap.get(fasIndexId);
            if (list == null) {
                list = new ArrayList<Object>(10);
                list.add(entry.getKey());
                fasIndexRiskItemMap.put(fasIndexId, list);
                continue;
            }
            ((List)fasIndexRiskItemMap.get(fasIndexId)).add(entry.getKey());
        }
        HashMap orgRiskParamsMap = new HashMap(riskItemSet.size());
        HashMap orgFasIndexParamsMap = new HashMap(riskItemSet.size());
        for (Object orgId : orgIds) {
            QFilter riskDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"rsa_riskitem", (Long)Long.parseLong(orgId.toString()));
            riskDataFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            riskDataFilter.and(new QFilter("id", "in", riskItemSet));
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_riskitem", (QFilter[])riskDataFilter.toArray());
            for (Object riskItemId : dynamicObjectMap.keySet()) {
                if (orgRiskParamsMap.get(riskItemId) == null) {
                    ArrayList<Object> list = new ArrayList<Object>(orgIds.length);
                    list.add(orgId);
                    orgRiskParamsMap.put(riskItemId, list);
                    continue;
                }
                ((List)orgRiskParamsMap.get(riskItemId)).add(orgId);
            }
            QFilter fasIndexDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pa_fasindex", (Long)Long.parseLong(orgId.toString()));
            fasIndexDataFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            fasIndexDataFilter.and(new QFilter("id", "in", fasIndexRiskItemMap.keySet()));
            Map fasIndexMap = BusinessDataServiceHelper.loadFromCache((String)"pa_fasindex", (QFilter[])fasIndexDataFilter.toArray());
            for (Object fasIndexId : fasIndexMap.keySet()) {
                List riskItemIdList = (List)fasIndexRiskItemMap.get(fasIndexId);
                for (Object riskItemId : riskItemIdList) {
                    if (orgFasIndexParamsMap.get(riskItemId) == null) {
                        ArrayList<Object> list = new ArrayList<Object>(orgIds.length);
                        list.add(orgId);
                        orgFasIndexParamsMap.put(riskItemId, list);
                        continue;
                    }
                    ((List)orgFasIndexParamsMap.get(riskItemId)).add(orgId);
                }
            }
        }
        StringBuilder sb = new StringBuilder("[DATA-RSA] orgRiskParamsMap value: ");
        logger.info("[DATA-RSA] OrgRiskParamsMap size:" + orgRiskParamsMap.size());
        for (Map.Entry next : orgRiskParamsMap.entrySet()) {
            sb.append(next.getKey()).append(": size").append(((List)next.getValue()).size()).append(";  ");
        }
        logger.info(sb.toString());
        StringBuilder sb1 = new StringBuilder("[DATA-RSA] orgFasIndexParamsMap value:");
        logger.info("[DATA-RSA] OrgFasIndexParamsMap size:" + orgFasIndexParamsMap.size());
        for (Map.Entry next : orgFasIndexParamsMap.entrySet()) {
            sb1.append(next.getKey()).append(": size").append(((List)next.getValue()).size()).append(";  ");
        }
        logger.info(sb1.toString());
        HashMap<Object, List<Object>> orgParamsMap = new HashMap<Object, List<Object>>(riskItemSet.size());
        HashSet riskItemIds = new HashSet(orgFasIndexParamsMap.keySet());
        riskItemIds.retainAll(orgRiskParamsMap.keySet());
        for (Object riskItemId : riskItemIds) {
            ArrayList orgids = new ArrayList((Collection)orgFasIndexParamsMap.get(riskItemId));
            orgids.retainAll((Collection)orgRiskParamsMap.get(riskItemId));
            if (orgids.isEmpty()) continue;
            orgParamsMap.put(riskItemId, orgids);
        }
        return orgParamsMap;
    }

    public static Set<Object> validateRiskItem(Set<Object> riskItemSet, Object[] orgIds) {
        HashSet<Object> availableRiskItems = new HashSet<Object>(10);
        for (Object orgId : orgIds) {
            QFilter riskDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"rsa_riskitem", (Long)Long.parseLong(orgId.toString()));
            riskDataFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            riskDataFilter.and(new QFilter("id", "in", riskItemSet));
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_riskitem", (QFilter[])riskDataFilter.toArray());
            availableRiskItems.addAll(dynamicObjectMap.keySet());
        }
        return availableRiskItems;
    }
}

