/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.rsa.model.RiskCheckFatvsStatisticsDTO;

public class RiskCheckStatisticsHelper {
    private static final Log logger = LogFactory.getLog(RiskCheckStatisticsHelper.class);

    public static Integer getRiskStatisticTotalCount(Date startTime, Date endTime) {
        int totalCount = 0;
        try (DataSet exeLogsDs = QueryServiceHelper.queryDataSet((String)"kd.data.rsa.helper.getRiskStatisticsDto", (String)"rsa_exelog", (String)"scandatacount", (QFilter[])new QFilter[]{new QFilter("checktime", ">=", (Object)startTime).and("checktime", "<=", (Object)endTime)}, null);){
            if (exeLogsDs != null) {
                while (exeLogsDs.hasNext()) {
                    Row next = exeLogsDs.next();
                    Integer scanDataCount = next.getInteger("scandatacount");
                    totalCount += scanDataCount.intValue();
                }
            }
        }
        catch (Exception ex) {
            logger.error("[DATA-RAS] GetTotalCount error", (Throwable)ex);
        }
        logger.info("[DATA-RSA] FATVS totalCount : " + totalCount);
        return totalCount;
    }

    public static RiskCheckFatvsStatisticsDTO getRiskStatisticsDto() {
        Calendar calendar = Calendar.getInstance();
        int currentMonth = calendar.get(2);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date firstDayOfMonth = calendar.getTime();
        calendar.set(2, 0);
        Date firstDayOfYear = calendar.getTime();
        calendar.set(2, currentMonth);
        int lastDayCurrentMonth = calendar.getActualMaximum(5);
        calendar.set(5, lastDayCurrentMonth);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date lastDayOfMonth = calendar.getTime();
        calendar.set(2, 11);
        int lastDayDecember = calendar.getActualMaximum(5);
        calendar.set(5, lastDayDecember);
        Date lastDayOfYear = calendar.getTime();
        HashSet<Long> orgIds = new HashSet<Long>(20);
        HashSet<Long> riskIds = new HashSet<Long>(20);
        HashSet<Long> riskItemIds = new HashSet<Long>(20);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.data.rsa.helper.getRiskStatisticsDto.distinct", (String)"rsa_exelog", (String)"org, risk, riskitem", (QFilter[])new QFilter[]{new QFilter("checktime", ">=", (Object)firstDayOfMonth).and("checktime", "<=", (Object)lastDayOfMonth)}, null);){
            if (dataSet != null) {
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    orgIds.add(next.getLong("org"));
                    if (next.getLong("risk") != null && next.getLong("risk") != 0L) {
                        riskIds.add(next.getLong("risk"));
                    }
                    if (next.getLong("riskitem") == null || next.getLong("riskitem") == 0L) continue;
                    riskItemIds.add(next.getLong("riskitem"));
                }
            }
        }
        catch (Exception ex) {
            logger.error("[DATA-RAS] Get distinctInfo error", (Throwable)ex);
        }
        int monthScanCount = ORM.create().count("kd.data.rsa.helper.monthcount", "rsa_riskevent", new QFilter[]{new QFilter("checktime", ">=", (Object)firstDayOfMonth).and("checktime", "<=", (Object)lastDayOfMonth)});
        int yearScanCount = ORM.create().count("kd.data.rsa.helper.yearcount", "rsa_riskevent", new QFilter[]{new QFilter("checktime", ">=", (Object)firstDayOfYear).and("checktime", "<=", (Object)lastDayOfYear)});
        return new RiskCheckFatvsStatisticsDTO(orgIds.size(), riskIds.size(), riskItemIds.size(), monthScanCount, yearScanCount, 0);
    }
}

