/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.RiskEventStatusEnum;

public class RiskEventHelper {
    private static final String ALGO_KEY = RiskEventHelper.class.getName();

    private RiskEventHelper() {
    }

    public static void processEvent(Object[] pks, RiskEventStatusEnum status, String remark) {
        DynamicObject[] eventObjs;
        for (DynamicObject eventObj : eventObjs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"rsa_riskevent"))) {
            eventObj.set("status", (Object)status.getCode());
            DynamicObjectCollection remarkEntryEntity = eventObj.getDynamicObjectCollection("remarkentryentity");
            DynamicObject entry = new DynamicObject(remarkEntryEntity.getDynamicObjectType());
            entry.set("remarkstatus", (Object)status.getCode());
            entry.set("processremark", (Object)remark);
            entry.set("remarkdate", (Object)new Date());
            entry.set("remarkuser", (Object)RequestContext.get().getCurrUserId());
            remarkEntryEntity.add((Object)entry);
        }
        SaveServiceHelper.save((DynamicObject[])eventObjs);
    }

    public static String genRiskEventName(String entityName, String riskLevelName, String periodName) {
        if (StringUtils.isNotEmpty((String)riskLevelName) && StringUtils.isNotEmpty((String)periodName)) {
            if (StringUtils.isEmpty((String)entityName)) {
                entityName = "";
            }
            if (entityName.length() > 140) {
                entityName = entityName.substring(0, 140);
            }
            if (riskLevelName.length() > 50) {
                riskLevelName = riskLevelName.substring(0, 50);
            }
            if (periodName.length() > 50) {
                periodName = periodName.substring(0, 50);
            }
            return entityName + "-" + riskLevelName + "-" + periodName + "-";
        }
        return " ";
    }
}

