/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RiskGroupHelper {
    private static final String ALGO_KEY = RiskGroupHelper.class.getName();
    private static Log logger = LogFactory.getLog(RiskGroupHelper.class);

    private RiskGroupHelper() {
    }

    public static List<Long> getSubGroupListById(Long groupId) {
        DynamicObject groupDy = BusinessDataServiceHelper.loadSingleFromCache((Object)groupId, (String)"rsa_riskgroup");
        String number = groupDy.getString("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            return new ArrayList<Long>();
        }
        QFilter numberFilter = new QFilter("longnumber", "like", (Object)('%' + number + '%'));
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map groupMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_riskgroup", (String)"id", (QFilter[])new QFilter[]{numberFilter, statusFilter, enableFilter});
        return groupMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }
}

