/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.rsa.func.RiskAnaEntryReduceGroupFunc;
import kd.data.rsa.func.RiskHeatMapFilterFunc;
import kd.data.rsa.model.RiskHeatMapModel;
import kd.data.rsa.utils.DateUtil;

public class RiskHelper {
    private static final String ALGO_KEY = RiskHelper.class.getName();
    private static Log logger = LogFactory.getLog(RiskHelper.class);

    private RiskHelper() {
    }

    public static void updateOverDue(Long pkId) {
        DynamicObject riskDy = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"rsa_risk");
        if (riskDy == null) {
            return;
        }
        boolean updateFlag = false;
        Date curDate = DateUtil.getCurrentDate();
        DynamicObjectCollection anaEntryDyCol = riskDy.getDynamicObjectCollection("calentryentity");
        for (DynamicObject entryDy : anaEntryDyCol) {
            Date planDate = entryDy.getDate("c_plandate");
            String isOverDue = entryDy.getString("c_isoverdue");
            if (planDate == null || StringUtils.equals((CharSequence)"1", (CharSequence)isOverDue) || DateUtil.getDiffDays(planDate, curDate) <= 1) continue;
            entryDy.set("c_isoverdue", (Object)"1");
            updateFlag = true;
        }
        if (updateFlag) {
            SaveServiceHelper.update((DynamicObject)riskDy);
        }
    }

    public static void batchUpdateOverDue() {
        Date curDate = DateUtil.getCurrentDate();
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter overDueFilter = new QFilter("calentryentity.c_isoverdue", "=", (Object)"0");
        DynamicObject[] riskDys = BusinessDataServiceHelper.load((String)"rsa_risk", (String)"id,calentryentity.c_isoverdue", (QFilter[])new QFilter[]{statusFilter, overDueFilter}, null, (int)-1);
        if (riskDys == null || riskDys.length == 0) {
            return;
        }
        ArrayList<DynamicObject> updateDyList = new ArrayList<DynamicObject>(riskDys.length);
        for (DynamicObject riskDy : riskDys) {
            boolean updateFlag = false;
            DynamicObjectCollection anaEntryDyCol = riskDy.getDynamicObjectCollection("calentryentity");
            for (DynamicObject entryDy : anaEntryDyCol) {
                Date planDate = entryDy.getDate("c_plandate");
                String isOverDue = entryDy.getString("c_isoverdue");
                if (planDate == null || StringUtils.equals((CharSequence)"1", (CharSequence)isOverDue) || DateUtil.getDiffDays(planDate, curDate) <= 1) continue;
                entryDy.set("c_isoverdue", (Object)"1");
                updateFlag = true;
            }
            if (!updateFlag) continue;
            updateDyList.add(riskDy);
        }
        if (!updateDyList.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateDyList.toArray(new DynamicObject[0]));
        }
    }

    public static void batchUpdateStatistics(List<Long> riskIdList) {
        try (DataSet riskDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"rsa_risk", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", riskIdList)}, null, (int)100000);
             DataSet eventDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"rsa_riskevent", (String)"id eventid,risk riskid", (QFilter[])new QFilter[]{new QFilter("risk", "in", riskIdList)}, null);
             DataSet eventStatisticsDataSet = riskDataSet.copy().select("id").leftJoin(eventDataSet).on("id", "riskid").select(new String[]{"riskid", "eventid"}).finish().groupBy(new String[]{"riskid"}).count("riskeventnum").finish().select(new String[]{"riskid", "riskeventnum"});
             DataSet workDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"rsa_riskwork", (String)"id workid,riskid,lossamount", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"C", "D", "E"}), new QFilter("riskid", "in", riskIdList)}, null);
             DataSet workStatisticsDataSet = riskDataSet.copy().select("id").leftJoin(workDataSet).on("id", "riskid").select(new String[]{"riskid", "workid", "lossamount"}).finish().groupBy(new String[]{"riskid"}).count("riskworknum").sum("lossamount").finish().select(new String[]{"riskid", "lossamount", "riskworknum"});
             DataSet resultDataSet = riskDataSet.leftJoin(eventStatisticsDataSet).on("id", "riskid").select(new String[]{"id", "riskeventnum"}).finish().leftJoin(workStatisticsDataSet).on("id", "riskid").select(new String[]{"id", "lossamount", "riskeventnum", "riskworknum"}).finish();){
            DynamicObjectCollection resultDyCol = ORM.create().toPlainDynamicObjectCollection(resultDataSet);
            if (resultDyCol.isEmpty()) {
                return;
            }
            Map<Long, DynamicObject> resultMap = resultDyCol.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
            QFilter idFilter = new QFilter("id", "in", resultMap.keySet());
            DynamicObject[] riskDys = BusinessDataServiceHelper.load((String)"rsa_risk", (String)"id,lossamount,riskeventnum,riskworknum", (QFilter[])new QFilter[]{idFilter});
            ArrayList<DynamicObject> updateDyList = new ArrayList<DynamicObject>(riskDys.length);
            for (DynamicObject riskDy : riskDys) {
                long id = riskDy.getLong("id");
                DynamicObject resultDy = resultMap.get(id);
                if (resultDy == null) continue;
                BigDecimal lossAmount = resultDy.getBigDecimal("lossamount");
                long riskEventNum = resultDy.getLong("riskeventnum");
                long riskWorkNum = resultDy.getLong("riskworknum");
                riskDy.set("lossamount", (Object)lossAmount);
                riskDy.set("riskeventnum", (Object)riskEventNum);
                riskDy.set("riskworknum", (Object)riskWorkNum);
                updateDyList.add(riskDy);
            }
            if (!updateDyList.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateDyList.toArray(new DynamicObject[0]));
            }
        }
    }

    public static DataSet getHeatMapListDataSet(List<QFilter> qFilters, Map<String, Object> extraParamMap) {
        DataSet initDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"rsa_risk", (String)"id,billno,name,group,riskdesc,iskeyrisk,risklevel,billstatus,riskscore,lossamount,riskeventnum,riskworknum,dutyorg,identifydate,anaentryentity.a_name,anaentryentity.a_resultscore,anaentryentity.a_occscore", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"billno desc", (int)100000);
        return initDataSet.groupBy(new String[]{"id"}).reduceGroup((ReduceGroupFunctionWithCollector)new RiskAnaEntryReduceGroupFunc(initDataSet.getRowMeta())).filter((FilterFunction)new RiskHeatMapFilterFunc(extraParamMap));
    }

    /*
     * Exception decompiling
     */
    public static List<RiskHeatMapModel.CellModel> getHeatMapData(List<QFilter> qFilters, RiskHeatMapModel riskHeatMapModel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> checkRepeatEval(List<Long> riskIdList) {
        if (riskIdList == null || riskIdList.isEmpty()) {
            return new ArrayList<String>();
        }
        QFilter idFilter = new QFilter("id", "in", riskIdList);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"A");
        QFilter anaEntryNameFilter = new QFilter("anaentryentity.a_name", "=", (Object)"0");
        QFilter anaResultScoreFilter = new QFilter("anaentryentity.a_resultscore", "!=", (Object)0);
        QFilter anaOccScoreFilter = new QFilter("anaentryentity.a_occscore", "!=", (Object)0);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"rsa_risk", (String)"id,billno", (QFilter[])new QFilter[]{idFilter, billStatusFilter, anaEntryNameFilter, anaResultScoreFilter, anaOccScoreFilter}, null);){
            ArrayList<String> billNoList = new ArrayList<String>();
            for (Row row : dataSet) {
                String billNo = row.getString("billno");
                billNoList.add(billNo);
            }
            ArrayList<String> arrayList = billNoList;
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    public static List<Map<String, String>> checkDoingEval(List<Long> riskIdList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<Map<String, String>> checkFinishCal(List<Long> riskIdList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ RiskHeatMapModel.CellModel lambda$getHeatMapData$3(RiskHeatMapModel.CellModel cellModel1, RiskHeatMapModel.CellModel cellModel2) {
        return cellModel1;
    }

    private static /* synthetic */ RiskHeatMapModel.CellModel lambda$getHeatMapData$2(RiskHeatMapModel.CellModel cellModel) {
        return cellModel;
    }
}

