/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class RiskLevelEvalCriteriaHelper {
    private static final Log logger = LogFactory.getLog(RiskLevelEvalCriteriaHelper.class);

    private RiskLevelEvalCriteriaHelper() {
    }

    public static DynamicObject getSingle(Long occId, Long resultId) {
        QFilter evaOccFilter = new QFilter("occurpossibilityid", "=", (Object)occId);
        QFilter evaResFilter = new QFilter("resulteffectid", "=", (Object)resultId);
        QFilter evaEnableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter evaStatusFilter = new QFilter("status", "=", (Object)"C");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"rsa_risklevelevacriteria", (QFilter[])new QFilter[]{evaOccFilter, evaResFilter, evaEnableFilter, evaStatusFilter});
    }

    public static DynamicObject getSingle(BigDecimal occScore, BigDecimal resultScore) {
        QFilter resultSourceFilter = new QFilter("scorefrom", "<", (Object)resultScore).and("scoreto", ">=", (Object)resultScore);
        QFilter resultEnableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter resultStatusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject resDy = BusinessDataServiceHelper.loadSingleFromCache((String)"rsa_resulteffect", (QFilter[])new QFilter[]{resultSourceFilter, resultEnableFilter, resultStatusFilter});
        if (resDy == null) {
            return null;
        }
        QFilter occSourceFilter = new QFilter("scorefrom", "<", (Object)occScore).and("scoreto", ">=", (Object)occScore);
        QFilter occEnableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter occStatusFilter = new QFilter("status", "=", (Object)"C");
        DynamicObject occDy = BusinessDataServiceHelper.loadSingleFromCache((String)"rsa_occurpossibility", (QFilter[])new QFilter[]{occSourceFilter, occEnableFilter, occStatusFilter});
        if (occDy == null) {
            return null;
        }
        return RiskLevelEvalCriteriaHelper.getSingle(occDy.getLong("id"), resDy.getLong("id"));
    }

    public static void updateRiskLevelEvaCriteria() {
        try (TXHandle h = TX.required((String)"rsa_risklevelevacriteria_dataRefresh");){
            try {
                Object next;
                LinkedHashMap<Long, Integer> occurpossibilityMap = new LinkedHashMap<Long, Integer>(10);
                try (DataSet rows = QueryServiceHelper.queryDataSet((String)"rsa.formplugin.risksetting.occurpossibility", (String)"rsa_occurpossibility", (String)"id, scorefrom", null, (String)"scorefrom desc");){
                    while (rows.hasNext()) {
                        next = rows.next();
                        occurpossibilityMap.put(next.getLong("id"), next.getInteger("scorefrom"));
                    }
                }
                LinkedHashMap<Long, Integer> resulteffectMap = new LinkedHashMap<Long, Integer>(10);
                DataSet rows = QueryServiceHelper.queryDataSet((String)"rsa.formplugin.risksetting.resulteffect", (String)"rsa_resulteffect", (String)"id, scorefrom", null, (String)"scorefrom desc");
                next = null;
                try {
                    while (rows.hasNext()) {
                        Row next2 = rows.next();
                        resulteffectMap.put(next2.getLong("id"), next2.getInteger("scorefrom"));
                    }
                }
                catch (Throwable next2) {
                    next = next2;
                    throw next2;
                }
                finally {
                    if (rows != null) {
                        if (next != null) {
                            try {
                                rows.close();
                            }
                            catch (Throwable next2) {
                                ((Throwable)next).addSuppressed(next2);
                            }
                        } else {
                            rows.close();
                        }
                    }
                }
                HashMap<String, String> existCombinationMap = new HashMap<String, String>(20);
                HashMap<String, Long> combinIdMap = new HashMap<String, Long>(20);
                try (DataSet rows2 = QueryServiceHelper.queryDataSet((String)"rsa.formplugin.risksetting.RiskLevelEvaCriteria", (String)"rsa_risklevelevacriteria", (String)"id, number, occurpossibilityid, resulteffectid", null, null);){
                    while (rows2.hasNext()) {
                        Row next3 = rows2.next();
                        String string = next3.getString("occurpossibilityid") + next3.getString("resulteffectid");
                        existCombinationMap.put(string, next3.getString("number"));
                        combinIdMap.put(string, next3.getLong("id"));
                    }
                }
                ArrayList<DynamicObject> addEvacriteriaList = new ArrayList<DynamicObject>(10);
                HashMap needUpdateEvacriteriaMap = new HashMap(10);
                if (!occurpossibilityMap.isEmpty() && !resulteffectMap.isEmpty()) {
                    for (Map.Entry entry : occurpossibilityMap.entrySet()) {
                        for (Map.Entry effectEntry : resulteffectMap.entrySet()) {
                            String key = ((Long)entry.getKey()).toString() + effectEntry.getKey();
                            String number = ((Integer)entry.getValue()).toString() + effectEntry.getValue();
                            if (existCombinationMap.containsKey(key) && !((String)existCombinationMap.get(key)).equals(number)) {
                                needUpdateEvacriteriaMap.put(combinIdMap.get(key), number);
                                continue;
                            }
                            if (existCombinationMap.containsKey(key)) continue;
                            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"rsa_risklevelevacriteria");
                            dyn.set("occurpossibilityid", entry.getKey());
                            dyn.set("resulteffectid", effectEntry.getKey());
                            dyn.set("number", (Object)number);
                            dyn.set("status", (Object)"C");
                            dyn.set("enable", (Object)"1");
                            addEvacriteriaList.add(dyn);
                        }
                    }
                }
                if (!needUpdateEvacriteriaMap.isEmpty()) {
                    DynamicObject[] loadDyn;
                    for (DynamicObject dyn : loadDyn = BusinessDataServiceHelper.load((Object[])needUpdateEvacriteriaMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rsa_risklevelevacriteria"))) {
                        dyn.set("number", needUpdateEvacriteriaMap.get(dyn.getLong("id")));
                    }
                    SaveServiceHelper.update((DynamicObject[])loadDyn);
                }
                if (!addEvacriteriaList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])addEvacriteriaList.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }
}

