/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.rsa.enums.RiskExeLogResultStatusEnum;
import kd.data.rsa.helper.CodeRuleHelper;
import kd.data.rsa.helper.EarlyWarnHelper;
import kd.data.rsa.helper.RiskEventHelper;
import kd.data.rsa.helper.RiskHelper;
import kd.data.rsa.model.RiskCalculateDTO;
import kd.data.rsa.model.RiskCheckStatisticsDTO;
import kd.data.rsa.model.RiskEventModel;
import kd.data.rsa.model.RiskLogModel;

public class RiskLogHelper {
    private static final Log logger = LogFactory.getLog(RiskLogHelper.class);

    private RiskLogHelper() {
    }

    public static List<Object> save(List<RiskLogModel> exeLogList) {
        if (exeLogList == null || exeLogList.isEmpty()) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> result = new ArrayList<Object>(exeLogList.size());
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1400);
        int length = 1000;
        for (RiskLogModel model : exeLogList) {
            DynamicObject eventObj = model.toDynamicObject();
            list.add(eventObj);
            if (list.size() < length) continue;
            result.addAll(RiskLogHelper.doSave(list.toArray(new DynamicObject[0])));
            list.clear();
        }
        if (!list.isEmpty()) {
            result.addAll(RiskLogHelper.doSave(list.toArray(new DynamicObject[0])));
            list.clear();
        }
        return result;
    }

    public static List<Object> doSave(DynamicObject[] datas) {
        OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)"rsa_exelog", (DynamicObject[])datas, (OperateOption)OperateOption.create());
        return save.getSuccessPkIds();
    }

    public static void saveRiskExeLog(String taskKey, String timeType, List<Object> orgList, Object periodIds, Long riskItemId, String errorMessage, boolean isError, RiskCheckStatisticsDTO statisticsDTO, int type, Long riskId) {
        if (orgList != null && !orgList.isEmpty()) {
            Date date = new Date();
            ArrayList<RiskLogModel> exeLogList = new ArrayList<RiskLogModel>(orgList.size());
            String statusCode = isError ? RiskExeLogResultStatusEnum.FAIL.getCode() : RiskExeLogResultStatusEnum.SUCCESS.getCode();
            for (Object orgId : orgList) {
                exeLogList.add(new RiskLogModel(taskKey, Long.parseLong(orgId.toString()), periodIds == null ? 0L : Long.parseLong(periodIds.toString()), riskItemId, statusCode, errorMessage, null, date, timeType, riskId, type));
            }
            List<Object> objectList = RiskLogHelper.save(exeLogList);
            statisticsDTO.addExeLogIds(objectList);
        }
    }

    public static void saveRiskExeLogAndEvent(String taskKey, String timeType, Long orgId, Long periodId, RiskCalculateDTO riskDto, RiskCheckStatisticsDTO statisticsDTO, List<RiskEventModel> riskEventDynList, int scanCount, int type, boolean noCodeRule) {
        if (riskEventDynList != null && !riskEventDynList.isEmpty()) {
            RiskLogModel logModel = new RiskLogModel(taskKey, orgId, periodId, riskDto.getRiskItem().getLong("id"), RiskExeLogResultStatusEnum.SUCCESS.getCode(), "", null, new Date(), timeType, 0L, scanCount, type);
            if (noCodeRule) {
                logModel.setResultStatus(RiskExeLogResultStatusEnum.FAIL.getCode());
                logModel.setFailMessage(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u98ce\u9669\u9884\u8b66\u7684\u53ef\u7528\u7684\u7f16\u53f7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u7f16\u53f7\u89c4\u5219\u914d\u7f6e\u60c5\u51b5\u3002", (String)"RiskLogHelper_0", (String)"data-rsa-business", (Object[])new Object[0]));
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"rsa_exelog", (DynamicObject[])new DynamicObject[]{logModel.toDynamicObject()}, (OperateOption)OperateOption.create());
                statisticsDTO.addExeLogIds(result.getSuccessPkIds());
                return;
            }
            ArrayList<Object[]> saveList = new ArrayList<Object[]>(riskEventDynList.size());
            for (RiskEventModel riskEvent : riskEventDynList) {
                Object[] dynamicObject = riskEvent.toDynamicObject();
                String billNo = CodeRuleHelper.generateNumber((String)"rsa_riskevent", (DynamicObject)dynamicObject, null, (String)("riskEvent-" + Uuid8.generateShortUuid()));
                int length = billNo.length();
                String serialNumber = length > 4 ? billNo.substring(length - 4, length) : billNo;
                dynamicObject.set("billno", (Object)billNo);
                dynamicObject.set("name", (Object)(riskEvent.getName() + serialNumber));
                saveList.add(dynamicObject);
            }
            Object[] save = SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
            ArrayList<Long> riskEventIds = new ArrayList<Long>(save.length);
            for (Object riskEvent : save) {
                long riskEventId = ((DynamicObject)riskEvent).getLong("id");
                statisticsDTO.addRiskEventCount(orgId, timeType, riskEventId);
                riskEventIds.add(riskEventId);
            }
            if (save.length > 0) {
                EarlyWarnHelper.execute();
            }
            logModel.setRiskEventIds(ArrayUtils.toPrimitive((Long[])riskEventIds.toArray(new Long[0])));
            riskEventDynList.clear();
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"rsa_exelog", (DynamicObject[])new DynamicObject[]{logModel.toDynamicObject()}, (OperateOption)OperateOption.create());
            statisticsDTO.addExeLogIds(result.getSuccessPkIds());
        }
    }

    public static void saveRiskExeLogAndEvent(String taskKey, Map<Long, DynamicObject> riskDynMap, RiskCheckStatisticsDTO statisticsDTO, Map<Long, Integer> riskScanCountMap, int type, boolean noCodeRule, Map<Object, DynamicObject> riskMap, Map<Long, String> risklevelMap, String date) {
        if (noCodeRule) {
            for (DynamicObject riskEventDyn : riskDynMap.values()) {
                ArrayList<Long> riskItemIds = new ArrayList<Long>(10);
                DynamicObjectCollection entryentity = riskEventDyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    long riskItemId = entry.getLong("riskriskitem");
                    if (riskItemIds.contains(riskItemId)) continue;
                    riskItemIds.add(riskItemId);
                    String timeType = entry.getString("timetypeentry");
                    long periodId = "bd_period".equals(timeType) ? riskEventDyn.getLong("accountperiod_id") : riskEventDyn.getLong("analysisperiod_id");
                    long riskId = riskEventDyn.getLong("risk");
                    RiskLogModel logModel = new RiskLogModel(taskKey, riskEventDyn.getLong("org_id"), periodId, entry.getLong("riskriskitem"), RiskExeLogResultStatusEnum.FAIL.getCode(), ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u98ce\u9669\u9884\u8b66\u7684\u53ef\u7528\u7684\u7f16\u53f7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u7f16\u53f7\u89c4\u5219\u914d\u7f6e\u60c5\u51b5\u3002", (String)"RiskLogHelper_0", (String)"data-rsa-business", (Object[])new Object[0]), null, new Date(), timeType, riskId, riskScanCountMap.remove(riskId), type);
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"rsa_exelog", (DynamicObject[])new DynamicObject[]{logModel.toDynamicObject()}, (OperateOption)OperateOption.create());
                    statisticsDTO.addExeLogIds(result.getSuccessPkIds());
                }
            }
            return;
        }
        try {
            RiskLogHelper.setMinSeqRiskLevel(riskDynMap);
            RiskLogHelper.setBillnoAndName(riskDynMap, riskMap, date, risklevelMap);
            Object[] save = SaveServiceHelper.save((DynamicObject[])riskDynMap.values().toArray(new DynamicObject[0]));
            RiskHelper.batchUpdateStatistics(new ArrayList<Long>(riskDynMap.keySet()));
            for (Object riskEvent : save) {
                ArrayList<Long> riskItemIds = new ArrayList<Long>(10);
                DynamicObject riskEventDyn = (DynamicObject)riskEvent;
                DynamicObjectCollection entryentity = riskEventDyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentity) {
                    long riskItemId = entry.getLong("riskriskitem");
                    statisticsDTO.addRiskEventCount(riskEventDyn.getLong("org_id"), entry.getString("timetypeentry"), riskEventDyn.getLong("id"));
                    if (riskItemIds.contains(riskItemId)) continue;
                    riskItemIds.add(riskItemId);
                    String timeType = entry.getString("timetypeentry");
                    long periodId = "bd_period".equals(timeType) ? riskEventDyn.getLong("accountperiod_id") : riskEventDyn.getLong("analysisperiod_id");
                    long riskId = riskEventDyn.getLong("risk_id");
                    RiskLogModel logModel = new RiskLogModel(taskKey, riskEventDyn.getLong("org_id"), periodId, entry.getLong("riskriskitem_id"), RiskExeLogResultStatusEnum.SUCCESS.getCode(), "", new long[]{riskEventDyn.getLong("id")}, new Date(), timeType, riskId, riskScanCountMap.remove(riskId), type);
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"rsa_exelog", (DynamicObject[])new DynamicObject[]{logModel.toDynamicObject()}, (OperateOption)OperateOption.create());
                    statisticsDTO.addExeLogIds(result.getSuccessPkIds());
                }
            }
            if (save.length > 0) {
                EarlyWarnHelper.execute();
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e8b\u52a1\u5f02\u5e38\uff1a %s", (String)"RiskLogHelper_1", (String)"data-rsa-business", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private static void setBillnoAndName(Map<Long, DynamicObject> riskDynMap, Map<Object, DynamicObject> riskMap, String date, Map<Long, String> risklevelMap) {
        for (Map.Entry<Long, DynamicObject> entry : riskDynMap.entrySet()) {
            DynamicObject riskEvent = entry.getValue();
            String name = RiskEventHelper.genRiskEventName(riskMap.get(entry.getKey()).getString("name"), risklevelMap.get(riskEvent.getLong("risklevel_id")), date);
            String billNo = CodeRuleHelper.generateNumber((String)"rsa_riskevent", (DynamicObject)riskEvent, null, (String)("riskEvent-" + Uuid8.generateShortUuid()));
            int length = billNo.length();
            String serialNumber = length > 4 ? billNo.substring(length - 4, length) : billNo;
            riskEvent.set("billno", (Object)billNo);
            riskEvent.set("name", (Object)(name + serialNumber));
        }
    }

    private static void setMinSeqRiskLevel(Map<Long, DynamicObject> riskDynMap) {
        for (DynamicObject riskEvent : riskDynMap.values()) {
            DynamicObjectCollection entryEntity = riskEvent.getDynamicObjectCollection("entryentity");
            ArrayList<Long> riskLevelIds = new ArrayList<Long>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                riskLevelIds.add(entry.getLong("earlywarnlevel"));
            }
            List riskLevelIdList = QueryServiceHelper.queryPrimaryKeys((String)"rsa_risklevel", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)riskLevelIds.toArray())}, (String)"risklevelseq", (int)1);
            if (riskLevelIdList.isEmpty()) continue;
            riskEvent.set("risklevel_id", riskLevelIdList.get(0));
        }
    }
}

