/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RiskCheckStatisticsDTO
implements Serializable {
    private static final long serialVersionUID = -3097710424066231781L;
    private int failRiskItemCount;
    private Map<String, Set<Long>> riskEventCountMap;
    private Map<String, Set<Long>> riskItemCountMap;
    private Map<String, Set<Long>> errorRiskItemMap;
    private Map<String, Set<Long>> riskCountMap;
    private Map<String, Set<Long>> errorRiskMap;
    private List<Object> exeLogIds;
    private int riskCount;
    private int errorRiskCount;

    public RiskCheckStatisticsDTO() {
    }

    public RiskCheckStatisticsDTO(int mapSize) {
        this.failRiskItemCount = 0;
        this.riskEventCountMap = new HashMap<String, Set<Long>>(mapSize);
        this.riskItemCountMap = new HashMap<String, Set<Long>>(mapSize);
        this.riskCountMap = new HashMap<String, Set<Long>>(mapSize);
        this.exeLogIds = new ArrayList<Object>(mapSize);
        this.errorRiskItemMap = new HashMap<String, Set<Long>>(mapSize);
        this.errorRiskMap = new HashMap<String, Set<Long>>(mapSize);
    }

    public void addFailRiskItem() {
        ++this.failRiskItemCount;
    }

    public void addRiskEventCount(Long orgId, String timeType, Long riskEventId) {
        if (riskEventId == null || riskEventId.equals(0L)) {
            return;
        }
        String key = orgId + "-" + timeType;
        if (this.riskEventCountMap.get(key) == null) {
            HashSet<Long> riskEventList = new HashSet<Long>(10);
            riskEventList.add(riskEventId);
            this.riskEventCountMap.putIfAbsent(key, riskEventList);
        } else {
            this.riskEventCountMap.get(key).add(riskEventId);
        }
    }

    public void addRiskId(Object[] orgIds, String timeType, List<Long> riskIds, boolean success, Map<Long, Long> riskDutyOrgMap) {
        if (riskDutyOrgMap == null) {
            return;
        }
        HashSet<Object> orgIdSet = new HashSet<Object>(Arrays.asList(orgIds));
        for (Long riskId : riskIds) {
            String key;
            Long orgId = riskDutyOrgMap.get(riskId);
            if (!orgIdSet.contains(orgId)) continue;
            Map<String, Set<Long>> processMap = success ? this.riskCountMap : this.errorRiskMap;
            if (processMap.get(key = orgId + "-" + timeType) == null) {
                HashSet<Long> riskSet = new HashSet<Long>(10);
                riskSet.add(riskId);
                processMap.putIfAbsent(key, riskSet);
                continue;
            }
            processMap.get(key).add(riskId);
        }
    }

    public void addRiskItemId(Object[] orgIds, String timeType, Long riskItemId, boolean success) {
        Object[] objectArray = orgIds;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object orgId;
            String key;
            Map<String, Set<Long>> processMap = success ? this.riskItemCountMap : this.errorRiskItemMap;
            if (processMap.get(key = (orgId = objectArray[i]) + "-" + timeType) == null) {
                HashSet<Long> riskItemList = new HashSet<Long>(10);
                riskItemList.add(riskItemId);
                processMap.putIfAbsent(key, riskItemList);
                continue;
            }
            processMap.get(key).add(riskItemId);
        }
    }

    public void removeErrorRisk(Set<Long> errorRiskId) {
        if (this.riskCountMap != null && !this.riskCountMap.isEmpty()) {
            for (Map.Entry<String, Set<Long>> riskEntry : this.riskCountMap.entrySet()) {
                riskEntry.getValue().removeAll(errorRiskId);
            }
        }
    }

    public void addExeLogIds(List<Object> exeLogIds) {
        this.exeLogIds.addAll(exeLogIds);
    }

    public int getFailRiskItemCount() {
        return this.failRiskItemCount;
    }

    public void setFailRiskItemCount(int failRiskItemCount) {
        this.failRiskItemCount = failRiskItemCount;
    }

    public Map<String, Set<Long>> getRiskEventCountMap() {
        return this.riskEventCountMap;
    }

    public Map<String, Set<Long>> getRiskItemCountMap() {
        return this.riskItemCountMap;
    }

    public List<Object> getExeLogIds() {
        return this.exeLogIds;
    }

    public int getRiskCount() {
        return this.riskCount;
    }

    public void setRiskCount(int riskCount) {
        this.riskCount = riskCount;
    }

    public int getErrorRiskCount() {
        return this.errorRiskCount;
    }

    public void setErrorRiskCount(int errorRiskCount) {
        this.errorRiskCount = errorRiskCount;
    }

    public Map<String, Set<Long>> getRiskCountMap() {
        return this.riskCountMap;
    }

    public Map<String, Set<Long>> getErrorRiskItemMap() {
        return this.errorRiskItemMap;
    }

    public Map<String, Set<Long>> getErrorRiskMap() {
        return this.errorRiskMap;
    }
}

