/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.data.rsa.enums.HeatDiagramColorEnum;

public class RiskHeatMapModel
implements Serializable {
    private static final long serialVersionUID = 6945047405930756155L;
    private static final String REGEX = "-";
    private final List<XAxisModel> xAxisModelList;
    private final List<YAxisModel> yAxisModelList;
    private final List<CellModel> cellModelList;

    public RiskHeatMapModel(List<XAxisModel> xAxisModelList, List<YAxisModel> yAxisModelList, List<CellModel> cellModelList) {
        this.xAxisModelList = xAxisModelList;
        this.yAxisModelList = yAxisModelList;
        this.cellModelList = cellModelList;
    }

    public static RiskHeatMapModel create() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        Map occurMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_occurpossibility", (String)"id,name,scorefrom,scoreto", (QFilter[])new QFilter[]{enableFilter, statusFilter});
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_resulteffect", (String)"id,name,scorefrom,scoreto", (QFilter[])new QFilter[]{enableFilter, statusFilter});
        Map levelEvalMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risklevelevacriteria", (String)"id,occurpossibilityid,resulteffectid,risklevelid.name,risklevelid.heatdiacolor", (QFilter[])new QFilter[]{enableFilter, statusFilter});
        List<XAxisModel> xAxisModelList = resultMap.values().stream().map(resultDy -> {
            String key = resultDy.get("id").toString();
            String label = resultDy.getString("name");
            int min = resultDy.getInt("scorefrom");
            int max = resultDy.getInt("scoreto");
            return new XAxisModel(key, label, min, max);
        }).sorted(Comparator.comparing(xAxisModel -> ((XAxisModel)xAxisModel).min)).collect(Collectors.toList());
        List<YAxisModel> yAxisModelList = occurMap.values().stream().map(resultDy -> {
            String key = resultDy.get("id").toString();
            String label = resultDy.getString("name");
            int min = resultDy.getInt("scorefrom");
            int max = resultDy.getInt("scoreto");
            return new YAxisModel(key, label, min, max);
        }).sorted(Comparator.comparing(yAxisModel -> ((YAxisModel)yAxisModel).min)).collect(Collectors.toList());
        List<CellModel> cellModelList = levelEvalMap.values().stream().map(levelEvalDy -> {
            String key = RiskHeatMapModel.genCellKey(levelEvalDy.get("resulteffectid.id").toString(), levelEvalDy.get("occurpossibilityid.id").toString());
            String label = levelEvalDy.getString("risklevelid.name");
            HeatDiagramColorEnum heatDiagramColorEnum = HeatDiagramColorEnum.getEnum(levelEvalDy.getString("risklevelid.heatdiacolor"));
            String color = heatDiagramColorEnum == null ? "#CCCCCC" : heatDiagramColorEnum.getColor();
            int value = 0;
            return new CellModel(key, label, color, value);
        }).collect(Collectors.toList());
        return new RiskHeatMapModel(xAxisModelList, yAxisModelList, cellModelList);
    }

    public String getCellModelKey(BigDecimal xAxisData, BigDecimal yAxisData) {
        String xKey = "";
        for (XAxisModel xAxisModel : this.xAxisModelList) {
            BigDecimal xMin = new BigDecimal(xAxisModel.min);
            BigDecimal xMax = new BigDecimal(xAxisModel.max);
            if (xAxisData.compareTo(xMin) <= 0 || xAxisData.compareTo(xMax) > 0) continue;
            xKey = xAxisModel.key;
        }
        String yKey = "";
        for (YAxisModel yAxisModel : this.yAxisModelList) {
            BigDecimal yMin = new BigDecimal(yAxisModel.min);
            BigDecimal yMax = new BigDecimal(yAxisModel.max);
            if (yAxisData.compareTo(yMin) <= 0 || yAxisData.compareTo(yMax) > 0) continue;
            yKey = yAxisModel.key;
        }
        if (StringUtils.isEmpty((CharSequence)xKey) || StringUtils.isEmpty((CharSequence)yKey)) {
            return null;
        }
        return RiskHeatMapModel.genCellKey(xKey, yKey);
    }

    public static String genCellKey(String xKey, String yKey) {
        return xKey + REGEX + yKey;
    }

    public String[] splitCellKey(String cellKey) {
        return cellKey.split(REGEX);
    }

    public List<XAxisModel> getxAxisModelList() {
        return this.xAxisModelList;
    }

    public List<YAxisModel> getyAxisModelList() {
        return this.yAxisModelList;
    }

    public List<CellModel> getCellModelList() {
        return this.cellModelList;
    }

    public static class CellModel
    implements Serializable {
        private static final long serialVersionUID = -6475413154165119540L;
        private String key;
        private String label;
        private String color;
        private int value;

        public CellModel(String key, String label, String color, int value) {
            this.key = key;
            this.label = label;
            this.color = color;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class YAxisModel
    implements Serializable {
        private static final long serialVersionUID = -8144073060018654599L;
        private String key;
        private String label;
        private int min;
        private int max;

        public YAxisModel(String key, String label, int min, int max) {
            this.key = key;
            this.label = label;
            this.min = min;
            this.max = max;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) {
            this.min = min;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }
    }

    public static class XAxisModel
    implements Serializable {
        private static final long serialVersionUID = 63369293927678922L;
        private String key;
        private String label;
        private int min;
        private int max;

        public XAxisModel(String key, String label, int min, int max) {
            this.key = key;
            this.label = label;
            this.min = min;
            this.max = max;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) {
            this.min = min;
        }

        public int getMax() {
            return this.max;
        }

        public void setMax(int max) {
            this.max = max;
        }
    }
}

