/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.model;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RiskLogModel {
    private String taskKey;
    private long orgId;
    private long periodId;
    private long riskItemId;
    private String resultStatus;
    private String failMessage;
    private long[] riskEventIds;
    private Date checkTime;
    private String timeType;
    private long riskId;
    private int scanCount;
    private int type;

    public RiskLogModel() {
    }

    public RiskLogModel(String taskKey, long orgId, long periodId, long riskItemId, String result, String failMessage, long[] riskEventIds, Date checkTime, String timeType, long riskId, int type) {
        this.taskKey = taskKey;
        this.orgId = orgId;
        this.periodId = periodId;
        this.riskItemId = riskItemId;
        this.resultStatus = result;
        if (StringUtils.isNotEmpty((CharSequence)failMessage) && failMessage.contains("does not exist")) {
            int index = failMessage.indexOf("does not exist");
            int startIndex = failMessage.indexOf("Exception:") + "Exception:".length();
            failMessage = failMessage.contains("Exception:") && startIndex < index ? failMessage.substring(startIndex, index) + new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"RiskLogModel_0", (String)"data-rsa-business", (Object[])new Object[0])) : failMessage.substring(0, index) + new LocaleString(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728", (String)"RiskLogModel_0", (String)"data-rsa-business", (Object[])new Object[0]));
        }
        this.failMessage = failMessage;
        this.riskEventIds = riskEventIds;
        this.checkTime = checkTime;
        this.timeType = timeType;
        this.riskId = riskId;
        this.type = type;
    }

    public RiskLogModel(String taskKey, long orgId, long periodId, long riskItemId, String resultStatus, String failMessage, long[] riskEventIds, Date checkTime, String timeType, long riskId, Integer scanCount, int type) {
        this(taskKey, orgId, periodId, riskItemId, resultStatus, failMessage, riskEventIds, checkTime, timeType, riskId, type);
        this.scanCount = scanCount == null ? 0 : scanCount;
    }

    public String getTaskKey() {
        return this.taskKey;
    }

    public void setTaskKey(String taskKey) {
        this.taskKey = taskKey;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(long periodId) {
        this.periodId = periodId;
    }

    public long getRiskItemId() {
        return this.riskItemId;
    }

    public void setRiskItemId(long riskItemId) {
        this.riskItemId = riskItemId;
    }

    public String getResultStatus() {
        return this.resultStatus;
    }

    public void setResultStatus(String resultStatus) {
        this.resultStatus = resultStatus;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public void setFailMessage(String failMessage) {
        this.failMessage = failMessage;
    }

    public long[] getRiskEventIds() {
        return this.riskEventIds;
    }

    public void setRiskEventIds(long[] riskEventIds) {
        this.riskEventIds = riskEventIds;
    }

    public Date getCheckTime() {
        return this.checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public void setScanCount(int scanCount) {
        this.scanCount = scanCount;
    }

    public DynamicObject toDynamicObject() {
        DynamicObject eventObj = BusinessDataServiceHelper.newDynamicObject((String)"rsa_exelog");
        eventObj.set("org_id", (Object)this.orgId);
        eventObj.set("period_id", (Object)this.periodId);
        eventObj.set("checktime", (Object)this.checkTime);
        eventObj.set("riskitem_id", (Object)this.riskItemId);
        eventObj.set("result", (Object)this.resultStatus);
        eventObj.set("taskkey", (Object)this.taskKey);
        eventObj.set("failmessage_tag", (Object)this.failMessage);
        eventObj.set("timetype", (Object)this.timeType);
        eventObj.set("risk", (Object)this.riskId);
        eventObj.set("scandatacount", (Object)this.scanCount);
        eventObj.set("type", (Object)this.type);
        if (this.riskEventIds != null && this.riskEventIds.length > 0) {
            DynamicObjectCollection eventEntry = eventObj.getDynamicObjectCollection("entryentity");
            for (long eventId : this.riskEventIds) {
                DynamicObject entry = eventEntry.addNew();
                entry.set("eventid", (Object)String.valueOf(eventId));
            }
            eventObj.set("eventcount", (Object)this.riskEventIds.length);
        } else {
            eventObj.set("eventcount", (Object)0);
        }
        return eventObj;
    }
}

