/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.data.rsa.enums.AnalysisPeriodEnum;
import kd.data.rsa.enums.PeriodTypeEnum;
import kd.data.rsa.enums.ScanObjectEnum;
import kd.data.rsa.utils.DateUtil;

public class RiskScanDTO
implements Serializable {
    private static final long serialVersionUID = 4267944382153102040L;
    private static final Log logger = LogFactory.getLog(RiskScanDTO.class);
    private Set<Long> scanOrgIdSet;
    private String periodTypeStr;
    private Long analysisPeriodId;
    private Long accountPeriodTypeId;
    private Long accountPeriodId;
    private String scanObjectStr;
    private Set<Long> riskIdSet;
    private Set<Long> riskItemIdSet;

    public static List<RiskScanDTO> batchParseScanParam(Collection<DynamicObject> scanParamDyCollections) {
        return scanParamDyCollections.stream().map(RiskScanDTO::parseScanParam).collect(Collectors.toList());
    }

    public static RiskScanDTO parseScanParam(DynamicObject scanParamDynamicObject) {
        Set<Long> orgIdSet = null;
        DynamicObjectCollection scanOrgDyCol = scanParamDynamicObject.getDynamicObjectCollection("scanorg");
        if (scanOrgDyCol != null && !scanOrgDyCol.isEmpty()) {
            orgIdSet = scanOrgDyCol.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
        }
        String periodTypeStr = scanParamDynamicObject.getString("periodtype");
        Long analysisPeriodId = null;
        Long accountPeriodTypeId = null;
        Long accountPeriodId = null;
        if (StringUtils.isNotEmpty((CharSequence)periodTypeStr)) {
            String[] periodTypes;
            block10: for (String periodType : periodTypes = periodTypeStr.split(",")) {
                PeriodTypeEnum periodTypeEnum = PeriodTypeEnum.getPeriodTypeEnum(periodType);
                switch (periodTypeEnum) {
                    case ANALYSIS: {
                        QFilter analysisPeriodFilter = RiskScanDTO.getAnalysisPeriodQFilter(scanParamDynamicObject);
                        QFilter analysisAdjustFilter = new QFilter("isadjust", "=", (Object)"0");
                        QFilter analysisEnableFilter = new QFilter("enable", "=", (Object)"1");
                        DynamicObject analysisPeriodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"pa_analysisperiod", (QFilter[])new QFilter[]{analysisPeriodFilter, analysisEnableFilter, analysisAdjustFilter});
                        if (analysisPeriodDy == null) continue block10;
                        analysisPeriodId = analysisPeriodDy.getLong("id");
                        continue block10;
                    }
                    case ACCOUNT: {
                        accountPeriodTypeId = scanParamDynamicObject.getLong("accountperiodtype.id");
                        QFilter accountPeriodTypeFilter = new QFilter("periodtype", "=", (Object)accountPeriodTypeId);
                        QFilter accountPeriodQFilter = RiskScanDTO.getAccountPeriodQFilter(scanParamDynamicObject);
                        QFilter accountAdjustFilter = new QFilter("isadjustperiod", "=", (Object)"0");
                        DynamicObject accountPeriodDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{accountPeriodTypeFilter, accountPeriodQFilter, accountAdjustFilter});
                        if (accountPeriodDy == null) continue block10;
                        accountPeriodId = accountPeriodDy.getLong("id");
                        continue block10;
                    }
                }
            }
        }
        String scanObjectStr = scanParamDynamicObject.getString("scanobject");
        Set riskIdSet = null;
        Set<Long> riskItemIdSet = null;
        ScanObjectEnum scanObjectEnum = ScanObjectEnum.getScanObjectEnum(scanObjectStr);
        switch (scanObjectEnum) {
            case RISK: {
                String riskIds = scanParamDynamicObject.getString("riskids");
                if (StringUtils.isEmpty((CharSequence)riskIds)) {
                    QFilter dutyOrgFilter = new QFilter("dutyorg", "in", orgIdSet);
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
                    DynamicObjectCollection allRiskDyCol = QueryServiceHelper.query((String)"rsa_risk", (String)"id", (QFilter[])new QFilter[]{dutyOrgFilter, billStatusFilter});
                    if (allRiskDyCol == null || allRiskDyCol.isEmpty()) break;
                    riskIdSet = allRiskDyCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                    break;
                }
                try {
                    riskIdSet = (Set)JSON.parseObject((String)riskIds, (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
                    break;
                }
                catch (Exception e) {
                    logger.error("[DATA-RSA] RiskScanDTO Json parse error!", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u98ce\u9669\u7f16\u53f7\u96c6\u5408\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5bf9\u5e94json\u6570\u636e\u3002", (String)"RiskScanDTO_0", (String)"data-rsa-business", (Object[])new Object[0]));
                }
            }
            case RISKITEM: {
                DynamicObjectCollection riskItemDyCol = scanParamDynamicObject.getDynamicObjectCollection("riskitem");
                if (riskItemDyCol == null || riskItemDyCol.isEmpty()) {
                    QFilter enableFilter;
                    if (orgIdSet == null || orgIdSet.isEmpty()) break;
                    QFilter riskItemFilter = BaseDataServiceHelper.getBaseDataFilter((String)"rsa_riskitem", new ArrayList<Long>(orgIdSet), (boolean)true);
                    Map allRiskItemMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_riskitem", (String)"id", (QFilter[])new QFilter[]{riskItemFilter, enableFilter = new QFilter("enable", "=", (Object)"1")});
                    if (allRiskItemMap == null || allRiskItemMap.isEmpty()) break;
                    riskItemIdSet = allRiskItemMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                    break;
                }
                riskItemIdSet = riskItemDyCol.stream().map(dy -> dy.getLong("fbasedataid.id")).collect(Collectors.toSet());
                break;
            }
        }
        RiskScanDTO riskScanDTO = new RiskScanDTO();
        riskScanDTO.setScanOrgIdSet(orgIdSet);
        riskScanDTO.setPeriodTypeStr(periodTypeStr);
        riskScanDTO.setAnalysisPeriodId(analysisPeriodId);
        riskScanDTO.setAccountPeriodTypeId(accountPeriodTypeId);
        riskScanDTO.setAccountPeriodId(accountPeriodId);
        riskScanDTO.setScanObjectStr(scanObjectStr);
        riskScanDTO.setRiskIdSet(riskIdSet);
        riskScanDTO.setRiskItemIdSet(riskItemIdSet);
        return riskScanDTO;
    }

    public static QFilter getAnalysisPeriodQFilter(DynamicObject scanParamDynamicObject) {
        String analysisPeriod = scanParamDynamicObject.getString("analysisperiod");
        if (StringUtils.isEmpty((CharSequence)analysisPeriod)) {
            return null;
        }
        int year = 0;
        int quarter = 0;
        int month = 0;
        Date curDate = DateUtil.getCurrentDate();
        AnalysisPeriodEnum analysisPeriodEnum = AnalysisPeriodEnum.getAnalysisPeriodEnum(analysisPeriod);
        switch (analysisPeriodEnum) {
            case CUR_MONTH: {
                year = DateUtil.getYear(curDate);
                quarter = DateUtil.getQuarter(curDate);
                month = DateUtil.getMonth(curDate);
                break;
            }
            case LAST_MONTH: {
                Date lastMonthDate = DateUtil.getLastMonth(curDate, 1);
                year = DateUtil.getYear(lastMonthDate);
                quarter = DateUtil.getQuarter(curDate);
                month = DateUtil.getMonth(lastMonthDate);
                break;
            }
            case CUR_QUARTER: {
                year = DateUtil.getYear(curDate);
                quarter = DateUtil.getQuarter(curDate);
                break;
            }
            case LAST_QUARTER: {
                Date lastQuarterDate = DateUtil.getLastQuarter(curDate, 1);
                year = DateUtil.getYear(lastQuarterDate);
                quarter = DateUtil.getQuarter(lastQuarterDate);
                break;
            }
            case CUR_YEAR: {
                year = DateUtil.getYear(curDate);
                break;
            }
            case LAST_YEAR: {
                Date lastYearDate = DateUtil.getLastYear(curDate, 1);
                year = DateUtil.getYear(lastYearDate);
                break;
            }
        }
        return new QFilter("year", "=", (Object)year).and("quarter", "=", (Object)quarter).and("month", "=", (Object)month);
    }

    public static QFilter getAccountPeriodQFilter(DynamicObject scanParamDynamicObject) {
        String offSet = scanParamDynamicObject.getString("accountperiodoffset");
        if (StringUtils.isEmpty((CharSequence)offSet)) {
            return null;
        }
        Date curDate = DateUtil.getCurrentDate();
        Date lastMonthDate = DateUtil.getLastMonth(curDate, Integer.parseInt(offSet));
        int year = DateUtil.getYear(lastMonthDate);
        int quarter = DateUtil.getQuarter(lastMonthDate);
        int month = DateUtil.getMonth(lastMonthDate);
        return new QFilter("periodyear", "=", (Object)year).and("periodquarter", "=", (Object)quarter).and("periodnumber", "=", (Object)month);
    }

    public Set<Long> getScanOrgIdSet() {
        return this.scanOrgIdSet;
    }

    public void setScanOrgIdSet(Set<Long> scanOrgIdSet) {
        this.scanOrgIdSet = scanOrgIdSet;
    }

    public String getPeriodTypeStr() {
        return this.periodTypeStr;
    }

    public void setPeriodTypeStr(String periodTypeStr) {
        this.periodTypeStr = periodTypeStr;
    }

    public Long getAnalysisPeriodId() {
        return this.analysisPeriodId;
    }

    public void setAnalysisPeriodId(Long analysisPeriodId) {
        this.analysisPeriodId = analysisPeriodId;
    }

    public Long getAccountPeriodTypeId() {
        return this.accountPeriodTypeId;
    }

    public void setAccountPeriodTypeId(Long accountPeriodTypeId) {
        this.accountPeriodTypeId = accountPeriodTypeId;
    }

    public Long getAccountPeriodId() {
        return this.accountPeriodId;
    }

    public void setAccountPeriodId(Long accountPeriodId) {
        this.accountPeriodId = accountPeriodId;
    }

    public String getScanObjectStr() {
        return this.scanObjectStr;
    }

    public void setScanObjectStr(String scanObjectStr) {
        this.scanObjectStr = scanObjectStr;
    }

    public Set<Long> getRiskIdSet() {
        return this.riskIdSet;
    }

    public void setRiskIdSet(Set<Long> riskIdSet) {
        this.riskIdSet = riskIdSet;
    }

    public Set<Long> getRiskItemIdSet() {
        return this.riskItemIdSet;
    }

    public void setRiskItemIdSet(Set<Long> riskItemIdSet) {
        this.riskItemIdSet = riskItemIdSet;
    }
}

