/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.data.rsa.helper.ScanParamHelper;
import kd.data.rsa.model.RiskScanDTO;
import kd.data.rsa.service.AutoScanService;
import kd.data.rsa.service.RiskServiceFactory;

public class RSARiskScanTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(RSARiskScanTask.class);
    private static final String PARAM_KEY = "scanparam";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info(String.format("[DATA-RSA] RSARiskOverDueTask execute success! map:%s", map));
        if (!this.validate(map)) {
            return;
        }
        Map paramMap = (Map)JSON.parseObject((String)((String)map.get(PARAM_KEY)), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        if (paramMap == null) {
            logger.error(String.format("[DATA-RSA] RSARiskOverDueTask parameter is null, requestParam:{%s}, paramKey:{%s}", map, PARAM_KEY));
            return;
        }
        Map<Object, DynamicObject> scanParamMap = ScanParamHelper.get((Long)paramMap.get("id"));
        List<RiskScanDTO> riskScanDTOList = RiskScanDTO.batchParseScanParam(scanParamMap.values());
        logger.info(String.format("[DATA-RSA] RSARiskOverDueTask execute riskScanDTOList:%s", SerializationUtils.toJsonString(riskScanDTOList)));
        AutoScanService autoScanService = RiskServiceFactory.getAutoScanService();
        autoScanService.execute(riskScanDTOList);
    }

    private boolean validate(Map<String, Object> map) {
        Map resultMap;
        if (map == null || map.isEmpty()) {
            return false;
        }
        String scanParam = (String)map.get(PARAM_KEY);
        if (StringUtils.isEmpty((CharSequence)scanParam)) {
            return false;
        }
        try {
            resultMap = (Map)JSON.parseObject((String)scanParam, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            logger.error("[DATA-RSA] RSARiskScanTask Json parse error!", (Throwable)e);
            return false;
        }
        if (resultMap == null) {
            return false;
        }
        String number = (String)resultMap.get("number");
        return !StringUtils.isEmpty((CharSequence)number) && "rsa_scanparam".equals(number);
    }
}

