/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.data.rsa.helper.RiskCheckHelper;
import kd.data.rsa.model.RiskCalculateDTO;
import kd.data.rsa.model.RiskScanDTO;
import kd.data.rsa.service.IScanService;
import kd.data.rsa.task.RSALazyCalculateTask;

public class AutoScanService
implements IScanService<RiskScanDTO> {
    private static final Log logger = LogFactory.getLog(AutoScanService.class);

    @Override
    public void execute(RiskScanDTO riskScanDTO) {
        List<RiskCalculateDTO> riskCalculateDTOS;
        Map<Long, List> riskMap = null;
        if ("1".equals(riskScanDTO.getScanObjectStr())) {
            Map riskDynMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risk", (String)"id, riskitem", (QFilter[])new QFilter[]{new QFilter("id", "in", riskScanDTO.getRiskIdSet())});
            riskMap = riskDynMap.values().stream().collect(Collectors.toMap(risk -> risk.getLong("id"), risk -> ((MulBasedataDynamicObjectCollection)risk.get("riskitem")).stream().map(item -> item.getLong("fbasedataid_id")).collect(Collectors.toList())));
        }
        if (!(riskCalculateDTOS = RiskCheckHelper.buildCalculateDTOs(riskScanDTO.getRiskItemIdSet().toArray(new Long[0]), riskScanDTO.getScanOrgIdSet().toArray(), riskScanDTO.getAccountPeriodId(), riskScanDTO.getAnalysisPeriodId(), riskMap)).isEmpty()) {
            RSALazyCalculateTask task = new RSALazyCalculateTask("autoRiskCheck" + Uuid8.generateShortUuid(), riskCalculateDTOS, 2);
            ThreadPools.executeOnce((String)"AutoScanService", (Runnable)task);
        }
    }

    @Override
    public void execute(List<RiskScanDTO> riskScanDTOList) {
        for (RiskScanDTO riskScanDTO : riskScanDTOList) {
            if (RiskCheckHelper.checkAvailableRiskItem(riskScanDTO.getScanOrgIdSet()).isEmpty() || !RiskCheckHelper.checkPeriodMatch(riskScanDTO.getScanObjectStr(), riskScanDTO.getPeriodTypeStr(), riskScanDTO.getRiskItemIdSet(), riskScanDTO.getRiskIdSet()) || !RiskCheckHelper.checkOrgFasPermission(riskScanDTO)) continue;
            this.execute(riskScanDTO);
        }
    }
}

