/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.RiskNumericalUnitEnum;
import kd.data.rsa.enums.TimeTypeEnum;
import kd.data.rsa.external.FasindexHelper;
import kd.data.rsa.helper.CodeRuleHelper;
import kd.data.rsa.helper.RiskEventHelper;
import kd.data.rsa.helper.RiskLogHelper;
import kd.data.rsa.model.DimensionValue;
import kd.data.rsa.model.RiskCalculateDTO;
import kd.data.rsa.model.RiskCheckStatisticsDTO;
import kd.data.rsa.model.RiskEventModel;
import kd.data.rsa.utils.IntervalUtil;
import kd.data.rsa.utils.UnitConversionUtil;

public class RSALazyCalculateTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(RSALazyCalculateTask.class);
    private final IAppCache cache = AppCache.get((String)"RSA");
    private final String prefix_fas = "_index_";
    private final int stepCount = 1000;
    private Map<Long, String> risklevelMap;
    private String taskKey;
    private List<RiskCalculateDTO> riskCalculateDTOS;
    private boolean isRiskCheck;
    private Map<Object, DynamicObject> riskMap;
    private Map<Long, Integer> fasIndexPrecisionMap;
    private int type;

    public RSALazyCalculateTask(String taskKey, List<RiskCalculateDTO> riskCalculateDTOS, int type) {
        this.riskCalculateDTOS = riskCalculateDTOS;
        this.type = type;
        Map riskLevels = BusinessDataServiceHelper.loadFromCache((String)"rsa_risklevel", null);
        this.risklevelMap = new HashMap<Long, String>(riskLevels.size());
        riskLevels.forEach((k, v) -> this.risklevelMap.put(v.getLong("id"), v.getString("name")));
        this.taskKey = taskKey;
        if (riskCalculateDTOS != null && !riskCalculateDTOS.isEmpty()) {
            this.fasIndexPrecisionMap = new HashMap<Long, Integer>(riskCalculateDTOS.size());
            HashSet<Long> riskIds = new HashSet<Long>(10);
            HashSet<Long> fasIds = new HashSet<Long>(10);
            for (RiskCalculateDTO dto : riskCalculateDTOS) {
                if (!riskCalculateDTOS.get(0).getRiskIdList().isEmpty()) {
                    this.isRiskCheck = true;
                    riskIds.addAll(dto.getRiskIdList());
                }
                fasIds.add(dto.getFasIndexPk());
            }
            if (!riskIds.isEmpty()) {
                this.riskMap = BusinessDataServiceHelper.loadFromCache((Object[])riskIds.toArray(), (String)"rsa_risk");
            }
            Map fasMap = BusinessDataServiceHelper.loadFromCache((Object[])fasIds.toArray(), (String)"pa_fasindex");
            for (DynamicObject fasIndex : fasMap.values()) {
                Object precision = fasIndex.get("precision");
                int scale = 0;
                if (precision == null) continue;
                scale = Integer.parseInt(String.valueOf(precision));
                scale = Math.min(scale, 10);
                this.fasIndexPrecisionMap.put(fasIndex.getLong("id"), scale);
            }
        }
    }

    private void riskCheck(List<RiskEventModel> riskEventDynList, Map<Long, DynamicObject> riskDynMap, RiskCalculateDTO riskCalculateDTO) {
        List<Long> riskIds = riskCalculateDTO.getRiskIdList();
        Map<Long, Long> riskDutyOrgMap = riskCalculateDTO.getRiskDutyOrgMap();
        for (Long riskId : riskIds) {
            Long dutyOrgId = riskDutyOrgMap.get(riskId);
            DynamicObject riskEvent = riskDynMap.get(riskId);
            DynamicObjectCollection dynamicObjectCollection = null;
            for (RiskEventModel eventModel : riskEventDynList) {
                DynamicObject dynamicObject = eventModel.toDynamicObject();
                Long orgId = dynamicObject.getLong("org_id");
                if (!orgId.equals(dutyOrgId)) continue;
                if (riskEvent == null) {
                    riskEvent = dynamicObject;
                    this.riskEventSetValue(this.riskMap.get(riskId), riskEvent, riskCalculateDTO);
                    if (riskEvent.getDynamicObjectCollection("entryentity") != null) {
                        riskEvent.getDynamicObjectCollection("entryentity").clear();
                    }
                    dynamicObjectCollection = riskEvent.getDynamicObjectCollection("entryentity");
                    riskDynMap.put(riskId, riskEvent);
                }
                if (TimeTypeEnum.BD_PERIOD.getCode().equals(eventModel.getTimeType())) {
                    riskEvent.set("accountperiod", (Object)eventModel.getPeriodId());
                } else if (TimeTypeEnum.PA_ANALYSISPERIOD.getCode().equals(eventModel.getTimeType())) {
                    riskEvent.set("analysisperiod", (Object)eventModel.getPeriodId());
                }
                if (dynamicObjectCollection == null) {
                    dynamicObjectCollection = riskEvent.getDynamicObjectCollection("entryentity");
                }
                DynamicObject entry = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
                this.entrySetValue(dynamicObject, entry, riskCalculateDTO);
                dynamicObjectCollection.add((Object)entry);
            }
        }
    }

    private DynamicObject riskEventSetValue(DynamicObject risk, DynamicObject riskEvent, RiskCalculateDTO riskCalculateDTO) {
        if (riskEvent == null || risk == null) {
            return null;
        }
        DynamicObjectCollection userCollections = riskEvent.getDynamicObjectCollection("user");
        MulBasedataDynamicObjectCollection noticeUser = (MulBasedataDynamicObjectCollection)risk.get("alternoticeuser");
        userCollections.clear();
        for (DynamicObject dyn : noticeUser) {
            DynamicObject user = new DynamicObject(userCollections.getDynamicObjectType());
            user.set("fbasedataid_id", dyn.get("fbasedataid_id"));
            userCollections.add((Object)user);
        }
        riskEvent.set("user", (Object)userCollections);
        riskEvent.set("risk", risk.get("id"));
        riskEvent.set("upper", (Object)Character.valueOf('0'));
        if (riskCalculateDTO.getTimeTypeEnum() == TimeTypeEnum.BD_PERIOD) {
            riskEvent.set("accountperiod", riskEvent.get("period_id"));
        } else {
            riskEvent.set("analysisperiod", riskEvent.get("period_id"));
        }
        riskEvent.set("riskitem", (Object)0);
        riskEvent.set("dutyuser", risk.get("dutyuser"));
        return riskEvent;
    }

    private DynamicObject entrySetValue(DynamicObject riskEvent, DynamicObject entry, RiskCalculateDTO riskCalculateDTO) {
        if (riskEvent == null || entry == null) {
            return null;
        }
        entry.set("riskriskitem", riskCalculateDTO.getRiskItem().get("id"));
        entry.set("displayfasindex", riskEvent.get("fasindex_id"));
        entry.set("displayperiod", (Object)riskCalculateDTO.getPeriodName());
        entry.set("timetypeentry", (Object)riskCalculateDTO.getTimeTypeEnum().getCode());
        entry.set("displayvalue", riskEvent.get("value"));
        entry.set("unit", riskEvent.get("numericalunit"));
        entry.set("displayrang", riskEvent.get("rang"));
        entry.set("earlywarnlevel", riskEvent.get("risklevel_id"));
        entry.set("riskinfluence", riskEvent.get("influence"));
        String otherDimensionTag = riskEvent.getString("otherdimensionvalue_tag");
        if (!StringUtils.isEmpty((String)otherDimensionTag)) {
            StringBuilder otherDimensionSb = new StringBuilder();
            ArrayList<Long> dimensionIds = new ArrayList<Long>(10);
            List otherDimensions = (List)JSON.parseObject((String)otherDimensionTag, (TypeReference)new TypeReference<List<DimensionValue>>(){}, (Feature[])new Feature[0]);
            LinkedHashMap<String, String> entryOtherDimensionMap = new LinkedHashMap<String, String>(otherDimensions.size());
            for (DimensionValue dimension : otherDimensions) {
                dimensionIds.add(dimension.getDimensionId());
            }
            Map paDimension = BusinessDataServiceHelper.loadFromCache((Object[])dimensionIds.toArray(), (String)"pa_dimension");
            for (DynamicObject value : paDimension.values()) {
                String dynName;
                DynamicObject dynObj;
                String dimensionType = value.getString("dimensiontype");
                int index = dimensionIds.indexOf(value.getLong("id"));
                if (("1".equals(dimensionType) || "4".equals(dimensionType)) && StringUtils.isNotEmpty((String)value.getString("dimensionsource.number"))) {
                    dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)value.getString("dimensionsource.number"), (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", ((DimensionValue)otherDimensions.get(index)).getValue())});
                    dynName = dynObj == null ? " " : dynObj.getString("name");
                    otherDimensionSb.append(value.getString("name")).append(":").append(dynName).append("; ");
                    entryOtherDimensionMap.put(value.getString("name"), dynName);
                    continue;
                }
                if ("2".equals(dimensionType)) {
                    dynObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_assistantdata_detail", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", ((DimensionValue)otherDimensions.get(index)).getValue())});
                    dynName = dynObj == null ? " " : dynObj.getString("name");
                    otherDimensionSb.append(value.getString("name")).append(":").append(dynName).append("; ");
                    entryOtherDimensionMap.put(value.getString("name"), dynName);
                    continue;
                }
                if ("6".equals(dimensionType)) {
                    DynamicObjectCollection enums = value.getDynamicObjectCollection("entryentityenums");
                    for (DynamicObject anEnum : enums) {
                        if (((DimensionValue)otherDimensions.get(index)).getValue() == null || !((DimensionValue)otherDimensions.get(index)).getValue().toString().equals(anEnum.get("value"))) continue;
                        otherDimensionSb.append(value.getString("name")).append(":").append(anEnum.getString("title")).append("; ");
                        entryOtherDimensionMap.put(value.getString("name"), anEnum.getString("title"));
                    }
                    continue;
                }
                otherDimensionSb.append(value.getString("name")).append(":").append(((DimensionValue)otherDimensions.get(index)).getValue()).append("; ");
                entryOtherDimensionMap.put(value.getString("name"), ((DimensionValue)otherDimensions.get(index)).getValue() == null ? " " : ((DimensionValue)otherDimensions.get(index)).getValue().toString());
            }
            entry.set("otherdimension_tag", (Object)SerializationUtils.toJsonString(entryOtherDimensionMap));
            entry.set("otherdimension", (Object)otherDimensionSb.substring(0, Math.min(otherDimensionSb.length(), 50)));
        }
        return entry;
    }

    @Override
    public void run() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String formattedDate = sdf.format(new Date());
            boolean noCodeRule = false;
            List codeRuleInfoList = CodeRuleHelper.getAllCodeRuleByEntity((String)"rsa_riskevent");
            if (codeRuleInfoList.isEmpty()) {
                noCodeRule = true;
            }
            AppCache.get((String)"RSA").remove("rsa_riskStatisticsDto_" + Calendar.getInstance().get(2));
            int countRisk = 0;
            int failCountRisk = 0;
            HashSet<Long> errorRiskId = new HashSet<Long>(10);
            HashSet<Long> riskIdSet = new HashSet<Long>(10);
            HashMap<Long, DynamicObject> riskDynMap = new HashMap<Long, DynamicObject>(64);
            HashMap<Long, Integer> riskScanCountMap = new HashMap<Long, Integer>(this.riskMap != null ? this.riskMap.size() : 10);
            logger.info("[DATA-RSA] RiskCaculateDTOs count\uff1a" + this.riskCalculateDTOS.size());
            RiskCheckStatisticsDTO statisticsDTO = new RiskCheckStatisticsDTO(this.riskCalculateDTOS.size());
            this.cache.put("prefix_rsa_riskitem_count" + this.taskKey, (Object)this.riskCalculateDTOS.size());
            for (RiskCalculateDTO risk : this.riskCalculateDTOS) {
                Map<Long, Long> riskDutyOrgMap = risk.getRiskDutyOrgMap();
                riskIdSet.addAll(risk.getRiskIdList());
                ArrayList<Object> exeCuteOrgIds = new ArrayList<Object>(Arrays.asList(risk.getOrgIds()));
                int i = 0;
                DynamicObject riskItem = risk.getRiskItem();
                String timeType = risk.getTimeTypeEnum().getCode();
                long riskItemId = riskItem.getLong("id");
                Map<String, ThreeTuple<Long, String, String>> intervalLevelMap = risk.getIntervalLevelMap();
                Map<String, Object> stringObjectMap = null;
                String valuetype = riskItem.getString("valuetype");
                HashMap<String, Object> comparison = new HashMap<String, Object>(1);
                comparison.put("comparisonType", StringUtils.isEmpty((String)valuetype) ? "00" : valuetype);
                try {
                    stringObjectMap = FasindexHelper.commitComparisonCalculate(risk.getFasIndexPk(), risk.getParams(), comparison);
                }
                catch (Exception e) {
                    statisticsDTO.addRiskItemId(risk.getOrgIds(), timeType, riskItem.getLong("id"), false);
                    statisticsDTO.addRiskId(risk.getOrgIds(), timeType, risk.getRiskIdList(), false, riskDutyOrgMap);
                    logger.error("[DATA-RSA] Execute RSALazyCalculateTask fasIndexService fail:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    statisticsDTO.addFailRiskItem();
                    if (this.isRiskCheck) {
                        for (Long riskId : risk.getRiskIdList()) {
                            RiskLogHelper.saveRiskExeLog(this.taskKey, timeType, Arrays.asList(risk.getOrgIds()), risk.getPeriodId(), riskItemId, e.getMessage() == null ? "fasIndexService Error!" : "fasIndexService Error:" + e.getMessage(), true, statisticsDTO, this.type, riskId);
                        }
                    } else {
                        RiskLogHelper.saveRiskExeLog(this.taskKey, timeType, Arrays.asList(risk.getOrgIds()), risk.getPeriodId(), riskItemId, e.getMessage() == null ? "fasIndexService Error!" : "fasIndexService Error:" + e.getMessage(), true, statisticsDTO, this.type, 0L);
                    }
                    this.cache.put("prefix_rsa_cache_fail" + this.taskKey, (Object)(++failCountRisk));
                    errorRiskId.addAll(risk.getRiskIdList());
                    continue;
                }
                Long orgIdCache = null;
                Long periodIdCache = null;
                ArrayList<RiskEventModel> riskEventDynList = new ArrayList<RiskEventModel>(10);
                if (stringObjectMap != null && !stringObjectMap.isEmpty() && "success".equals(stringObjectMap.get("code"))) {
                    statisticsDTO.addRiskItemId(risk.getOrgIds(), timeType, riskItem.getLong("id"), true);
                    statisticsDTO.addRiskId(risk.getOrgIds(), timeType, risk.getRiskIdList(), true, riskDutyOrgMap);
                    if (stringObjectMap.get("cacheId") != null && StringUtils.isNotEmpty((String)stringObjectMap.get("cacheId").toString())) {
                        Date checkDate = new Date();
                        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)stringObjectMap.get("cacheId").toString());
                        int j = 0;
                        int scanCount = 0;
                        do {
                            Iterator iterator = cacheDataSet.iterator(i, 1000);
                            i += 1000;
                            while (iterator.hasNext()) {
                                Field[] fields;
                                ++j;
                                Row next = (Row)iterator.next();
                                Long orgId = next.getLong(risk.getOrgNumber());
                                Long periodId = next.getLong(risk.getPeriodNumber());
                                Object value = StringUtils.isEmpty((String)valuetype) || "00".equals(valuetype) ? next.get("_index_" + risk.getFasNumber()) : next.get("_c" + valuetype + "_");
                                StringBuilder resultSb = new StringBuilder("[DATA-RSA] CalculateTaskResult: ");
                                for (Field field : fields = ((PersistedArrayRow)next).getRowMeta().getFields()) {
                                    if (next.get(field.toString()) == null) {
                                        resultSb.append(field).append(": ").append("null").append("; ");
                                        continue;
                                    }
                                    resultSb.append(field).append(": ").append(next.get(field.toString())).append("; ");
                                }
                                logger.info(resultSb.toString());
                                if (j == 1) {
                                    orgIdCache = orgId;
                                    periodIdCache = periodId;
                                }
                                if (orgIdCache != null && !orgIdCache.equals(orgId) || periodIdCache != null && !periodIdCache.equals(periodId)) {
                                    if (this.isRiskCheck) {
                                        this.riskCheck(riskEventDynList, riskDynMap, risk);
                                        riskEventDynList.clear();
                                    } else {
                                        RiskLogHelper.saveRiskExeLogAndEvent(this.taskKey, timeType, orgIdCache, periodIdCache, risk, statisticsDTO, riskEventDynList, scanCount, this.type, noCodeRule);
                                        orgIdCache = orgId;
                                        periodIdCache = periodId;
                                    }
                                    scanCount = 0;
                                }
                                ++scanCount;
                                if (value == null) continue;
                                BigDecimal riskEventValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
                                BigDecimal compareDecimal = riskEventValue;
                                for (Map.Entry<String, ThreeTuple<Long, String, String>> interval : intervalLevelMap.entrySet()) {
                                    String numericalunit;
                                    if (!IntervalUtil.isInTheInterval(compareDecimal.toPlainString(), interval.getKey())) continue;
                                    exeCuteOrgIds.remove(orgId);
                                    Map<String, Long> otherDimensionMap = risk.getOtherDimensionMap();
                                    ArrayList<DimensionValue> otherDimension = new ArrayList<DimensionValue>(otherDimensionMap.size());
                                    for (Map.Entry<String, Long> dim : otherDimensionMap.entrySet()) {
                                        otherDimension.add(new DimensionValue(dim.getValue().longValue(), next.get(dim.getKey())));
                                    }
                                    String riskEventName = "";
                                    if (!this.isRiskCheck) {
                                        riskEventName = RiskEventHelper.genRiskEventName(riskItem.getString("name"), this.risklevelMap.get(interval.getValue().item1), formattedDate);
                                    }
                                    ThreeTuple<Long, String, String> intervalValue = interval.getValue();
                                    Integer scale = this.fasIndexPrecisionMap.get(risk.getFasIndexPk());
                                    if (this.fasIndexPrecisionMap != null && scale != null) {
                                        riskEventValue = riskEventValue.setScale((int)scale, RoundingMode.HALF_UP);
                                    }
                                    if (StringUtils.isNotEmpty((String)(numericalunit = riskItem.getString("numericalunit"))) && !"0".equals(numericalunit)) {
                                        riskEventValue = UnitConversionUtil.conversion(riskEventValue, scale == null ? 0 : scale, RiskNumericalUnitEnum.getEnum(numericalunit));
                                    }
                                    RiskEventModel riskEvent = new RiskEventModel(null, riskEventName, orgId, periodId, checkDate, riskItemId, (Long)intervalValue.item1, (String)intervalValue.item2, risk.getFasIndexPk(), riskEventValue, (String)intervalValue.item3, otherDimension, timeType, numericalunit, 0L, risk.getPeriodName());
                                    riskEvent.setRiskItem(risk.getRiskItem());
                                    riskEventDynList.add(riskEvent);
                                }
                            }
                        } while (j != 0 && j % 1000 == 0);
                        if (orgIdCache != null && periodIdCache != null) {
                            if (this.isRiskCheck) {
                                Long riskId = risk.getRiskIdList().get(0);
                                if (riskScanCountMap.get(riskId) == null) {
                                    riskScanCountMap.put(riskId, j);
                                } else {
                                    riskScanCountMap.put(riskId, (Integer)riskScanCountMap.get(riskId) + j);
                                }
                                this.riskCheck(riskEventDynList, riskDynMap, risk);
                                riskEventDynList.clear();
                            } else {
                                RiskLogHelper.saveRiskExeLogAndEvent(this.taskKey, timeType, orgIdCache, periodIdCache, risk, statisticsDTO, riskEventDynList, scanCount, this.type, noCodeRule);
                            }
                        }
                        logger.info("[DATA-RSA] RiskItemReturn count:" + j);
                        if (this.isRiskCheck) {
                            for (Long riskId : risk.getRiskIdList()) {
                                RiskLogHelper.saveRiskExeLog(this.taskKey, timeType, exeCuteOrgIds, risk.getPeriodId(), riskItemId, " ", false, statisticsDTO, this.type, riskId);
                            }
                        } else {
                            RiskLogHelper.saveRiskExeLog(this.taskKey, timeType, exeCuteOrgIds, risk.getPeriodId(), riskItemId, " ", false, statisticsDTO, this.type, 0L);
                        }
                        this.cache.put("prefix_rsa_cache" + this.taskKey, (Object)(++countRisk));
                        continue;
                    }
                    if (this.isRiskCheck) {
                        for (Long riskId : risk.getRiskIdList()) {
                            RiskLogHelper.saveRiskExeLog(this.taskKey, timeType, exeCuteOrgIds, risk.getPeriodId(), riskItemId, " ", false, statisticsDTO, this.type, riskId);
                        }
                    } else {
                        RiskLogHelper.saveRiskExeLog(this.taskKey, timeType, exeCuteOrgIds, risk.getPeriodId(), riskItemId, " ", false, statisticsDTO, this.type, 0L);
                    }
                    this.cache.put("prefix_rsa_cache" + this.taskKey, (Object)(++countRisk));
                    continue;
                }
                statisticsDTO.addRiskId(risk.getOrgIds(), timeType, risk.getRiskIdList(), false, riskDutyOrgMap);
                statisticsDTO.addRiskItemId(risk.getOrgIds(), timeType, riskItem.getLong("id"), false);
                statisticsDTO.addFailRiskItem();
                if (this.isRiskCheck) {
                    for (Long riskId : risk.getRiskIdList()) {
                        RiskLogHelper.saveRiskExeLog(this.taskKey, timeType, Arrays.asList(risk.getOrgIds()), risk.getPeriodId(), riskItemId, "CalculateResult isEmpty", true, statisticsDTO, this.type, riskId);
                    }
                } else {
                    RiskLogHelper.saveRiskExeLog(this.taskKey, timeType, Arrays.asList(risk.getOrgIds()), risk.getPeriodId(), riskItemId, "CalculateResult isEmpty", true, statisticsDTO, this.type, 0L);
                }
                this.cache.put("prefix_rsa_cache_fail" + this.taskKey, (Object)(++failCountRisk));
                errorRiskId.addAll(risk.getRiskIdList());
            }
            for (Long errRiskId : errorRiskId) {
                riskDynMap.remove(errRiskId);
            }
            if (!riskDynMap.isEmpty()) {
                RiskLogHelper.saveRiskExeLogAndEvent(this.taskKey, riskDynMap, statisticsDTO, riskScanCountMap, this.type, noCodeRule, this.riskMap, this.risklevelMap, formattedDate);
            }
            statisticsDTO.setErrorRiskCount(errorRiskId.size());
            statisticsDTO.setRiskCount(riskIdSet.size());
            statisticsDTO.removeErrorRisk(errorRiskId);
            this.cache.put("prefix_rsa_statistics_cache" + this.taskKey, (Object)JSONUtils.toString((Object)statisticsDTO));
        }
        catch (Exception e) {
            logger.error("[DATA-RSA] Execute RSALazyCalculateTask fail:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            this.cache.put("prefix_rsa_cache_error" + this.taskKey, (Object)(e.getMessage() == null ? "CalculateTask Error!" : e.getMessage()));
        }
    }
}

