/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    private static final int[] QUARTER = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    private static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();

    private DateUtil() {
    }

    public static Date getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getLastMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) - i);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + i);
        return cal.getTime();
    }

    public static Date getLastQuarter(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) - i * 3);
        return cal.getTime();
    }

    public static Date getNextQuarter(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + i * 3);
        return cal.getTime();
    }

    public static Date getLastYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(1, cal.get(1) - i);
        return cal.getTime();
    }

    public static Date getNextYear(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(1, cal.get(1) + i);
        return cal.getTime();
    }

    public static int getDay(Date date) {
        return DateUtil.date2LocalDate(date).getDayOfMonth();
    }

    public static int getMonth(Date date) {
        return DateUtil.date2LocalDate(date).getMonthValue();
    }

    public static int getQuarter(Date date) {
        return QUARTER[DateUtil.getMonth(date) - 1];
    }

    public static int getYear(Date date) {
        return DateUtil.date2LocalDate(date).getYear();
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return 0;
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        return (int)diff + 1;
    }

    public static LocalDate date2LocalDate(Date date) {
        return DateUtil.date2LocalDateTime(date).toLocalDate();
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), DEFAULT_ZONE);
    }
}

