/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.utils;

import java.util.HashMap;
import kd.data.rsa.engine.ScriptEngine;

public class IntervalUtil {
    public static boolean isInTheInterval(String data_value, String interval) {
        String formula = IntervalUtil.getFormulaByAllInterval(data_value, interval, "||");
        HashMap ctx = new HashMap(1);
        try {
            Object result = ScriptEngine.getEngine().runScript(formula, ctx);
            return (Boolean)result;
        }
        catch (Exception t) {
            return false;
        }
    }

    private static String getFormulaByAllInterval(String date_value, String interval, String connector) {
        StringBuilder sb = new StringBuilder();
        for (String limit : interval.split("U")) {
            sb.append("(").append(IntervalUtil.getFormulaByInterval(date_value, limit, " && ")).append(")").append(connector);
        }
        String allLimitInvel = sb.toString();
        int index = allLimitInvel.lastIndexOf(connector);
        allLimitInvel = allLimitInvel.substring(0, index);
        return allLimitInvel;
    }

    private static String getFormulaByInterval(String date_value, String interval, String connector) {
        StringBuilder sb = new StringBuilder();
        for (String halfInterval : interval.split(",")) {
            sb.append(IntervalUtil.getFormulaByHalfInterval(halfInterval, date_value)).append(connector);
        }
        String limitInvel = sb.toString();
        int index = limitInvel.lastIndexOf(connector);
        limitInvel = limitInvel.substring(0, index);
        return limitInvel;
    }

    private static String getFormulaByHalfInterval(String halfInterval, String date_value) {
        if ((halfInterval = halfInterval.trim()).contains("\u221e")) {
            return "1 == 1";
        }
        StringBuilder formula = new StringBuilder();
        String data = "";
        String opera = "";
        if (halfInterval.matches("^([<>\u2264\u2265\\[\\(]{1}(-?\\d+.?\\d*\\%?))$")) {
            opera = halfInterval.substring(0, 1);
            data = halfInterval.substring(1);
        } else {
            opera = halfInterval.substring(halfInterval.length() - 1);
            data = halfInterval.substring(0, halfInterval.length() - 1);
        }
        double value = IntervalUtil.dealPercent(data);
        formula.append(date_value).append(" ").append(opera).append(" ").append(value);
        String a = formula.toString();
        return a.replace("[", ">=").replace("(", ">").replace("]", "<=").replace(")", "<").replace("\u2264", "<=").replace("\u2265", ">=");
    }

    private static double dealPercent(String str) {
        double d = 0.0;
        if (str.contains("%")) {
            str = str.substring(0, str.length() - 1);
            d = Double.parseDouble(str) / 100.0;
        } else {
            d = Double.parseDouble(str);
        }
        return d;
    }
}

