/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.data.rsa.enums.RiskNumericalUnitEnum;

public class UnitConversionUtil {
    public static BigDecimal conversion(BigDecimal value, int scale, RiskNumericalUnitEnum needUnit) {
        BigDecimal result = null;
        switch (needUnit) {
            case NULL: {
                result = value;
                break;
            }
            case THOUSAND: {
                result = value.divide(new BigDecimal("1000"), Math.min(scale + 3, 10), RoundingMode.HALF_UP);
                break;
            }
            case TENTHOUSAND: {
                result = value.divide(new BigDecimal("10000"), Math.min(scale + 4, 10), RoundingMode.HALF_UP);
                break;
            }
            case HUNDREDMILLION: {
                result = value.divide(new BigDecimal("100000000"), Math.min(scale + 8, 10), RoundingMode.HALF_UP);
                break;
            }
            case PERCENTAGE: {
                result = value.multiply(new BigDecimal("100")).setScale(Math.max(scale - 2, 0), RoundingMode.HALF_UP);
                break;
            }
            case PERMILLAGE: {
                result = value.multiply(new BigDecimal("1000")).setScale(Math.max(scale - 3, 0), RoundingMode.HALF_UP);
                break;
            }
        }
        return result;
    }

    public static String originalConversion(BigDecimal value, RiskNumericalUnitEnum originalUnit) {
        if (value == null) {
            return null;
        }
        BigDecimal result = null;
        switch (originalUnit) {
            case NULL: {
                result = value;
                break;
            }
            case THOUSAND: {
                result = value.multiply(new BigDecimal("1000"));
                break;
            }
            case TENTHOUSAND: {
                result = value.multiply(new BigDecimal("10000"));
                break;
            }
            case HUNDREDMILLION: {
                result = value.multiply(new BigDecimal("100000000"));
                break;
            }
            case PERCENTAGE: {
                result = value.divide(new BigDecimal("100"));
                break;
            }
            case PERMILLAGE: {
                result = value.divide(new BigDecimal("1000"));
                break;
            }
        }
        if (result == null) {
            return value.toPlainString();
        }
        return result.toPlainString();
    }
}

