/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.rsa.helper.RiskLevelEvalCriteriaHelper;
import kd.data.rsa.validate.EvalWithConfirmValidator;

public class EvalWithConfirmOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("confirm".equals(operationKey)) {
            DynamicObject[] riskLoad;
            Date date = new Date();
            long currUserId = RequestContext.get().getCurrUserId();
            DynamicObject[] dataEntities = e.getDataEntities();
            Object[] ids = Arrays.stream(dataEntities).map(v -> v.get("id")).toArray();
            Map rsaEvalwithMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"rsa_evalwith");
            if (rsaEvalwithMap == null || rsaEvalwithMap.isEmpty()) {
                return;
            }
            HashSet riskIds = new HashSet(rsaEvalwithMap.size());
            HashMap<Long, Long> riskEvalMap = new HashMap<Long, Long>(rsaEvalwithMap.size());
            ArrayList<DynamicObject> updateEvalList = new ArrayList<DynamicObject>(rsaEvalwithMap.size());
            ArrayList<DynamicObject> addRiskAnalysisLogs = new ArrayList<DynamicObject>(rsaEvalwithMap.size() * 3);
            for (DynamicObject rsaEval : rsaEvalwithMap.values()) {
                DynamicObjectCollection entryEntity = rsaEval.getDynamicObjectCollection("entryentity");
                Set riskSet = entryEntity.stream().map(v -> v.getLong("e_risk.id")).collect(Collectors.toSet());
                for (Long riskId : riskSet) {
                    riskEvalMap.put(riskId, rsaEval.getLong("id"));
                }
                riskIds.addAll(riskSet);
                rsaEval.set("billstatus", (Object)"C");
                rsaEval.set("processdate", (Object)date);
                rsaEval.set("modifier", (Object)currUserId);
                rsaEval.set("modifytime", (Object)date);
                rsaEval.set("ackuser", (Object)currUserId);
                updateEvalList.add(rsaEval);
            }
            for (DynamicObject riskDyn : riskLoad = BusinessDataServiceHelper.load((Object[])riskIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rsa_risk"))) {
                String aName;
                DynamicObjectCollection anaEntryEntity = riskDyn.getDynamicObjectCollection("anaentryentity");
                DynamicObject wbDyn = null;
                if ("C".equals(riskDyn.getString("billstatus"))) {
                    for (DynamicObject entry : anaEntryEntity) {
                        aName = entry.getString("a_name");
                        if (!"1".equals(aName)) continue;
                        wbDyn = entry;
                    }
                    if (wbDyn == null) {
                        wbDyn = new DynamicObject(anaEntryEntity.getDynamicObjectType());
                        wbDyn.set("a_name", (Object)"1");
                        wbDyn.set("seq", (Object)"2");
                        anaEntryEntity.add((Object)wbDyn);
                    }
                } else if ("A".equals(riskDyn.getString("billstatus"))) {
                    for (DynamicObject entry : anaEntryEntity) {
                        aName = entry.getString("a_name");
                        if (!"0".equals(aName)) continue;
                        wbDyn = entry;
                    }
                    if (wbDyn == null) {
                        wbDyn = new DynamicObject(anaEntryEntity.getDynamicObjectType());
                        wbDyn.set("a_name", (Object)"0");
                        wbDyn.set("seq", (Object)"1");
                        anaEntryEntity.add((Object)wbDyn);
                    }
                }
                if (wbDyn == null) continue;
                Long riskId = riskDyn.getLong("id");
                String billStatus = riskDyn.getString("billstatus");
                Long evalId = (Long)riskEvalMap.get(riskId);
                DynamicObject evalWithDyn = (DynamicObject)rsaEvalwithMap.get(evalId);
                DynamicObjectCollection entryEntity = evalWithDyn.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryEntity) {
                    if (!riskId.equals(entry.getLong("e_risk.id"))) continue;
                    wbDyn.set("a_occscore", entry.get("e_occscore"));
                    wbDyn.set("a_occdesc", entry.get("e_occdesc"));
                    wbDyn.set("a_resultscore", entry.get("e_resultscore"));
                    wbDyn.set("a_resultdesc", entry.get("e_resultdesc"));
                    DynamicObject riskLevel = entry.getDynamicObject("e_level");
                    if (riskLevel == null) {
                        DynamicObject levelEvacriteria = RiskLevelEvalCriteriaHelper.getSingle((BigDecimal)entry.getBigDecimal("e_occscore"), (BigDecimal)entry.getBigDecimal("e_resultscore"));
                        DynamicObject dynamicObject = riskLevel = levelEvacriteria == null ? null : levelEvacriteria.getDynamicObject("risklevelid");
                    }
                    if (riskLevel == null) continue;
                    entry.set("e_level", (Object)riskLevel);
                    wbDyn.set("a_level", (Object)riskLevel);
                    riskDyn.set("riskscore", entry.get("e_score"));
                    riskDyn.set("risklevel", (Object)riskLevel);
                    riskDyn.set("isresidue", (Object)"1");
                    wbDyn.set("a_score", entry.get("e_score"));
                    wbDyn.set("a_evalbillno", evalWithDyn.get("evalno"));
                    if (!StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) continue;
                    BigDecimal occScore = entry.getBigDecimal("e_occscore");
                    BigDecimal resultScore = entry.getBigDecimal("e_resultscore");
                    if (occScore == null || resultScore == null || occScore.compareTo(BigDecimal.ZERO) == 0 || resultScore.compareTo(BigDecimal.ZERO) == 0) continue;
                    addRiskAnalysisLogs.add(this.createRiskAnalysisLog(evalWithDyn, entry, date, currUserId));
                }
            }
            SaveServiceHelper.save((DynamicObject[])riskLoad);
            SaveServiceHelper.update((DynamicObject[])updateEvalList.toArray(new DynamicObject[0]));
            if (!addRiskAnalysisLogs.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])addRiskAnalysisLogs.toArray(new DynamicObject[0]));
            }
        }
    }

    private DynamicObject createRiskAnalysisLog(DynamicObject evalWithDyn, DynamicObject entry, Date date, long currUserId) {
        DynamicObject riskAnalysisLog = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rsa_riskanalysislog"));
        riskAnalysisLog.set("name", (Object)"1");
        riskAnalysisLog.set("evalno", evalWithDyn.get("evalno"));
        riskAnalysisLog.set("occscore", entry.get("e_occscore"));
        riskAnalysisLog.set("occdesc", entry.get("e_occdesc"));
        riskAnalysisLog.set("resultscore", entry.get("e_resultscore"));
        riskAnalysisLog.set("resultdesc", entry.get("e_resultdesc"));
        riskAnalysisLog.set("level", entry.get("e_level"));
        riskAnalysisLog.set("leveldesc", entry.get("e_level.name"));
        riskAnalysisLog.set("score", entry.get("e_score"));
        riskAnalysisLog.set("createtime", (Object)date);
        riskAnalysisLog.set("creator", (Object)currUserId);
        riskAnalysisLog.set("risk", entry.get("e_risk"));
        return riskAnalysisLog;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EvalWithConfirmValidator());
    }
}

