/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.opplugin;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OccurPossibilitySaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OccurPossibilitySaveOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] updateDys;
        BasedataEntityType mainEntityType;
        BaseDataCheckRefrence baseDataCheckRefrence;
        Map refMap;
        Iterator iterator;
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length > 1) {
            logger.error("[DATA-RSA] OccurPossibilitySaveOp dataEntities is empty");
            return;
        }
        DynamicObject dataDy = dataEntities[0];
        DynamicObjectCollection dyCol = dataDy.getDynamicObjectCollection("entryentity");
        Set<Object> idSet = dyCol.stream().filter(dy -> dy.getLong("e_id") != 0L).map(dy -> dy.getLong("e_id")).collect(Collectors.toSet());
        QFilter notIdFilter = new QFilter("id", "not in", idSet);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_occurpossibility", (QFilter[])new QFilter[]{notIdFilter, statusFilter, enableFilter});
        logger.info("[DATA-RSA] OccurPossibilitySaveOp query success");
        Set pkIdSet = resultMap.keySet();
        if (!pkIdSet.isEmpty() && (iterator = (refMap = (baseDataCheckRefrence = new BaseDataCheckRefrence()).checkRef(mainEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"rsa_occurpossibility"), pkIdSet.toArray(new Object[0]))).values().iterator()).hasNext()) {
            BaseDataCheckRefrenceResult refResult = (BaseDataCheckRefrenceResult)iterator.next();
            BaseDataRefenceKey baseDataRefenceKey = refResult.getRefenceKey();
            Object basePKValue = baseDataRefenceKey.getBasePKValue();
            String refEntityKey = baseDataRefenceKey.getRefEntityKey();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)refEntityKey);
            String displayName = dataEntityType.getDisplayName().getLocaleValue();
            logger.error(String.format("[DATA-RSA] OccurPossibilitySaveOp dataEntities is ref! result:%s", SerializationUtils.toJsonString((Object)refResult)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e3b\u952e%1$s\u5df2\u88ab%2$s\uff08%3$s\uff09\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", (String)"OccurPossibilitySaveOp_1", (String)"data-rsa-opplugin", (Object[])new Object[0]), basePKValue, refEntityKey, displayName));
        }
        logger.info("[DATA-RSA] OccurPossibilitySaveOp check success");
        QFilter delIdFilter = new QFilter("id", "in", pkIdSet);
        DeleteServiceHelper.delete((String)"rsa_occurpossibility", (QFilter[])new QFilter[]{delIdFilter});
        logger.info("[DATA-RSA] OccurPossibilitySaveOp delete success");
        List insertList = dyCol.stream().filter(dy -> dy.getLong("e_id") == 0L).collect(Collectors.toList());
        DynamicObject[] insertDys = new DynamicObject[insertList.size()];
        for (int i = 0; i < insertList.size(); ++i) {
            DynamicObject dy2 = (DynamicObject)insertList.get(i);
            DynamicObject insertDy = BusinessDataServiceHelper.newDynamicObject((String)"rsa_occurpossibility");
            insertDy.set("number", dy2.get("e_number"));
            insertDy.set("name", dy2.get("e_name"));
            insertDy.set("scorefrom", dy2.get("e_scorefrom"));
            insertDy.set("scoreto", dy2.get("e_scoreto"));
            insertDy.set("status", (Object)"C");
            insertDy.set("enable", (Object)"1");
            insertDy.set("createtime", (Object)new Date());
            insertDys[i] = insertDy;
        }
        SaveServiceHelper.save((DynamicObject[])insertDys);
        logger.info("[DATA-RSA] OccurPossibilitySaveOp insert success");
        Map<Long, DynamicObject> updateMap = dyCol.stream().filter(dy -> dy.getLong("e_id") != 0L).collect(Collectors.toMap(dy -> dy.getLong("e_id"), dy -> dy));
        for (DynamicObject updateDy : updateDys = BusinessDataServiceHelper.load((Object[])idSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rsa_occurpossibility"))) {
            DynamicObject dy3 = updateMap.get(updateDy.getLong("id"));
            updateDy.set("number", dy3.get("e_number"));
            updateDy.set("name", dy3.get("e_name"));
            updateDy.set("scorefrom", dy3.get("e_scorefrom"));
            updateDy.set("scoreto", dy3.get("e_scoreto"));
            updateDy.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])updateDys);
        logger.info("[DATA-RSA] OccurPossibilitySaveOp update success");
    }
}

