/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.opplugin;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.rsa.enums.RiskEventStatusEnum;

public class RiskWorkDeleteOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Object> riskWorkIds = new ArrayList<Object>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            riskWorkIds.add(dataEntity.get("id"));
        }
        Map riskWorkMap = BusinessDataServiceHelper.loadFromCache((Object[])riskWorkIds.toArray(), (String)"rsa_riskwork");
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(riskWorkMap.size());
        for (DynamicObject riskWork : riskWorkMap.values()) {
            Object riskEventId = riskWork.get("riskeventid.id");
            if (riskEventId == null) continue;
            DynamicObject riskEvent = BusinessDataServiceHelper.loadSingle((Object)riskEventId, (String)"rsa_riskevent");
            DynamicObjectCollection collection = riskEvent.getDynamicObjectCollection("remarkentryentity");
            DynamicObject deleteEntry = null;
            for (DynamicObject entry : collection) {
                if (!RiskEventStatusEnum.CLOSE.getCode().equals(entry.getString("remarkstatus")) || entry.get("processremark") == null || !entry.getString("processremark").contains(riskWork.getString("billno"))) continue;
                deleteEntry = entry;
            }
            if (deleteEntry == null) continue;
            collection.remove(deleteEntry);
            updateList.add(riskEvent);
        }
        if (!updateList.isEmpty()) {
            try {
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
    }
}

