/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.opplugin;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.RiskEventStatusEnum;
import kd.data.rsa.validate.RiskWorkSaveValidator;

public class RiskWorkSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RiskWorkSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities != null) {
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
                if ("C".equals(dataEntity.getString("billstatus")) || "D".equals(dataEntity.getString("billstatus"))) {
                    boolean changeStatus = true;
                    if (entryentity.isEmpty()) {
                        changeStatus = false;
                    } else {
                        for (DynamicObject entry : entryentity) {
                            if (entry.get("plan") != null && entry.getInt("plan") == 100) continue;
                            changeStatus = false;
                        }
                    }
                    if (changeStatus) {
                        dataEntity.set("billstatus", (Object)"D");
                    } else {
                        dataEntity.set("billstatus", (Object)"C");
                    }
                }
                if (dataEntity.getDynamicObject("riskid") != null) {
                    dataEntity.set("risknumber", (Object)dataEntity.getDynamicObject("riskid").getString("billno"));
                }
                if (dataEntity.getDynamicObject("riskeventid") == null) continue;
                dataEntity.set("riskeventnumber", (Object)dataEntity.getDynamicObject("riskeventid").getString("billno"));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject dataEntity;
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length == 1 && StringUtils.isNotEmpty((String)(dataEntity = dataEntities[0]).getString("riskeventid"))) {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getLong("riskeventid.id"), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"rsa_riskevent"));
            DynamicObjectCollection remarkEntryEntity = dyn.getDynamicObjectCollection("remarkentryentity");
            for (DynamicObject remark : remarkEntryEntity) {
                if (!RiskEventStatusEnum.CLOSE.getCode().equals(remark.getString("remarkstatus")) || remark.get("processremark") == null || !remark.getString("processremark").contains(dataEntity.getString("billno"))) continue;
                return;
            }
            DynamicObject entry = new DynamicObject(remarkEntryEntity.getDynamicObjectType());
            entry.set("remarkstatus", (Object)RiskEventStatusEnum.CLOSE.getCode());
            entry.set("processremark", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u98ce\u9669\u4e8b\u4ef6\uff1a%s", (String)"RiskWorkSaveOp_0", (String)"data-rsa-opplugin", (Object[])new Object[0]), dataEntity.get("billno")));
            entry.set("remarkdate", (Object)new Date());
            entry.set("remarkuser", (Object)RequestContext.get().getCurrUserId());
            remarkEntryEntity.add((Object)entry);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        }
    }
}

