/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.opplugin;

import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.rsa.helper.EvalWithHelper;

public class SubmitEvalResultOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SubmitEvalResultOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dys;
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            logger.error("[DATA-RSA] SubmitEvalResultOp dataEntities is empty");
            return;
        }
        Object[] pkIds = new Object[dataEntities.length];
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject dataEntity = dataEntities[i];
            pkIds[i] = dataEntity.getPkValue();
        }
        Date date = new Date();
        long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject dy2 : dys = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"rsa_evalwith"))) {
            dy2.set("billstatus", (Object)"C");
            dy2.set("processdate", (Object)date);
            dy2.set("operator", (Object)userId);
            dy2.set("modifytime", (Object)date);
            dy2.set("modifier", (Object)userId);
        }
        SaveServiceHelper.save((DynamicObject[])dys);
        logger.info("[DATA-RSA] SubmitEvalResultOp save success");
        Set evalNoSet = Stream.of(dys).map(dy -> dy.getString("evalno")).collect(Collectors.toSet());
        for (String evalNo : evalNoSet) {
            EvalWithHelper.judgeCreateEvalAck((String)evalNo);
        }
        logger.info("[DATA-RSA] SubmitEvalResultOp judgeCreateEvalAck success");
    }
}

