/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.validate;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;

public class RiskItemSaveValidator
extends AbstractValidator {
    public void validate() {
        String errorMessage = ResManager.loadKDString((String)"\u98ce\u9669\u89e6\u53d1\u6761\u4ef6\u7684\u503c\u8303\u56f4\u5b58\u5728\u4ea4\u53c9\uff0c\u8bf7\u4fee\u6539\uff1a\u7b2c%1$d\u884c\u548c\u7b2c%2$d\u884c", (String)"RiskItemSaveValidator_0", (String)"data-rsa-opplugin", (Object[])new Object[0]);
        String errorRangMessage = ResManager.loadKDString((String)"\u7b2c%d\u884c\uff0c\u6307\u6807\u8d77\u59cb\u503c\u5927\u4e8e\u7b49\u4e8e\u7ec8\u6b62\u503c\uff0c\u8bf7\u4fee\u6539", (String)"RiskItemSaveValidator_1", (String)"data-rsa-opplugin", (Object[])new Object[0]);
        String startErrorMessage = ResManager.loadKDString((String)"\u7b2c%d\u884c\uff0c\u6307\u6807\u8d77\u59cb\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc74\u4f4d\u5c0f\u6570\u7684\u6570\u5b57\u6216-\u221e", (String)"RiskItemSaveValidator_2", (String)"data-rsa-opplugin", (Object[])new Object[0]);
        String endErrorMessage = ResManager.loadKDString((String)"\u7b2c%d\u884c\uff0c\u6307\u6807\u7ec8\u6b62\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc74\u4f4d\u5c0f\u6570\u7684\u6570\u5b57\u6216+\u221e", (String)"RiskItemSaveValidator_3", (String)"data-rsa-opplugin", (Object[])new Object[0]);
        String defaultDimensionError = ResManager.loadKDString((String)"\u9ed8\u8ba4\u7edf\u8ba1\u7ef4\u5ea6\u7f3a\u5c11\u7ec4\u7ec7\u6216\u671f\u95f4\u7684\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6307\u6807", (String)"RiskItemSaveValidator_4", (String)"data-rsa-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObjectCollection defaultDimension = (DynamicObjectCollection)data.getValue("defaultdimension");
            if (defaultDimension != null && defaultDimension.size() != 2) {
                this.addErrorMessage(data, defaultDimensionError);
            }
            DynamicObjectCollection entryCols = (DynamicObjectCollection)data.getValue("entryentity");
            int nextIndex = 0;
            int size = entryCols.size();
            for (DynamicObject entry : entryCols) {
                ++nextIndex;
                String startValue = entry.getString("start");
                String endValue = entry.getString("end");
                if (!this.startValidate(startValue)) {
                    String errorStr = String.format(startErrorMessage, nextIndex);
                    this.addErrorMessage(data, errorStr);
                    continue;
                }
                if (!this.endValidate(endValue)) {
                    String errorStr = String.format(endErrorMessage, nextIndex);
                    this.addErrorMessage(data, errorStr);
                    continue;
                }
                boolean errorRange = this.isErrorRange(entry);
                if (errorRange) {
                    String errorStr = String.format(errorRangMessage, nextIndex);
                    this.addErrorMessage(data, errorStr);
                    continue;
                }
                if (nextIndex >= size) continue;
                for (int start = nextIndex; start < size; ++start) {
                    boolean cross;
                    boolean targetErrorRange;
                    DynamicObject compareEntry = (DynamicObject)entryCols.get(start);
                    String targetStartValue = compareEntry.getString("start");
                    String targetEndValue = compareEntry.getString("end");
                    if (!this.startValidate(targetStartValue) || !this.endValidate(targetEndValue) || (targetErrorRange = this.isErrorRange(compareEntry)) || !(cross = this.isCross(entry, compareEntry))) continue;
                    String errStr = String.format(errorMessage, nextIndex, start + 1);
                    this.addErrorMessage(data, errStr);
                }
            }
        }
    }

    private boolean startValidate(String start) {
        if (StringUtils.isEmpty((String)start)) {
            return false;
        }
        Pattern p = Pattern.compile("(-\u221e)|(-{0,1}\\d{1,})|(-{0,1}\\d{1,}\\.\\d{1,4})");
        Matcher matcher = p.matcher(start);
        return matcher.matches();
    }

    private boolean endValidate(String end) {
        if (StringUtils.isEmpty((String)end)) {
            return false;
        }
        Pattern p = Pattern.compile("(\\+\u221e)|(-{0,1}\\d{1,})|(-{0,1}\\d{1,}\\.\\d{1,4})");
        Matcher matcher = p.matcher(end);
        return matcher.matches();
    }

    private boolean isErrorRange(DynamicObject entry) {
        String startValue = entry.getString("start");
        String endValue = entry.getString("end");
        BigDecimal start = this.isNegativeInfinity(startValue) ? null : new BigDecimal(startValue);
        BigDecimal end = this.isPositiveInfinity(endValue) ? null : new BigDecimal(endValue);
        return start != null && end != null && start.compareTo(end) >= 0;
    }

    private boolean isNegativeInfinity(String startValue) {
        return "-\u221e".equals(startValue);
    }

    private boolean isPositiveInfinity(String endValue) {
        return "+\u221e".equals(endValue);
    }

    private boolean isCross(DynamicObject entry, DynamicObject nextEntry) {
        boolean large;
        boolean less;
        String currentStartValue = entry.getString("start");
        BigDecimal currentStart = this.isNegativeInfinity(currentStartValue) ? new BigDecimal(Long.MIN_VALUE) : new BigDecimal(currentStartValue);
        String currentEndValue = entry.getString("end");
        BigDecimal currentEnd = this.isPositiveInfinity(currentEndValue) ? new BigDecimal(Long.MAX_VALUE) : new BigDecimal(currentEndValue);
        String nextStartValue = nextEntry.getString("start");
        BigDecimal nextStart = this.isNegativeInfinity(nextStartValue) ? new BigDecimal(Long.MIN_VALUE) : new BigDecimal(nextStartValue);
        String nextEndValue = nextEntry.getString("end");
        BigDecimal nextEnd = this.isPositiveInfinity(nextEndValue) ? new BigDecimal(Long.MAX_VALUE) : new BigDecimal(nextEndValue);
        try {
            less = !(currentStart != null && currentStart.compareTo(currentEnd) >= 0 || currentEnd.compareTo(nextStart) > 0 || nextEnd != null && nextStart.compareTo(nextEnd) >= 0);
        }
        catch (Throwable e) {
            less = false;
        }
        try {
            large = !(nextStart != null && nextStart.compareTo(nextEnd) >= 0 || nextEnd.compareTo(currentStart) > 0 || currentEnd != null && currentStart.compareTo(currentEnd) >= 0);
        }
        catch (Throwable e) {
            large = false;
        }
        return !less && !large;
    }
}

