/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class RiskLevelEvaCriteriaSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        if (dataEntities == null || dataEntities.length > 1) {
            return;
        }
        ArrayList duplicateIndex = new ArrayList(10);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entryEntity = (DynamicObjectCollection)dataEntity.getValue("entryentity");
            LinkedHashMap<String, List> occurpossibilityMap = new LinkedHashMap<String, List>(entryEntity.size());
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dyn = (DynamicObject)entryEntity.get(i);
                long occurPossibilityId = dyn.getLong("occurpossibility.id");
                long resultEffectId = dyn.getLong("resulteffect.id");
                String key = String.valueOf(occurPossibilityId) + resultEffectId;
                if (occurpossibilityMap.get(key) != null) {
                    ((List)occurpossibilityMap.get(key)).add(String.valueOf(i + 1));
                    continue;
                }
                int finalI = i;
                occurpossibilityMap.computeIfAbsent(key, k -> new ArrayList<String>(Collections.singletonList(String.valueOf(finalI + 1))));
            }
            for (List value : occurpossibilityMap.values()) {
                if (value.size() <= 1) continue;
                duplicateIndex.addAll(value);
            }
            if (duplicateIndex.size() == 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u53d1\u751f\u53ef\u80fd\u6027\u6807\u51c6+\u540e\u679c\u5f71\u54cd\u7a0b\u5ea6\u6807\u51c6\u7684\u7ec4\u5408\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u4fdd\u5b58\u3002", (String)"RiskLevelEvaCriteriaSaveValidator_1", (String)"data-rsa-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", duplicateIndex)));
        }
    }
}

