/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.validate;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RiskSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(RiskSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity data : dataEntities = this.getDataEntities()) {
            DynamicObject dataEntity = data.getDataEntity();
            DynamicObjectCollection anaEntryEntity = dataEntity.getDynamicObjectCollection("anaentryentity");
            DynamicObject residueEntryDy = null;
            for (DynamicObject entryDy : anaEntryEntity) {
                String name = entryDy.getString("a_name");
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)name)) continue;
                residueEntryDy = entryDy;
            }
            if (residueEntryDy == null) break;
            BigDecimal resultScore = residueEntryDy.getBigDecimal("a_resultscore");
            BigDecimal occScore = residueEntryDy.getBigDecimal("a_occscore");
            boolean isResidue = dataEntity.getBoolean("isresidue");
            if (!isResidue && resultScore.compareTo(BigDecimal.ZERO) == 0 && occScore.compareTo(BigDecimal.ZERO) == 0) break;
            if (resultScore.compareTo(BigDecimal.ZERO) == 0 || occScore.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5b8c\u6574\u7684\u98ce\u9669\u8bc4\u4f30\u7ed3\u679c\u3002", (String)"RiskSaveValidator_0", (String)"data-rsa-opplugin", (Object[])new Object[0]));
                break;
            }
            DynamicObject riskLevelDy = residueEntryDy.getDynamicObject("a_level");
            if (riskLevelDy != null) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8f93\u5165\u7684\u98ce\u9669\u8bc4\u4f30\u7ed3\u679c\u5339\u914d\u4e0d\u5230\u98ce\u9669\u7b49\u7ea7\uff0c\u8bf7\u8c03\u6574\u98ce\u9669\u7b49\u7ea7\u8bc4\u4f30\u6807\u51c6\u3002", (String)"RiskSaveValidator_1", (String)"data-rsa-opplugin", (Object[])new Object[0]));
        }
    }
}

