/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.validate;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.RiskEventStatusEnum;

public class RiskWorkSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(RiskWorkSaveValidator.class);

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject dataEntity = data.getDataEntity();
            if (dataEntity.getDynamicObject("riskeventid") == null) continue;
            long riskEventId = dataEntity.getLong("riskeventid.id");
            try (DLock dLock = DLock.create((String)("macc/rsa/" + riskEventId));){
                if (dLock.tryLock(1000L)) {
                    try {
                        long riskWorkId = dataEntity.getLong("id");
                        DynamicObject riskWork = BusinessDataServiceHelper.loadSingleFromCache((Object)riskWorkId, (String)"rsa_riskwork");
                        DynamicObject riskEvent = BusinessDataServiceHelper.loadSingleFromCache((String)"rsa_riskevent", (String)"riskwork, status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)riskEventId)});
                        if (riskWork != null || !StringUtils.isNotEmpty((String)riskEvent.getString("riskwork")) && !RiskEventStatusEnum.CLOSE.getCode().equals(riskEvent.getString("status"))) continue;
                        logger.info("[DATA-RSA] Exist BOTP create riskWork \uff1a " + riskEvent.getString("riskwork"));
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u4e8b\u4ef6\u5173\u8054\u7684\u98ce\u9669\u9884\u8b66\u5355\u7684\u72b6\u6001\u5df2\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u65e0\u6cd5\u4fdd\u5b58\u65b0\u7684\u98ce\u9669\u4e8b\u4ef6\u3002", (String)"RiskWorkSaveValidator_0", (String)"data-rsa-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("[DATA-RSA] Validate RiskWorkSaveError" + e.getMessage());
                        throw new KDBizException(e.getMessage());
                    }
                    finally {
                        dLock.unlock();
                    }
                }
                logger.info("[DATA-RSA] Get riskEvent dLock error " + riskEventId);
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u4e8b\u4ef6\u5173\u8054\u7684\u98ce\u9669\u9884\u8b66\u5355\u7684\u72b6\u6001\u5df2\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u65e0\u6cd5\u4fdd\u5b58\u65b0\u7684\u98ce\u9669\u4e8b\u4ef6\u3002", (String)"RiskWorkSaveValidator_0", (String)"data-rsa-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

