/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.validate.base;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class RangeIsContinuousValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length > 1) {
            return;
        }
        ExtendedDataEntity dataEntity = dataEntities[0];
        DynamicObjectCollection entryDyCol = (DynamicObjectCollection)dataEntity.getValue("entryentity");
        List dyList = entryDyCol.stream().filter(dy -> dy.get("e_scorefrom") != null && dy.get("e_scoreto") != null).sorted(Comparator.comparing(dy -> dy.getInt("e_scorefrom"))).collect(Collectors.toList());
        for (int i = 0; i < dyList.size() - 1; ++i) {
            int nextScoreFrom;
            DynamicObject curDy = (DynamicObject)dyList.get(i);
            DynamicObject nextDy = (DynamicObject)dyList.get(i + 1);
            int curScoreTo = curDy.getInt("e_scoreto");
            if (curScoreTo == (nextScoreFrom = nextDy.getInt("e_scorefrom"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u884c\u95f4\u7684\u5206\u6570\u8303\u56f4\u4e0d\u8fde\u7eed\uff0c\u8bf7\u8c03\u6574\u5206\u5f55\u884c\u7684\u5206\u6570\u8303\u56f4\u3002", (String)"RangeIsContinuousValidator_1", (String)"data-rsa-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

