/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.DimensionValueType;
import kd.data.rsa.formplugin.model.DimensionColumn;
import kd.data.rsa.model.DimensionValue;

public class DimensionValueHelper {
    private DimensionValueHelper() {
    }

    public static List<DimensionColumn> processInEdit(String dimensionValueStr, boolean displayNone) {
        if (StringUtils.isEmpty((String)dimensionValueStr)) {
            return null;
        }
        List dimensionValueList = JSON.parseArray((String)dimensionValueStr, DimensionValue.class);
        if (dimensionValueList.isEmpty()) {
            return null;
        }
        Object[] ids = new Object[dimensionValueList.size()];
        HashMap<Long, Object> dimensionMap = new HashMap<Long, Object>(dimensionValueList.size());
        int index = 0;
        for (DimensionValue dv : dimensionValueList) {
            ids[index++] = dv.getDimensionId();
            dimensionMap.put(dv.getDimensionId(), dv.getValue());
        }
        HashMap map = new HashMap(dimensionValueList.size());
        ArrayList<DimensionColumn> columnList = new ArrayList<DimensionColumn>(dimensionValueList.size());
        Map objMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"pa_dimension");
        if (objMap != null) {
            objMap.forEach((dimensionId, dimensionObj) -> {
                DynamicObjectCollection itemClos;
                String type = dimensionObj.getString("dimensiontype");
                String name = dimensionObj.getString("name");
                String number = dimensionObj.getString("number");
                DimensionColumn dc = new DimensionColumn((Long)dimensionId, "entry_" + number, name, dimensionMap.get(dimensionId), DimensionValueType.convertEnumByDimType((String)type));
                columnList.add(dc);
                if (dc.isBaseData()) {
                    String entityNumber = "1".equals(type) ? dimensionObj.getString("dimensionsource_id") : "bos_assistantdata_detail";
                    List list = map.computeIfAbsent(entityNumber, k -> new ArrayList(2));
                    list.add(Long.valueOf(String.valueOf(dc.getValue())));
                }
                if (dc.getDimensionValueType() == DimensionValueType.COMBO && (itemClos = dimensionObj.getDynamicObjectCollection("entryentityenums")) != null) {
                    HashMap<String, String> comboItemMap = new HashMap<String, String>(itemClos.size());
                    for (DynamicObject itemClo : itemClos) {
                        comboItemMap.put(itemClo.getString("value"), itemClo.getString("title"));
                    }
                    dc.setComBboValueItemMap(comboItemMap);
                }
            });
        }
        Set entrySet = map.entrySet();
        HashMap<String, String> valueNameMap = new HashMap<String, String>(dimensionValueList.size());
        for (Map.Entry entry : entrySet) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryValue", (String)((String)entry.getKey()), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())}, null);
            Throwable throwable = null;
            try {
                if (dataSet == null) continue;
                for (Row row : dataSet) {
                    valueNameMap.put(String.valueOf(row.getLong("id")), row.getString("name"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        for (DimensionColumn dc : columnList) {
            String valueName = null;
            switch (dc.getDimensionValueType()) {
                case BASEDATA: {
                    if (dc.getValue() != null) {
                        String valueStr = String.valueOf(dc.getValue());
                        valueName = (String)valueNameMap.get(valueStr);
                    }
                    if (displayNone || !StringUtils.isEmpty(valueName) && !"0".equals(valueName)) break;
                    valueName = "-";
                    break;
                }
                case COMBO: {
                    if (dc.getValue() != null) {
                        valueName = dc.getComBboValueItemMap().get(dc.getValue());
                        String string = valueName = valueName == null ? (String)dc.getValue() : valueName;
                    }
                    if (displayNone || !StringUtils.isEmpty(valueName)) break;
                    valueName = "-";
                    break;
                }
                default: {
                    if (dc.getValue() != null) {
                        valueName = String.valueOf(dc.getValue());
                    }
                    if (displayNone || !StringUtils.isEmpty((String)valueName)) break;
                    valueName = "-";
                }
            }
            dc.setValue(valueName);
        }
        return columnList;
    }

    public static Map<Object, String> processInList(Map<Object, String> idToDimensionValueStrMap, boolean displayNone) {
        HashMap<Object, String> displayStrMap = new HashMap<Object, String>(10);
        if (idToDimensionValueStrMap == null || idToDimensionValueStrMap.isEmpty()) {
            return displayStrMap;
        }
        HashMap<Object, List> allDimensionValueMap = new HashMap<Object, List>(idToDimensionValueStrMap.size());
        Set<Map.Entry<Object, String>> idToDimensionValueStrSet = idToDimensionValueStrMap.entrySet();
        for (Map.Entry<Object, String> dimensionValueStrEntry : idToDimensionValueStrSet) {
            String dimensionValueStr = dimensionValueStrEntry.getValue();
            if (StringUtils.isEmpty((String)dimensionValueStrEntry.getValue())) continue;
            List list = JSON.parseArray((String)dimensionValueStr, DimensionValue.class);
            allDimensionValueMap.put(dimensionValueStrEntry.getKey(), list);
        }
        if (allDimensionValueMap.isEmpty()) {
            return displayStrMap;
        }
        HashMap<Long, DimensionMerge> dimensionMergeMap = new HashMap<Long, DimensionMerge>(allDimensionValueMap.size());
        Set allDimensionValue = allDimensionValueMap.entrySet();
        for (Map.Entry entry : allDimensionValue) {
            List dvList = (List)entry.getValue();
            if (dvList == null) continue;
            for (DimensionValue dv : dvList) {
                DimensionMerge dm = (DimensionMerge)dimensionMergeMap.get(dv.getDimensionId());
                if (dm == null) {
                    dm = new DimensionMerge();
                    dm.id = dv.getDimensionId();
                    dimensionMergeMap.put(dv.getDimensionId(), dm);
                }
                String idStr = String.valueOf(dv.getValue());
                if (dv.getValue() instanceof Integer) {
                    dv.setValue((Object)Long.valueOf(idStr));
                }
                dm.idMap.put(dv.getValue(), idStr);
            }
        }
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)"pa_dimension", (QFilter[])new QFilter[]{new QFilter("id", "in", dimensionMergeMap.keySet())});
        if (objMap != null) {
            objMap.forEach((dimensionId, dimensionObj) -> {
                DynamicObjectCollection itemClos;
                String type = dimensionObj.getString("dimensiontype");
                DimensionMerge dm = (DimensionMerge)dimensionMergeMap.get((Long)dimensionId);
                dm.dimensiontype = DimensionValueType.convertEnumByDimType((String)type);
                dm.name = dimensionObj.getString("name");
                if (dm.isBaseData()) {
                    String entityNumber;
                    dm.dimensionsource = entityNumber = "1".equals(type) ? dimensionObj.getString("dimensionsource_id") : "bos_assistantdata_detail";
                }
                if (dm.dimensiontype == DimensionValueType.COMBO && (itemClos = dimensionObj.getDynamicObjectCollection("entryentityenums")) != null) {
                    HashMap<Object, String> comboItemMap = new HashMap<Object, String>(itemClos.size());
                    for (DynamicObject itemClo : itemClos) {
                        comboItemMap.put(itemClo.getString("value"), itemClo.getString("title"));
                    }
                    dm.idMap = comboItemMap;
                }
            });
        }
        Set set = dimensionMergeMap.entrySet();
        for (Map.Entry entry : set) {
            DimensionMerge dm = (DimensionMerge)entry.getValue();
            if (!dm.isBaseData()) continue;
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryValue", (String)dm.getEntityNumber(), (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", dm.getIdSet())}, null);
            Object object = null;
            try {
                if (dataSet == null) continue;
                for (Row row : dataSet) {
                    dm.idMap.put(row.getLong("id"), row.getString("name"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet == null) continue;
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        for (Map.Entry dvEntry : allDimensionValue) {
            List dvList = (List)dvEntry.getValue();
            if (dvList == null) continue;
            StringBuilder sb = new StringBuilder();
            for (DimensionValue dv : dvList) {
                DimensionMerge dm = (DimensionMerge)dimensionMergeMap.get(dv.getDimensionId());
                if (dm == null) continue;
                String dimensionName = dm.name;
                String valueName = dm.idMap.get(dv.getValue());
                if (!displayNone && (StringUtils.isEmpty((String)valueName) || "0".equals(valueName))) {
                    valueName = "-";
                }
                sb.append(dimensionName).append(':').append(valueName).append(',');
            }
            displayStrMap.put(dvEntry.getKey(), sb.substring(0, sb.length() - 1));
        }
        return displayStrMap;
    }

    static class DimensionMerge {
        public long id;
        public String name;
        public DimensionValueType dimensiontype;
        public String dimensionsource;
        public Map<Object, String> idMap = new HashMap<Object, String>(10);

        DimensionMerge() {
        }

        public boolean isBaseData() {
            return DimensionValueType.BASEDATA == this.dimensiontype;
        }

        public String getEntityNumber() {
            return this.isBaseData() ? this.dimensionsource : null;
        }

        public Set<Object> getIdSet() {
            return this.idMap.keySet();
        }
    }
}

