/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;

public class FilterConditionHelper {
    private FilterConditionHelper() {
    }

    public static FilterCondition createBasicFilterCondition(List<SimpleFilterRow> simpleFilterRowList) {
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.setFilterRow(simpleFilterRowList);
        return filterCondition;
    }

    public static SimpleFilterRow createBasicSimpleFilterRow(String fieldName, CompareTypeEnum compareTypeEnum, List<String> valueList) {
        SimpleFilterRow simpleFilterRow = new SimpleFilterRow();
        simpleFilterRow.setId(UUID.randomUUID().toString());
        simpleFilterRow.setLeftBracket("");
        simpleFilterRow.setCompareType(compareTypeEnum.getId());
        simpleFilterRow.setFieldName(fieldName);
        simpleFilterRow.setRightBracket("");
        simpleFilterRow.setLogic("0");
        simpleFilterRow.setValue(FilterConditionHelper.getBasicFilterValueList(valueList));
        return simpleFilterRow;
    }

    public static List<FilterValue> getBasicFilterValueList(List<String> valueList) {
        if (valueList == null || valueList.isEmpty()) {
            return new ArrayList<FilterValue>();
        }
        ArrayList<FilterValue> filterValueList = new ArrayList<FilterValue>(valueList.size());
        for (String value : valueList) {
            FilterValue filterValue = new FilterValue();
            filterValue.setId(UUID.randomUUID().toString());
            filterValue.setValue((Object)value);
            filterValueList.add(filterValue);
        }
        return filterValueList;
    }
}

