/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.imexport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.data.rsa.helper.OccurPossibilityHelper;
import kd.data.rsa.helper.ResultEffectHelper;
import kd.data.rsa.helper.RiskLevelEvalCriteriaHelper;

public class RiskBatchImportPlugin
extends BatchImportPlugin {
    private static final Log logger = LogFactory.getLog(RiskBatchImportPlugin.class);

    public String getBillFormId() {
        return "rsa_risk";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger importLogger) {
        for (ImportBillData importBillData : billdatas) {
            JSONObject data = importBillData.getData();
            this.validateData(data);
        }
        super.beforeSave(billdatas, importLogger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger importLogger) {
        for (ImportBillData importBillData : rowdatas) {
            JSONObject data = importBillData.getData();
            this.processData(data);
        }
        return super.save(rowdatas, importLogger);
    }

    private void validateData(JSONObject data) {
        if (data == null) {
            logger.error("[DATA-RSA] RiskBatchImportPlugin validateData data empty!");
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\u3002", (String)"RiskBatchImportPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        JSONArray anaEntry = data.getJSONArray("anaentryentity");
        if (anaEntry == null || anaEntry.isEmpty()) {
            return;
        }
        if (anaEntry.size() > 1) {
            logger.error("[DATA-RSA] RiskBatchImportPlugin validateData anaEntry oversize!");
            throw new KDBizException(ResManager.loadKDString((String)"\u98ce\u9669\u8bc4\u4f30\u5355\u636e\u4f53\u5206\u5f55\u4e0d\u80fd\u8d85\u8fc7\u4e00\u884c\u3002", (String)"RiskBatchImportPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        JSONObject anaEntryData = (JSONObject)anaEntry.get(0);
        BigDecimal occScore = anaEntryData.getBigDecimal("a_occscore");
        DynamicObject occDy = OccurPossibilityHelper.getSingle((BigDecimal)occScore);
        if (occDy == null) {
            int[] peakRange = OccurPossibilityHelper.getPeakRange();
            logger.error("[DATA-RSA] RiskBatchImportPlugin validateData occDy is null!");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u53d1\u751f\u53ef\u80fd\u6027\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4(%1$s,%2$s]\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskBatchImportPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]), peakRange[0], peakRange[1]));
        }
        BigDecimal resultScore = anaEntryData.getBigDecimal("a_resultscore");
        DynamicObject resDy = ResultEffectHelper.getSingle((BigDecimal)resultScore);
        if (resDy == null) {
            int[] peakRange = ResultEffectHelper.getPeakRange();
            logger.error("[DATA-RSA] RiskBatchImportPlugin validateData resDy is null!");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u540e\u679c\u5f71\u54cd\u7a0b\u5ea6\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4(%1$s,%2$s]\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskBatchImportPlugin_3", (String)"data-rsa-formplugin", (Object[])new Object[0]), peakRange[0], peakRange[1]));
        }
    }

    private void processData(JSONObject data) {
        if (data == null) {
            return;
        }
        JSONArray anaEntry = data.getJSONArray("anaentryentity");
        if (anaEntry != null) {
            if (anaEntry.isEmpty()) {
                JSONObject anaEntryData = new JSONObject();
                anaEntryData.put("a_name", (Object)"0");
                anaEntry.add((Object)anaEntryData);
            } else {
                DynamicObject riskLevelEvaDy;
                BigDecimal resultScore;
                DynamicObject resDy;
                JSONObject anaEntryData = (JSONObject)anaEntry.get(0);
                anaEntryData.put("a_name", (Object)"0");
                BigDecimal occScore = anaEntryData.getBigDecimal("a_occscore");
                DynamicObject occDy = OccurPossibilityHelper.getSingle((BigDecimal)occScore);
                if (occDy != null) {
                    anaEntryData.put("a_occdesc", (Object)occDy.getString("name"));
                }
                if ((resDy = ResultEffectHelper.getSingle((BigDecimal)(resultScore = anaEntryData.getBigDecimal("a_resultscore")))) != null) {
                    anaEntryData.put("a_resultdesc", (Object)resDy.getString("name"));
                }
                if (occDy != null && resDy != null && (riskLevelEvaDy = RiskLevelEvalCriteriaHelper.getSingle((Long)occDy.getLong("id"), (Long)resDy.getLong("id"))) != null && riskLevelEvaDy.get("risklevelid") != null) {
                    DynamicObject riskLevelDy = riskLevelEvaDy.getDynamicObject("risklevelid");
                    String riskLevelName = riskLevelEvaDy.getString("risklevelid.name");
                    anaEntryData.put("a_level", (Object)riskLevelDy);
                    anaEntryData.put("a_leveldesc", (Object)riskLevelName);
                    data.put("risklevel", (Object)riskLevelDy);
                }
                BigDecimal aScore = occScore.multiply(resultScore);
                anaEntryData.put("a_score", (Object)aScore);
                data.put("riskscore", (Object)aScore);
            }
        }
    }
}

