/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.logging;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.rsa.formplugin.helper.DimensionValueHelper;
import kd.data.rsa.formplugin.model.EventCustomAggFunction;

public class ExeLogEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_EVENT = "evententry";
    private static final String FIELD_EVENT = "eventid";
    private static final String FIELD_EVENT_BILLNO = "billno";
    private static final String FIELD_EVENT_NAME = "name";
    private static final String FIELD_EVENT_LEVEL = "risklevel";
    private static final String FIELD_EVENT_USER = "user";
    private static final String FIELD_EVENT_OTHERDIMENSION = "otherdimensionvalue_tag";
    private static final String FIELD_EVENT_STATUS = "status";

    public void afterLoadData(EventObject e) {
        IDataModel dataModel = this.getModel();
        int rowCount = dataModel.getEntryRowCount(ENTRY_ENTITY);
        if (rowCount > 0) {
            Object[] eventIds = new Object[rowCount];
            for (int index = 0; index < rowCount; ++index) {
                Long eventId = (Long)dataModel.getValue(FIELD_EVENT, index);
                eventIds[index] = eventId;
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"rsa_riskevent");
            ArrayList<EventRow> eventRowList = new ArrayList<EventRow>(eventIds.length);
            HashMap<Object, String> billnoToDimensionValueStrMap = new HashMap<Object, String>(eventIds.length);
            this.toEventRow(eventIds, eventRowList, billnoToDimensionValueStrMap);
            Map<Object, String> displayDimensionMap = DimensionValueHelper.processInList(billnoToDimensionValueStrMap, false);
            IDataEntityProperty property = entityType.findProperty(FIELD_EVENT_STATUS);
            ComboProp statusProp = (ComboProp)property;
            for (EventRow er : eventRowList) {
                String displayStatus;
                String displayStr;
                er.otherDisplayDimension = displayStr = displayDimensionMap == null ? null : displayDimensionMap.get(er.number);
                er.displayStatus = displayStatus = statusProp.getItemByName(er.status);
            }
            this.fetEventEntry(eventRowList);
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_EVENT);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    private void fetEventEntry(List<EventRow> eventRowList) {
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        String[] fields = this.getField();
        for (String field : fields) {
            tvs.addField(field, new Object[0]);
        }
        for (EventRow row : eventRowList) {
            tvs.addRow(row.toRow());
        }
        dataModel.batchCreateNewEntryRow(ENTRY_EVENT, tvs);
        dataModel.endInit();
        this.getView().updateView(ENTRY_EVENT);
    }

    private String[] getField() {
        return new String[]{"eventbillno", "eventname", "level", "otherdimension", FIELD_EVENT_USER, FIELD_EVENT_STATUS};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toEventRow(Object[] eventIds, List<EventRow> eventRowList, Map<Object, String> billnoToDimensionValueStrMap) {
        if (eventIds == null || eventIds.length == 0) {
            return;
        }
        EventCustomAggFunction function = new EventCustomAggFunction();
        try (DataSet gbDataSet = null;
             DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ExeLogEdit.afterLoadData", (String)"rsa_riskevent", (String)"billno,name,risklevel.name,otherdimensionvalue_tag,user.fbasedataid.name,status", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)eventIds)}, (String)FIELD_EVENT_BILLNO);){
            gbDataSet = dataSet.groupBy(new String[]{FIELD_EVENT_BILLNO, FIELD_EVENT_NAME, "risklevel.name", FIELD_EVENT_OTHERDIMENSION, FIELD_EVENT_STATUS}).agg((CustomAggFunction)function, "user.fbasedataid.name", "username").finish();
            for (Row row : gbDataSet) {
                EventRow er = new EventRow();
                er.number = row.getString(FIELD_EVENT_BILLNO);
                er.name = row.getString(FIELD_EVENT_NAME);
                er.level = row.getString("risklevel.name");
                er.otherDimension = row.getString(FIELD_EVENT_OTHERDIMENSION);
                er.status = row.getString(FIELD_EVENT_STATUS);
                er.users = row.getString("username");
                eventRowList.add(er);
                billnoToDimensionValueStrMap.put(er.number, er.otherDimension);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setBillStatus(BillOperationStatus.EDIT);
        billShowParameter.setStatus(OperationStatus.VIEW);
        Object eventId = this.getModel().getValue(FIELD_EVENT, hyperLinkClickEvent.getRowIndex());
        billShowParameter.setPkId(eventId);
        billShowParameter.setBillTypeId("rsa_riskevent");
        billShowParameter.setFormId("rsa_riskevent");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setPermissionEntityId("rsa_riskevent");
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    static class EventRow {
        public String number;
        public String name;
        public String level;
        public String otherDimension;
        public String otherDisplayDimension;
        public String users;
        public String status;
        public String displayStatus;

        EventRow() {
        }

        Object[] toRow() {
            return new Object[]{this.number, this.name, this.level, this.otherDisplayDimension, this.users, this.displayStatus};
        }
    }
}

