/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.param;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.data.rsa.helper.OrgHelper;

public class ScanParamEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ScanParamEdit.class);

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"scanorg", (CharSequence)name)) {
            model.setValue("risktext", null);
            model.setValue("riskids", null);
            model.setValue("riskids_tag", null);
            model.setValue("riskitem", null);
            return;
        }
        if (StringUtils.equals((CharSequence)"scanobject", (CharSequence)name)) {
            model.setValue("risktext", null);
            model.setValue("riskids", null);
            model.setValue("riskids_tag", null);
            model.setValue("riskitem", null);
            return;
        }
        if (StringUtils.equals((CharSequence)"risktext", (CharSequence)name) && StringUtils.isEmpty((CharSequence)(newValue = (String)e.getChangeSet()[0].getNewValue()))) {
            model.setValue("riskids", null);
            model.setValue("riskids_tag", null);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"risktext"});
        BasedataEdit scanOrgBaseData = (BasedataEdit)this.getControl("scanorg");
        scanOrgBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit riskItemBaseData = (BasedataEdit)this.getControl("riskitem");
        riskItemBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"scanorg", (CharSequence)key)) {
            List permOrgSet = OrgHelper.getPermOrgList((String)"rsa_riskcheck", (String)"2P7PKT+JSJPW");
            QFilter idFilter = new QFilter("id", "in", (Object)permOrgSet);
            evt.addCustomQFilter(idFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)"riskitem", (CharSequence)key)) {
            DynamicObjectCollection orgDyCol = (DynamicObjectCollection)this.getModel().getValue("scanorg");
            if (orgDyCol == null || orgDyCol.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u626b\u63cf\u7ec4\u7ec7\u201d\u3002", (String)"ScanParamEdit_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List orgIdList = orgDyCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
            QFilter riskItemFilter = BaseDataServiceHelper.getBaseDataFilter((String)"rsa_riskitem", orgIdList, (boolean)true);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            evt.addCustomQFilter(riskItemFilter);
            evt.addCustomQFilter(enableFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"riskF7", (CharSequence)actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)event.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            Set riskIdSet = returnData.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
            Set limitRiskIdSet = riskIdSet.stream().limit(5L).collect(Collectors.toSet());
            QFilter idFilter = new QFilter("id", "in", limitRiskIdSet);
            DynamicObjectCollection riskDyCol = QueryServiceHelper.query((String)"rsa_risk", (String)"name", (QFilter[])new QFilter[]{idFilter});
            List riskNameList = riskDyCol.stream().map(dy -> dy.getString("name")).collect(Collectors.toList());
            this.getModel().setValue("risktext", (Object)String.join((CharSequence)",", riskNameList));
            this.getModel().setValue("riskids", (Object)JSON.toJSONString(limitRiskIdSet));
            this.getModel().setValue("riskids_tag", (Object)JSON.toJSONString(riskIdSet));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"risktext", (CharSequence)key)) {
            this.openRiskF7();
        }
    }

    private void openRiskF7() {
        DynamicObjectCollection orgDyCol = (DynamicObjectCollection)this.getModel().getValue("scanorg");
        if (orgDyCol == null || orgDyCol.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u626b\u63cf\u7ec4\u7ec7\u201d\u3002", (String)"ScanParamEdit_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId("rsa_risk");
        lsp.setFormId("bos_treelistf7");
        lsp.setCaption(ResManager.loadKDString((String)"\u98ce\u9669\u5355\u5217\u8868", (String)"ScanParamEdit_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        lsp.setShowTitle(false);
        lsp.setLookUp(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("580px");
        styleCss.setWidth("960px");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.getOpenStyle().setInlineStyleCss(styleCss);
        String riskIds = (String)this.getModel().getValue("riskids_tag");
        if (StringUtils.isNotEmpty((CharSequence)riskIds)) {
            try {
                List riskIdList = (List)JSON.parseObject((String)riskIds, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
                lsp.setSelectedRows((Object[])riskIdList.toArray(new Long[0]));
            }
            catch (Exception e) {
                logger.error("[DATA-RSA] ScanParamEdit json parse error!", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff01", (String)"ScanParamEdit_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            }
        }
        List orgIdList = orgDyCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("dutyorg", "in", orgIdList);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        lsp.getListFilterParameter().setFilter(orgFilter.and(statusFilter));
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "riskF7"));
        this.getView().showForm((FormShowParameter)lsp);
    }
}

