/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.rsa.formplugin.helper.ComboItemHelper;
import kd.data.rsa.helper.OrgHelper;
import kd.data.rsa.helper.RiskGroupHelper;
import kd.data.rsa.helper.RiskHelper;
import kd.data.rsa.model.RiskHeatMapModel;

public class RiskHeatMapReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(RiskHeatMapReportFormPlugin.class);

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        List commonFilterColumnList = contInitEvent.getCommonFilterColumns();
        List permOrgList = OrgHelper.getPermOrgList((String)"rsa_riskheatmap", (String)"47150e89000000ac");
        QFilter idFilter = new QFilter("id", "in", (Object)permOrgList);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{idFilter});
        for (FilterColumn filterColumn : commonFilterColumnList) {
            List<ComboItem> comboItemList;
            String fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"dutyorg", (CharSequence)fieldName) || (comboItemList = ComboItemHelper.createComboItemList(orgMap.values())).isEmpty()) continue;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setDefaultValue(comboItemList.get(0).getValue());
            commonFilterColumn.setComboItems(comboItemList);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)"dutyorg.id", (CharSequence)fieldName)) {
            List permOrgList = OrgHelper.getPermOrgList((String)"rsa_riskheatmap", (String)"47150e89000000ac");
            QFilter idFilter = new QFilter("id", "in", (Object)permOrgList);
            args.addCustomQFilter(idFilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        IReportView view = this.getView();
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)fieldName)) {
            DynamicObject rowDataDy = event.getRowData();
            if (rowDataDy == null) {
                logger.error("[DATA-RSA] Event getRowData is null!");
                return;
            }
            String billNo = rowDataDy.getString("billno");
            QFilter billNoFilter = new QFilter("billno", "=", (Object)billNo);
            DynamicObject riskDy = QueryServiceHelper.queryOne((String)"rsa_risk", (String)"id", (QFilter[])new QFilter[]{billNoFilter});
            if (riskDy == null) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u5355[%s]\u5df2\u88ab\u5220\u9664\u6216\u4e0d\u5b58\u5728!", (String)"RiskHeatMapReportFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]), billNo));
                return;
            }
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)riskDy.getLong("id"));
            billShowParameter.setFormId("rsa_risk");
            billShowParameter.setPermissionEntityId("rsa_risk");
            billShowParameter.setPermissionItemId("47150e89000000ac");
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)billShowParameter);
        }
    }

    public void beforeQuery(ReportQueryParam reportQueryParam) {
        super.beforeQuery(reportQueryParam);
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getView().getPageCache();
        String queryParamStr = (String)model.getValue("queryparam");
        if (StringUtils.equals((CharSequence)"init", (CharSequence)queryParamStr)) {
            reportQueryParam.setCustomParam(null);
            pageCache.put("riskHeatMapParam", null);
            return;
        }
        if (StringUtils.equals((CharSequence)"heatmapclick", (CharSequence)queryParamStr)) {
            String riskHeatMapParamStr = pageCache.get("riskHeatMapParam");
            if (StringUtils.isNotEmpty((CharSequence)riskHeatMapParamStr)) {
                Map customParamMap;
                try {
                    customParamMap = (Map)JSON.parseObject((String)riskHeatMapParamStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                }
                catch (Exception e) {
                    logger.error("[DATA-RSA] Heatmapclick Json parse error!", (Throwable)e);
                    return;
                }
                if (customParamMap != null) {
                    reportQueryParam.setCustomParam(customParamMap);
                }
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"query", (CharSequence)queryParamStr)) {
            pageCache.put("riskHeatMapParam", null);
            reportQueryParam.setCustomParam(null);
            this.createHeatMap();
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        IDataModel model = this.getModel();
        String queryParamStr = (String)model.getValue("queryparam");
        if (StringUtils.equals((CharSequence)"heatmapclick", (CharSequence)queryParamStr)) {
            this.unLockHeatMap();
        }
        model.setValue("queryparam", (Object)"query");
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            event.setFilter(true);
            event.setSort(false);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        IReportView view = this.getView();
        IDataModel model = this.getModel();
        IPageCache pageCache = view.getPageCache();
        if (StringUtils.equals((CharSequence)"heatmapcontrol", (CharSequence)key) && StringUtils.equals((CharSequence)"mounted", (CharSequence)eventName)) {
            this.createHeatMap();
            return;
        }
        if (StringUtils.equals((CharSequence)"heatmapcontrol", (CharSequence)key) && StringUtils.equals((CharSequence)"cell_click", (CharSequence)eventName)) {
            String eventData = e.getEventArgs();
            pageCache.put("riskHeatMapParam", eventData);
            model.setValue("queryparam", (Object)"heatmapclick");
            view.refresh();
            return;
        }
        if (StringUtils.equals((CharSequence)"heatmapcontrol", (CharSequence)key) && StringUtils.equals((CharSequence)"cell_clear_click", (CharSequence)eventName)) {
            view.refresh();
        }
    }

    private void createHeatMap() {
        IReportView view = this.getView();
        IPageCache pageCache = view.getPageCache();
        RiskHeatMapModel riskHeatMapModel = RiskHeatMapModel.create();
        pageCache.put("riskHeatMapModel", SerializationUtils.toJsonString((Object)riskHeatMapModel));
        List xAxisModelList = riskHeatMapModel.getxAxisModelList();
        List yAxisModelList = riskHeatMapModel.getyAxisModelList();
        List<QFilter> qFilters = this.getQFilter(this.getQueryParam());
        List cellModelDataList = RiskHelper.getHeatMapData(qFilters, (RiskHeatMapModel)riskHeatMapModel);
        CustomControl customControl = (CustomControl)this.getControl("heatmapcontrol");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("event", "create");
        dataMap.put("xAxisLabel", ResManager.loadKDString((String)"\u540e\u679c\u5f71\u54cd\u7a0b\u5ea6", (String)"RiskHeatMapReportFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        dataMap.put("yAxisLabel", ResManager.loadKDString((String)"\u53d1\u751f\u53ef\u80fd\u6027", (String)"RiskHeatMapReportFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        dataMap.put("xAxis", xAxisModelList);
        dataMap.put("yAxis", yAxisModelList);
        dataMap.put("cells", cellModelDataList);
        dataMap.put("date", new Date().getTime());
        customControl.setData(dataMap);
    }

    private void unLockHeatMap() {
        CustomControl customControl = (CustomControl)this.getControl("heatmapcontrol");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("event", "clear_loading");
        dataMap.put("date", new Date().getTime());
        customControl.setData(dataMap);
    }

    private List<QFilter> getQFilter(ReportQueryParam reportQueryParam) {
        ArrayList<QFilter> resultQFilterList = new ArrayList<QFilter>();
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{"C", "D"});
        resultQFilterList.add(billStatusFilter);
        List qFilterList = reportQueryParam.getFilter().getQFilters();
        for (QFilter qFilter : qFilterList) {
            long groupId;
            long orgId;
            String property = qFilter.getProperty();
            if (StringUtils.equals((CharSequence)"dutyorg.id", (CharSequence)property) && (orgId = Long.parseLong(qFilter.getValue().toString())) != 0L) {
                List subOrgList = OrgHelper.getSubOrgList(Collections.singletonList(orgId));
                QFilter dutyOrgFilter = new QFilter("dutyorg.id", "in", (Object)subOrgList);
                resultQFilterList.add(dutyOrgFilter);
                continue;
            }
            if (StringUtils.equals((CharSequence)"group.id", (CharSequence)property) && (groupId = Long.parseLong(qFilter.getValue().toString())) != 0L) {
                List subGroupList = RiskGroupHelper.getSubGroupListById((Long)groupId);
                QFilter groupFilter = new QFilter("group.id", "in", (Object)subGroupList);
                resultQFilterList.add(groupFilter);
                continue;
            }
            resultQFilterList.add(qFilter);
        }
        return resultQFilterList;
    }
}

