/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.data.rsa.helper.OrgHelper;
import kd.data.rsa.helper.RiskGroupHelper;
import kd.data.rsa.helper.RiskHelper;

public class RiskHeatMapReportListDataPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(RiskHeatMapReportListDataPlugin.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object selectedObj) throws Throwable {
        try {
            List<QFilter> qFilterList = this.getQFilters(reportQueryParam);
            Map<String, Object> extraParamMap = this.getExtraParam(reportQueryParam);
            return RiskHelper.getHeatMapListDataSet(qFilterList, extraParamMap);
        }
        catch (Exception e) {
            logger.error("[DATA-RSA] RiskHeatMapReportListDataPlugin query error!", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private List<QFilter> getQFilters(ReportQueryParam reportQueryParam) {
        ArrayList<QFilter> resultQFilterList = new ArrayList<QFilter>();
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{"C", "D"});
        resultQFilterList.add(billStatusFilter);
        List qFilterList = reportQueryParam.getFilter().getQFilters();
        for (QFilter qFilter : qFilterList) {
            long groupId;
            long orgId;
            String property = qFilter.getProperty();
            if (StringUtils.equals((CharSequence)"dutyorg.id", (CharSequence)property) && (orgId = Long.parseLong(qFilter.getValue().toString())) != 0L) {
                List subOrgList = OrgHelper.getSubOrgList(Collections.singletonList(orgId));
                QFilter dutyOrgFilter = new QFilter("dutyorg.id", "in", (Object)subOrgList);
                resultQFilterList.add(dutyOrgFilter);
                continue;
            }
            if (StringUtils.equals((CharSequence)"group.id", (CharSequence)property) && (groupId = Long.parseLong(qFilter.getValue().toString())) != 0L) {
                List subGroupList = RiskGroupHelper.getSubGroupListById((Long)groupId);
                QFilter groupFilter = new QFilter("group.id", "in", (Object)subGroupList);
                resultQFilterList.add(groupFilter);
                continue;
            }
            resultQFilterList.add(qFilter);
        }
        List headFilterList = reportQueryParam.getFilter().getHeadFilters();
        for (QFilter qFilter : headFilterList) {
            Object value;
            String cp;
            String property = qFilter.getProperty();
            if (StringUtils.equals((CharSequence)"group", (CharSequence)property) || StringUtils.equals((CharSequence)"risklevel", (CharSequence)property) || StringUtils.equals((CharSequence)"dutyorg", (CharSequence)property)) {
                cp = qFilter.getCP();
                value = qFilter.getValue();
                QFilter baseDataFilter = new QFilter(property + ".name", cp, value);
                resultQFilterList.add(baseDataFilter);
                continue;
            }
            if (StringUtils.equals((CharSequence)"riskscore", (CharSequence)property) || StringUtils.equals((CharSequence)"lossamount", (CharSequence)property) || StringUtils.equals((CharSequence)"riskeventnum", (CharSequence)property) || StringUtils.equals((CharSequence)"riskworknum", (CharSequence)property)) {
                cp = qFilter.getCP();
                value = (String)qFilter.getValue();
                QFilter numericFilter = new QFilter(property, cp, (Object)Long.valueOf((String)value));
                resultQFilterList.add(numericFilter);
                continue;
            }
            resultQFilterList.add(qFilter);
        }
        return resultQFilterList;
    }

    private Map<String, Object> getExtraParam(ReportQueryParam reportQueryParam) {
        Map extraParamMap = reportQueryParam.getCustomParam();
        if (extraParamMap == null || extraParamMap.isEmpty()) {
            return new HashMap<String, Object>();
        }
        if (!extraParamMap.containsKey("xRange") || !extraParamMap.containsKey("yRange")) {
            return new HashMap<String, Object>();
        }
        return extraParamMap;
    }
}

