/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.riskcheck;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;
import kd.data.rsa.enums.TimeTypeEnum;
import kd.data.rsa.helper.OrgHelper;
import kd.data.rsa.helper.RiskCheckHelper;
import kd.data.rsa.model.RiskCheckStatisticsDTO;
import kd.data.rsa.task.RSALazyCalculateTask;
import org.apache.commons.lang3.StringUtils;

public class RSARiskCheckFormPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
BeforeF7SelectListener,
ProgresssListener,
CellClickListener {
    private static final String staticUrl = "/images/pc/other/zncw_cwgx_200_200.png";
    private static final String gifUrl = "/icons/pc/other/zncw_sjtb_214_214.gif";
    private static final String ORG = "org";
    private static final String PERIOD = "period";
    private static final String FBASEDATAID_ID = "fbasedataid_id";
    private static final String RISKCHECKITEM = "riskcheckitem";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String CACHE_TASKKEY = "cache_taskKey";
    private static final String RISKITEM_COUNT = "riskItem_count";
    private static final String BUTTON_BACK = "back";
    private static final String BUTTON_BACK1 = "back1";
    private static final String BUTTON_CHECKLOG = "checklog";
    private static final String PERIODTYPE = "periodtype";
    private static final String RISKCHECKFORM = "riskCheckForm";
    private static final String ORGENTRY = "orgentry";
    private static final String PERIODENTRY = "periodentry";
    private static final String ANALPERIODENTRY = "analperiodentry";
    private static final String ERRORMESSAGE = "errormessage";
    private static final String BD_PERIOD = ",bd_period,";
    private static final String PA_ANALYSISPERIOD = ",pa_analysisperiod,";
    private static final String TIMETYPE = "timetype";
    private static final String ANALYSISPERIOD = "analysisperiod";
    private static final String RISK = "risk";
    private static final String SCANOBJECT = "scanobject";
    private static final String RISKID_TAG = "riskid_tag";
    private final IAppCache cache = AppCache.get((String)"RSA");

    public void afterBindData(EventObject e) {
        this.setVisible(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"detailinfo"});
        HashMap mustMap = new HashMap();
        HashMap<String, Boolean> mustInput = new HashMap<String, Boolean>();
        mustInput.put("mi", true);
        mustMap.put("item", mustInput);
        this.getView().updateControlMetadata(ANALYSISPERIOD, mustMap);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addAfterF7SelectListener((AfterF7SelectListener)this);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl(PERIOD);
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit riskcheckitem = (BasedataEdit)this.getControl(RISKCHECKITEM);
        riskcheckitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodType = (BasedataEdit)this.getControl(PERIODTYPE);
        periodType.addAfterF7SelectListener((AfterF7SelectListener)this);
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BUTTON_BACK, BUTTON_CHECKLOG, BUTTON_BACK1, RISK});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        switch (key) {
            case "back": 
            case "back1": {
                this.setVisible(false);
                this.getView().setVisible(Boolean.FALSE, new String[]{"detailinfo"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"corecontentap"});
                model.deleteEntryData("entryentity");
                model.setValue("riskitemcount", (Object)0);
                break;
            }
            case "checklog": {
                String riskExeLog;
                String timeType = model.getValue(TIMETYPE).toString();
                String[] splitTimeType = timeType.substring(1, timeType.length() - 1).split(",");
                ListShowParameter lsp = new ListShowParameter();
                lsp.setBillFormId("rsa_exelog");
                lsp.setFormId("bos_list");
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                lsp.setFilterSchemeId("0");
                lsp.setCustomParam(RISKCHECKFORM, (Object)RISKCHECKFORM);
                if (splitTimeType.length == 1) {
                    lsp.setCustomParam(TIMETYPE, (Object)splitTimeType[0]);
                }
                if (StringUtils.isNotEmpty((CharSequence)(riskExeLog = this.getPageCache().get("riskExeLog")))) {
                    try {
                        List exeLogIds = (List)JSON.parseObject((String)riskExeLog, (TypeReference)new TypeReference<List<Object>>(){}, (Feature[])new Feature[0]);
                        if (exeLogIds == null || exeLogIds.isEmpty()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"RSARiskCheckFormPlugin_33", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
                        exeLogIds.forEach(arg_0 -> ((LinkQueryPkIdCollection)linkQueryPkIdCollection).addLinkQueryPkId(arg_0));
                        lsp.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
                    }
                    catch (Exception e) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u7edf\u8ba1\u7c7b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RSARiskCheckFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                this.getView().showForm((FormShowParameter)lsp);
                break;
            }
            case "risk": {
                Object org = model.getValue(ORG);
                if (org == null || ((MulBasedataDynamicObjectCollection)org).isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ec4\u7ec7\u201d\u3002", (String)"RSARiskCheckFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    model.setValue(ORG, null);
                    return;
                }
                List orgIds = ((MulBasedataDynamicObjectCollection)org).stream().map(x -> x.getLong(FBASEDATAID_ID)).collect(Collectors.toList());
                ListShowParameter lsp = new ListShowParameter();
                lsp.setBillFormId("rsa_risk");
                lsp.setFormId("bos_treelistf7");
                lsp.setCaption(ResManager.loadKDString((String)"\u98ce\u9669\u5355\u5217\u8868", (String)"RSARiskCheckFormPlugin_16", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                lsp.setShowTitle(false);
                lsp.setLookUp(true);
                lsp.getOpenStyle().setShowType(ShowType.Modal);
                if (StringUtils.isNotEmpty((CharSequence)model.getValue(RISKID_TAG).toString())) {
                    QFilter qFilter = new QFilter("dutyorg", "in", orgIds).and("billstatus", "=", (Object)Character.valueOf('C'));
                    List rsaRiskIds = QueryServiceHelper.queryPrimaryKeys((String)"rsa_risk", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
                    Set riskIds = (Set)SerializationUtils.deSerializeFromBase64((String)model.getValue(RISKID_TAG).toString());
                    riskIds.retainAll(rsaRiskIds);
                    lsp.setSelectedRows(riskIds.toArray(new Object[0]));
                }
                ListFilterParameter lfp = lsp.getListFilterParameter();
                lfp.setFilter(new QFilter("dutyorg", "in", orgIds).and("billstatus", "=", (Object)Character.valueOf('C')));
                StyleCss styleCss = new StyleCss();
                styleCss.setHeight("580px");
                styleCss.setWidth("960px");
                lsp.getOpenStyle().setInlineStyleCss(styleCss);
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RISK));
                this.getView().showForm((FormShowParameter)lsp);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        if (RISK.equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Set riskId = ((ListSelectedRowCollection)returnData).stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                model.setValue(RISKID_TAG, (Object)SerializationUtils.serializeToBase64(riskId));
                List riskNameList = QueryServiceHelper.query((String)"rsa_risk", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", riskId)}).stream().map(x -> x.getString("name")).collect(Collectors.toList());
                String riskName = String.join((CharSequence)",", riskNameList);
                model.setValue(RISK, (Object)String.join((CharSequence)",", riskName.substring(0, Math.min(riskName.length(), 50))));
            } else {
                super.closedCallBack(closedCallBackEvent);
            }
        }
    }

    private void setVisible(boolean checkItem) {
        if (checkItem) {
            this.changeImage("imageap", gifUrl);
            this.getView().setVisible(Boolean.FALSE, new String[]{"parampanelap", BUTTON_BACK1, ERRORMESSAGE});
            this.getView().setVisible(Boolean.TRUE, new String[]{"checkinfo"});
        } else {
            this.changeImage("imageap", staticUrl);
            this.getView().setVisible(Boolean.FALSE, new String[]{"checkinfo", BUTTON_BACK1, ERRORMESSAGE});
            this.getView().setVisible(Boolean.TRUE, new String[]{"parampanelap"});
            this.getModel().setValue("successcount", (Object)Character.valueOf('0'));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("check".equals(key)) {
            List codeRuleInfoList = new CodeRuleServiceHelper().getAllCodeRuleByEntity("rsa_riskevent");
            if (codeRuleInfoList.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u98ce\u9669\u9884\u8b66\u7684\u53ef\u7528\u7684\u7f16\u53f7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u7f16\u53f7\u89c4\u5219\u914d\u7f6e\u60c5\u51b5\u3002", (String)"RSARiskCheckFormPlugin_28", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (!this.paramValidate()) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("check".equals(args.getOperateKey())) {
            if (this.checkAvailableRiskItem().isEmpty()) {
                this.getModel().setValue(ORG, null);
                return;
            }
            if (this.checkPeriodMatch()) {
                this.checkOrgFasPermission();
            }
        }
    }

    private Map<Object, DynamicObject> checkActiveFields(Set<Long> orgSet, Object periodId, Set<Object> riskItems) {
        QFilter qFilter = new QFilter(ORG, "in", orgSet);
        qFilter.and(new QFilter(PERIOD, "=", periodId));
        qFilter.and(new QFilter("riskitem", "in", riskItems));
        Map exeLogDyn = BusinessDataServiceHelper.loadFromCache((String)"rsa_exelog", (String)"org, riskitem", (QFilter[])qFilter.toArray(), (String)"riskitem");
        return exeLogDyn;
    }

    private void changeImage(String apMark, String imageUrl) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("imageKey", imageUrl);
        this.getView().updateControlMetadata(apMark, data);
    }

    private void checkOrgFasPermission() {
        IDataModel model = this.getModel();
        Set orgSet = ((MulBasedataDynamicObjectCollection)model.getValue(ORG)).stream().map(dynamicObject -> dynamicObject.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
        String scanObject = model.getValue(SCANOBJECT).toString();
        Set<Object> riskItems = new HashSet(10);
        boolean isRisk = "0".equals(scanObject);
        boolean noChoseRiskItem = false;
        boolean noChoseRisk = false;
        if (isRisk) {
            Set riskIds;
            noChoseRiskItem = true;
            String riskIdTag = (String)model.getValue(RISKID_TAG);
            if (StringUtils.isEmpty((CharSequence)riskIdTag)) {
                noChoseRisk = true;
                riskIds = this.checkAvailableRisk();
            } else {
                riskIds = (Set)SerializationUtils.deSerializeFromBase64((String)model.getValue(RISKID_TAG).toString());
            }
            if (riskIds != null && !riskIds.isEmpty()) {
                int riskCount = 0;
                Map riskDynMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risk", (String)"id, dutyorg.id, riskitem", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)riskIds).and("billstatus", "=", (Object)"C")});
                if (riskDynMap == null || riskDynMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u98ce\u9669\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RSARiskCheckFormPlugin_35", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    model.setValue(RISK, null);
                    model.setValue(RISKID_TAG, null);
                    return;
                }
                Map<Long, List> riskMap = riskDynMap.values().stream().collect(Collectors.toMap(risk -> risk.getLong("id"), risk -> ((MulBasedataDynamicObjectCollection)risk.get("riskitem")).stream().map(item -> item.getLong(FBASEDATAID_ID)).collect(Collectors.toList())));
                HashMap<Long, Long> noItemRiskMap = new HashMap<Long, Long>(10);
                for (Map.Entry<Long, List> riskItemEntry : riskMap.entrySet()) {
                    if (!riskItemEntry.getValue().isEmpty()) {
                        ++riskCount;
                        continue;
                    }
                    noItemRiskMap.put(riskItemEntry.getKey(), ((DynamicObject)riskDynMap.get(riskItemEntry.getKey())).getLong("dutyorg.id"));
                }
                this.getPageCache().put("riskcount", noChoseRisk ? String.valueOf(riskCount) : String.valueOf(riskIds.size()));
                riskItems = riskMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
                this.getPageCache().put("riskMap", SerializationUtils.serializeToBase64(riskMap));
                if (!noItemRiskMap.isEmpty() && !noChoseRisk) {
                    this.getPageCache().put("noItemRiskMap", SerializationUtils.serializeToBase64(noItemRiskMap));
                }
            }
        } else {
            riskItems = ((MulBasedataDynamicObjectCollection)model.getValue(RISKCHECKITEM)).stream().map(dynamicObject -> dynamicObject.get(FBASEDATAID_ID)).collect(Collectors.toSet());
            if (riskItems.isEmpty()) {
                noChoseRiskItem = true;
                riskItems = this.checkAvailableRiskItem();
            }
        }
        Set noMatchItemIdSet = StringUtils.isEmpty((CharSequence)this.getPageCache().get("nomatchitem")) ? Collections.emptySet() : (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("nomatchitem"), Set.class);
        riskItems.removeAll(noMatchItemIdSet);
        if (!riskItems.isEmpty()) {
            List riskItemNumbers;
            QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            qFilter.and(new QFilter("id", "in", riskItems));
            Map riskItemsMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_riskitem", (QFilter[])new QFilter[]{qFilter});
            if (noChoseRiskItem) {
                if (riskItemsMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u98ce\u9669\u68c0\u67e5\u9879\u3002", (String)"RSARiskCheckFormPlugin_7", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                riskItems = riskItemsMap.keySet();
                this.getPageCache().put("riskItemId", SerializationUtils.toJsonString(riskItems));
                this.repetitiveExecution();
                return;
            }
            if (riskItemsMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u98ce\u9669\u68c0\u67e5\u9879\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RSARiskCheckFormPlugin_12", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                model.setValue(RISKCHECKITEM, null);
                return;
            }
            riskItems = riskItemsMap.keySet();
            this.getPageCache().put("riskItemId", SerializationUtils.toJsonString(riskItems));
            Set riskItemSet = RiskCheckHelper.validateRiskItem(riskItems, (Object[])orgSet.toArray());
            HashSet riskItemIds = new HashSet(riskItems);
            riskItemIds.removeAll(riskItemSet);
            Map riskItemMap = BusinessDataServiceHelper.loadFromCache((Object[])riskItemIds.toArray(), (String)"rsa_riskitem");
            if (riskItemIds.size() == riskItems.size()) {
                riskItemNumbers = riskItemMap.values().stream().map(s -> s.getString("number")).collect(Collectors.toList());
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u65e0\u6cd5\u4f7f\u7528\u4e0b\u5217\u98ce\u9669\u68c0\u67e5\u9879\uff0c\u8bf7\u524d\u5f80\u98ce\u9669\u68c0\u67e5\u9879\u5217\u8868\u7ef4\u62a4\u98ce\u9669\u68c0\u67e5\u9879\u6570\u636e\u3002", (String)"RSARiskCheckFormPlugin_32", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", riskItemNumbers), MessageTypes.Default);
                return;
            }
            if (!riskItemIds.isEmpty()) {
                riskItemNumbers = riskItemMap.values().stream().map(s -> s.getString("number")).collect(Collectors.toList());
                if (isRisk) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u56e0\u8be5\u7ec4\u7ec7\u65e0\u6cd5\u4f7f\u7528\u6240\u9009\u98ce\u9669\u5173\u8054\u7684\u98ce\u9669\u68c0\u67e5\u9879\uff08%s\uff09\uff0c\u7cfb\u7edf\u5c06\u4e0d\u4f1a\u6267\u884c\u626b\u63cf\u8fd9\u4e9b\u68c0\u67e5\u9879\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u626b\u63cf\u3002", (String)"RSARiskCheckFormPlugin_29", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", riskItemNumbers)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("activatecheck", (IFormPlugin)this));
                    return;
                }
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u56e0\u8be5\u7ec4\u7ec7\u65e0\u6cd5\u4f7f\u7528\u6240\u9009\u98ce\u9669\u68c0\u67e5\u9879\uff08%s\uff09\uff0c\u7cfb\u7edf\u5c06\u4e0d\u4f1a\u6267\u884c\u626b\u63cf\u8fd9\u4e9b\u68c0\u67e5\u9879\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u626b\u63cf\u3002", (String)"RSARiskCheckFormPlugin_30", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", riskItemNumbers)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("activatecheck", (IFormPlugin)this));
                return;
            }
            riskItemMap = BusinessDataServiceHelper.loadFromCache((Object[])riskItems.toArray(), (String)"rsa_riskitem");
            Map riskItemOrgMap = RiskCheckHelper.getRiskItemOrgMap((Map)riskItemMap, (Object[])orgSet.toArray());
            if (riskItemOrgMap.isEmpty()) {
                List riskItemNumbers2 = riskItemMap.values().stream().map(s -> s.getString("number")).collect(Collectors.toList());
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u65e0\u6cd5\u4f7f\u7528\u4e0b\u5217\u98ce\u9669\u68c0\u67e5\u9879\u5173\u8054\u7684\u6307\u6807\uff0c\u8bf7\u524d\u5f80\u6307\u6807\u5217\u8868\u7ef4\u62a4\u6307\u6807\u6570\u636e\u3002", (String)"RSARiskCheckFormPlugin_17", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", riskItemNumbers2), MessageTypes.Default);
            } else {
                riskItems.removeAll(riskItemOrgMap.keySet());
                if (!riskItems.isEmpty()) {
                    Set<Object> finalRiskItems = riskItems;
                    List riskItemNumbers3 = riskItemMap.values().stream().filter(s -> finalRiskItems.contains(s.get("id"))).map(s -> s.getString("number")).collect(Collectors.toList());
                    if (isRisk) {
                        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u56e0\u8be5\u7ec4\u7ec7\u65e0\u6cd5\u4f7f\u7528\u6240\u9009\u98ce\u9669\u5173\u8054\u7684\u98ce\u9669\u68c0\u67e5\u9879\uff08%s\uff09\u5173\u8054\u7684\u6307\u6807\uff0c\u7cfb\u7edf\u5c06\u4e0d\u4f1a\u6267\u884c\u626b\u63cf\u8fd9\u4e9b\u68c0\u67e5\u9879\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u626b\u63cf\u3002", (String)"RSARiskCheckFormPlugin_31", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", riskItemNumbers3)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("activatecheck", (IFormPlugin)this));
                    } else {
                        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u56e0\u8be5\u7ec4\u7ec7\u65e0\u6cd5\u4f7f\u7528\u6240\u9009\u98ce\u9669\u68c0\u67e5\u9879\uff08%s\uff09\u5173\u8054\u7684\u6307\u6807\uff0c\u7cfb\u7edf\u5c06\u4e0d\u4f1a\u6267\u884c\u626b\u63cf\u8fd9\u4e9b\u68c0\u67e5\u9879\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u626b\u63cf\u3002", (String)"RSARiskCheckFormPlugin_18", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\uff0c", riskItemNumbers3)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("activatecheck", (IFormPlugin)this));
                    }
                } else {
                    this.repetitiveExecution();
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u98ce\u9669\u68c0\u67e5\u9879\u3002", (String)"RSARiskCheckFormPlugin_7", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            model.setValue(RISKCHECKITEM, null);
        }
    }

    private void repetitiveExecution() {
        IDataModel model = this.getModel();
        Set<Long> orgSet = ((MulBasedataDynamicObjectCollection)model.getValue(ORG)).stream().map(dynamicObject -> dynamicObject.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
        Object analysisPeriodId = model.getValue(ANALYSISPERIOD) == null ? null : ((DynamicObject)model.getValue(ANALYSISPERIOD)).getPkValue();
        Object periodId = model.getValue(PERIOD) == null ? null : ((DynamicObject)model.getValue(PERIOD)).getPkValue();
        Set riskItems = this.getPageCache().get("riskItemId") == null ? null : (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("riskItemId"), Set.class);
        boolean isRisk = "0".equals(model.getValue(SCANOBJECT).toString());
        if (riskItems != null && !riskItems.isEmpty()) {
            String timeType = model.getValue(TIMETYPE).toString();
            StringBuilder confirmMessageSb = null;
            if (timeType.contains("bd_period")) {
                confirmMessageSb = this.checkRepetitiveExecution(orgSet, periodId, riskItems, confirmMessageSb, isRisk);
            }
            if (timeType.contains("pa_analysisperiod")) {
                confirmMessageSb = this.checkRepetitiveExecution(orgSet, analysisPeriodId, riskItems, confirmMessageSb, isRisk);
            }
            if (confirmMessageSb != null) {
                this.getView().showConfirm(confirmMessageSb.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("activate_riskCheck", (IFormPlugin)this));
            } else {
                this.activateRiskCheck();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u98ce\u9669\u68c0\u67e5\u9879\u3002", (String)"RSARiskCheckFormPlugin_7", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
    }

    private StringBuilder checkRepetitiveExecution(Set<Long> orgSet, Object periodId, Set<Object> riskItemsOrRiskIds, StringBuilder tips, boolean isRisk) {
        Map<Object, DynamicObject> exeLogDyn = this.checkActiveFields(orgSet, periodId, riskItemsOrRiskIds);
        if (!exeLogDyn.isEmpty()) {
            if (tips == null) {
                tips = new StringBuilder();
                tips.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u5728\u6240\u9009\u62e9\u7684\u671f\u95f4\u4e0b\u5df2\u6267\u884c\u8fc7\u98ce\u9669\u68c0\u67e5,\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u6267\u884c: ", (String)"RSARiskCheckFormPlugin_19", (String)"data-rsa-formplugin", (Object[])new Object[0])).append("\r\n");
            }
            HashSet<String> orgMessageSet = new HashSet<String>(10);
            String riskItem = null;
            for (DynamicObject value : exeLogDyn.values()) {
                String riskItemName = value.getString("riskitem.name");
                if (!riskItemName.equals(riskItem)) {
                    if (!orgMessageSet.isEmpty()) {
                        tips.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879(%1$s)\uff1a\u7ec4\u7ec7(%2$s)\uff1b", (String)"RSARiskCheckFormPlugin_4", (String)"data-rsa-formplugin", (Object[])new Object[0]), riskItem, StringUtils.join(orgMessageSet, (char)'\u3001'))).append("\r\n");
                    }
                    riskItem = riskItemName;
                    orgMessageSet = new HashSet(10);
                }
                orgMessageSet.add(value.getString("org.name"));
            }
            tips.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u9879(%1$s)\uff1a\u7ec4\u7ec7(%2$s)\uff1b", (String)"RSARiskCheckFormPlugin_4", (String)"data-rsa-formplugin", (Object[])new Object[0]), riskItem, StringUtils.join(orgMessageSet, (char)'\u3001'))).append("\r\n");
        }
        return tips;
    }

    private void activateRiskCheck() {
        IDataModel model = this.getModel();
        Set orgSet = ((MulBasedataDynamicObjectCollection)model.getValue(ORG)).stream().map(dynamicObject -> dynamicObject.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
        Object analysisPeriodId = model.getValue(ANALYSISPERIOD) == null ? null : ((DynamicObject)model.getValue(ANALYSISPERIOD)).getPkValue();
        Object periodId = model.getValue(PERIOD) == null ? null : ((DynamicObject)model.getValue(PERIOD)).getPkValue();
        Set riskItems = this.getPageCache().get("riskItemId") == null ? null : (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("riskItemId"), Set.class);
        boolean isRisk = "0".equals(model.getValue(SCANOBJECT).toString());
        Map riskMap = null;
        if (isRisk) {
            Map map = riskMap = this.getPageCache().get("riskMap") == null ? null : (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("riskMap"));
        }
        if (riskItems != null && !riskItems.isEmpty()) {
            List riskCalculateDTOS = RiskCheckHelper.buildCalculateDTOs((Object[])riskItems.toArray(), (Object[])orgSet.toArray(), (Object)periodId, (Object)analysisPeriodId, (Map)riskMap);
            if (riskCalculateDTOS.isEmpty()) {
                StringBuilder tipSb = new StringBuilder();
                QFilter qFilter = new QFilter("id", "in", (Object)riskItems);
                Map riskItemsMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_riskitem", (QFilter[])new QFilter[]{qFilter});
                for (DynamicObject value : riskItemsMap.values()) {
                    tipSb.append(value.getString("number")).append(",");
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u65e0\u6cd5\u4f7f\u7528\u6240\u9009\u68c0\u67e5\u9879\uff08%s\uff09\u5173\u8054\u7684\u6307\u6807\uff0c\u8bf7\u524d\u5f80\u6307\u6807\u5217\u8868\u7ef4\u62a4\u6307\u6807\u6570\u636e\u3002", (String)"RSARiskCheckFormPlugin_15", (String)"data-rsa-formplugin", (Object[])new Object[0]), tipSb.substring(0, tipSb.length() - 1)));
                return;
            }
            String taskKey = String.valueOf(DBServiceHelper.genGlobalLongId());
            this.getPageCache().put(CACHE_TASKKEY, taskKey);
            model.setValue("successcount", (Object)0);
            model.setValue("riskitemcount", (Object)riskCalculateDTOS.size());
            RSALazyCalculateTask task = new RSALazyCalculateTask(taskKey, riskCalculateDTOS, 1);
            ThreadPools.executeOnce((String)"RSARiskCheckFormPlugin", (Runnable)task);
            this.startProgressBar();
            this.setVisible(true);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u98ce\u9669\u68c0\u67e5\u9879\u3002", (String)"RSARiskCheckFormPlugin_7", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("activate_riskCheck".equals(callBackId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            this.activateRiskCheck();
        } else if ("activatecheck".equals(callBackId) && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            this.repetitiveExecution();
        }
    }

    private void startProgressBar() {
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressBar.setPercent(0);
        progressBar.start();
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        Object source = event.getSource();
        if (source instanceof MulBasedataEdit) {
            if (ORG.equals(((MulBasedataEdit)source).getKey())) {
                this.checkAvailableRiskItem();
            }
        } else if (source instanceof BasedataEdit && PERIODTYPE.equals(((BasedataEdit)source).getKey())) {
            this.getModel().setValue(PERIOD, null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (key) {
            case "org": {
                model.setValue(RISKCHECKITEM, null);
                model.setValue(RISK, null);
                model.setValue(RISKID_TAG, null);
                break;
            }
            case "timetype": {
                HashMap mustMap = new HashMap();
                HashMap notMustMap = new HashMap();
                HashMap<String, Boolean> mustInput = new HashMap<String, Boolean>();
                HashMap<String, Boolean> noMustInput = new HashMap<String, Boolean>();
                mustInput.put("mi", true);
                noMustInput.put("mi", false);
                mustMap.put("item", mustInput);
                notMustMap.put("item", noMustInput);
                if (this.getModel().getValue(TIMETYPE) == null) break;
                String timeType = this.getModel().getValue(TIMETYPE).toString();
                if (timeType.contains(BD_PERIOD) && timeType.contains(PA_ANALYSISPERIOD)) {
                    view.updateControlMetadata(PERIODTYPE, mustMap);
                    view.updateControlMetadata(PERIOD, mustMap);
                    view.updateControlMetadata(ANALYSISPERIOD, mustMap);
                    break;
                }
                if (timeType.contains(BD_PERIOD)) {
                    view.updateControlMetadata(PERIODTYPE, mustMap);
                    view.updateControlMetadata(PERIOD, mustMap);
                    view.updateControlMetadata(ANALYSISPERIOD, notMustMap);
                    model.setValue(ANALYSISPERIOD, null);
                    break;
                }
                if (!timeType.contains(PA_ANALYSISPERIOD)) break;
                view.updateControlMetadata(PERIODTYPE, notMustMap);
                view.updateControlMetadata(PERIOD, notMustMap);
                view.updateControlMetadata(ANALYSISPERIOD, mustMap);
                model.setValue(PERIOD, null);
                break;
            }
            case "scanobject": {
                String scanObject = this.getModel().getValue(SCANOBJECT).toString();
                if ("1".equals(scanObject)) {
                    model.setValue(RISK, null);
                    model.setValue(RISKID_TAG, null);
                    break;
                }
                model.setValue(RISKCHECKITEM, null);
                break;
            }
            case "risk": {
                ChangeData changeData = e.getChangeSet()[0];
                if (changeData.getNewValue() != null && !StringUtils.isEmpty((CharSequence)changeData.getNewValue().toString())) break;
                model.setValue(RISKID_TAG, (Object)"");
                model.setValue("riskid", (Object)"");
                break;
            }
        }
    }

    private Set<Object> checkAvailableRiskItem() {
        IDataModel model = this.getModel();
        Object org = model.getValue(ORG);
        if (org == null || ((MulBasedataDynamicObjectCollection)org).isEmpty()) {
            return Collections.emptySet();
        }
        Set orgList = ((MulBasedataDynamicObjectCollection)org).stream().map(dynamicObject -> dynamicObject.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
        Set entityIdRetainSet = null;
        entityIdRetainSet = RiskCheckHelper.checkAvailableRiskItem(orgList);
        if (entityIdRetainSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u98ce\u9669\u68c0\u67e5\u9879\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RSARiskCheckFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        return entityIdRetainSet;
    }

    private Set<Object> checkAvailableRisk() {
        IDataModel model = this.getModel();
        Object org = model.getValue(ORG);
        if (org == null || ((MulBasedataDynamicObjectCollection)org).isEmpty()) {
            return Collections.emptySet();
        }
        Set orgList = ((MulBasedataDynamicObjectCollection)org).stream().map(dynamicObject -> dynamicObject.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
        List riskIdRetainList = RiskCheckHelper.checkAvailableRisk(orgList);
        if (riskIdRetainList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7ec4\u7ec7\u4e0b\u6ca1\u6709\u53ef\u7528\u7684\u98ce\u9669\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RSARiskCheckFormPlugin_34", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        return new HashSet<Object>(riskIdRetainList);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key;
        IDataModel model = this.getModel();
        switch (key = ((BasedataEdit)event.getSource()).getKey()) {
            case "riskcheckitem": {
                Object org = model.getValue(ORG);
                if (org == null || ((MulBasedataDynamicObjectCollection)org).isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ec4\u7ec7\u201d\u3002", (String)"RSARiskCheckFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    model.setValue(ORG, null);
                    event.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                Set<Object> riskItemIds = this.checkAvailableRiskItem();
                if (CollectionUtils.isEmpty(riskItemIds)) {
                    event.setCancel(true);
                    return;
                }
                QFilter riskQFilter = new QFilter("id", "in", riskItemIds);
                event.addCustomQFilter(riskQFilter);
                break;
            }
            case "period": {
                if (model.getValue(TIMETYPE) == null || !model.getValue(TIMETYPE).toString().contains(BD_PERIOD)) break;
                Object value = model.getValue(PERIODTYPE);
                if (value == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u201d\u3002", (String)"RSARiskCheckFormPlugin_5", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    model.setValue(PERIODTYPE, null);
                    event.setCancel(true);
                    break;
                }
                QFilter qFilter = new QFilter(PERIODTYPE, "=", (Object)((DynamicObject)value).getLong("id"));
                event.addCustomQFilter(qFilter);
                break;
            }
            case "org": {
                List permOrgSet = OrgHelper.getPermOrgList((String)"rsa_riskcheck", (String)"2P7PKT+JSJPW");
                event.addCustomQFilter(new QFilter("id", "in", (Object)permOrgSet));
                break;
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String taskKey = this.getPageCache().get(CACHE_TASKKEY);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        IDataModel model = this.getModel();
        String errorMessage = (String)this.cache.get("prefix_rsa_cache_error" + taskKey, String.class);
        Integer riskCount = (Integer)this.cache.get("prefix_rsa_cache" + taskKey, Integer.class);
        Integer failRiskCount = (Integer)this.cache.get("prefix_rsa_cache_fail" + taskKey, Integer.class);
        if (riskCount == null) {
            riskCount = 0;
        }
        if (failRiskCount == null) {
            failRiskCount = 0;
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            this.getView().showTipNotification(errorMessage);
            this.changeImage("imageap", staticUrl);
            progressBar.stop();
            model.setValue("successcount", (Object)riskCount);
            this.getView().setVisible(Boolean.TRUE, new String[]{BUTTON_BACK1, ERRORMESSAGE});
            model.setValue(ERRORMESSAGE, (Object)ResManager.loadKDString((String)"\u98ce\u9669\u68c0\u67e5\u9879\u6267\u884c\u5f02\u5e38\u3002", (String)"RSARiskCheckFormPlugin_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            this.getView().updateView("progresstext");
            return;
        }
        int totalRiskCount = 0;
        if (this.cache.get("prefix_rsa_riskitem_count" + taskKey, Integer.class) != null) {
            totalRiskCount = (Integer)this.cache.get("prefix_rsa_riskitem_count" + taskKey, Integer.class);
        }
        model.setValue("riskitemcount", (Object)totalRiskCount);
        model.setValue("totalriskitemtext", (Object)totalRiskCount);
        model.setValue("successcount", (Object)riskCount);
        int percent = (int)((double)(riskCount + failRiskCount) / (double)totalRiskCount * 100.0);
        if (percent == 100) {
            String statisticDtoString = (String)this.cache.get("prefix_rsa_statistics_cache" + taskKey, String.class);
            if (StringUtils.isEmpty((CharSequence)statisticDtoString)) {
                progressEvent.setProgress((int)((double)(riskCount + failRiskCount - 1) / (double)totalRiskCount * 100.0));
                return;
            }
            this.changeImage("imageap", staticUrl);
            progressBar.stop();
            this.showEndView(riskCount, statisticDtoString);
            this.getView().setVisible(Boolean.TRUE, new String[]{"detailinfo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"corecontentap"});
        }
        progressEvent.setProgress(percent);
    }

    public void showEndView(Integer riskItemCount, String statisticDtoString) {
        Map riskCountMap;
        RiskCheckStatisticsDTO dto = null;
        if (StringUtils.isNotEmpty((CharSequence)statisticDtoString)) {
            try {
                dto = (RiskCheckStatisticsDTO)JSONUtils.cast((String)statisticDtoString, RiskCheckStatisticsDTO.class);
            }
            catch (IOException e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u7edf\u8ba1\u7c7b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RSARiskCheckFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Set orgSet = ((MulBasedataDynamicObjectCollection)model.getValue(ORG)).stream().map(dynamicObject -> dynamicObject.getLong(FBASEDATAID_ID)).collect(Collectors.toSet());
        Object periodId = model.getValue(PERIOD) == null ? null : ((DynamicObject)model.getValue(PERIOD)).getPkValue();
        Object analysisPeriod = model.getValue(ANALYSISPERIOD) == null ? null : ((DynamicObject)model.getValue(ANALYSISPERIOD)).getPkValue();
        String timeType = model.getValue(TIMETYPE).toString();
        String[] timeTypeSplit = timeType.substring(1, timeType.length() - 1).split(",");
        model.beginInit();
        StringBuilder periodTextSb = new StringBuilder();
        if (model.getValue(ANALYSISPERIOD) != null) {
            periodTextSb.append(((DynamicObject)model.getValue(ANALYSISPERIOD)).getString("name")).append("\u3001");
        }
        if (model.getValue(PERIOD) != null) {
            periodTextSb.append(((DynamicObject)model.getValue(PERIOD)).getString("name"));
        }
        int riskCountTotal = StringUtils.isEmpty((CharSequence)this.getPageCache().get("riskcount")) ? 0 : Integer.parseInt(this.getPageCache().get("riskcount"));
        Map noItemRiskMap = null;
        try {
            noItemRiskMap = this.getPageCache().get("noItemRiskMap") == null ? null : (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("noItemRiskMap"));
            this.getPageCache().remove("noItemRiskMap");
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e8f\u5217\u5316\u7edf\u8ba1\u7c7b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RSARiskCheckFormPlugin_6", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        model.setValue("periodtext", (Object)periodTextSb.toString());
        model.setValue("riskitemtext", (Object)riskItemCount);
        model.setValue("failriskitemtext", dto == null ? null : Integer.valueOf(dto.getFailRiskItemCount()));
        model.setValue("totalriskcount", (Object)(dto == null ? null : Integer.valueOf(riskCountTotal)));
        model.setValue("risksuccess", dto == null ? null : Integer.valueOf(riskCountTotal - dto.getErrorRiskCount()));
        model.setValue("riskerror", dto == null ? null : Integer.valueOf(dto.getErrorRiskCount()));
        model.deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(ORGENTRY, new Object[0]);
        vs.addField(PERIODENTRY, new Object[0]);
        vs.addField(ANALPERIODENTRY, new Object[0]);
        vs.addField("status", new Object[0]);
        vs.addField("riskentry", new Object[0]);
        vs.addField("riskitementry", new Object[0]);
        vs.addField("riskevent", new Object[0]);
        vs.addField("timetypeentry", new Object[0]);
        for (Object orgId : orgSet) {
            if (dto == null) continue;
            for (String type : timeTypeSplit) {
                int riskCount;
                int riskItemEntryCount;
                int riskEventCount;
                int n = riskEventCount = dto.getRiskEventCountMap().get(orgId + "-" + type) == null ? 0 : ((Set)dto.getRiskEventCountMap().get(orgId + "-" + type)).size();
                if (dto.getRiskItemCountMap().get(orgId + "-" + type) != null || dto.getRiskCountMap().get(orgId + "-" + type) != null) {
                    riskItemEntryCount = dto.getRiskItemCountMap().get(orgId + "-" + type) == null ? 0 : ((Set)dto.getRiskItemCountMap().get(orgId + "-" + type)).size();
                    riskCount = dto.getRiskCountMap().get(orgId + "-" + type) == null ? 0 : ((Set)dto.getRiskCountMap().get(orgId + "-" + type)).size();
                    vs.addRow(new Object[]{orgId, type.equals(TimeTypeEnum.BD_PERIOD.getCode()) ? periodId : Long.valueOf(0L), type.equals(TimeTypeEnum.PA_ANALYSISPERIOD.getCode()) ? analysisPeriod : Long.valueOf(0L), "0", riskCount, riskItemEntryCount, riskEventCount, type});
                }
                if (dto.getErrorRiskItemMap().get(orgId + "-" + type) == null && dto.getErrorRiskMap().get(orgId + "-" + type) == null) continue;
                riskItemEntryCount = dto.getErrorRiskItemMap().get(orgId + "-" + type) == null ? 0 : ((Set)dto.getErrorRiskItemMap().get(orgId + "-" + type)).size();
                riskCount = dto.getErrorRiskMap().get(orgId + "-" + type) == null ? 0 : ((Set)dto.getErrorRiskMap().get(orgId + "-" + type)).size();
                vs.addRow(new Object[]{orgId, type.equals(TimeTypeEnum.BD_PERIOD.getCode()) ? periodId : Long.valueOf(0L), type.equals(TimeTypeEnum.PA_ANALYSISPERIOD.getCode()) ? analysisPeriod : Long.valueOf(0L), "1", riskCount, riskItemEntryCount, 0, type});
            }
        }
        Map map = riskCountMap = dto == null ? new HashMap(10) : dto.getRiskCountMap();
        if (noItemRiskMap != null && !noItemRiskMap.isEmpty()) {
            for (Map.Entry entry : noItemRiskMap.entrySet()) {
                vs.addRow(new Object[]{entry.getValue(), 0L, 0L, "0", 1, 0, 0, ""});
                riskCountMap.put(entry.getValue() + "-", new HashSet(Collections.singletonList(entry.getKey())));
            }
        }
        if (dto != null) {
            try {
                this.getPageCache().put("riskItem", JSONUtils.toString((Object)dto.getRiskItemCountMap()));
                this.getPageCache().put("riskEvent", JSONUtils.toString((Object)dto.getRiskEventCountMap()));
                this.getPageCache().put("riskExeLog", JSONUtils.toString((Object)dto.getExeLogIds()));
                this.getPageCache().put("riskEntryId", JSONUtils.toString(riskCountMap));
                this.getPageCache().put("errorRiskItem", JSONUtils.toString((Object)dto.getErrorRiskItemMap()));
                this.getPageCache().put("errorRisk", JSONUtils.toString((Object)dto.getErrorRiskMap()));
            }
            catch (IOException e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e8f\u5217\u5316\u7edf\u8ba1\u7c7b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RSARiskCheckFormPlugin_6", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("detailinfo");
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        int row = cellClickEvent.getRow();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (row < 0 || model.getValue("timetypeentry", row) == null) {
            return;
        }
        String timeType = model.getValue("timetypeentry", row).toString();
        String status = model.getValue("status", row).toString();
        switch (cellClickEvent.getFieldKey()) {
            case "riskitementry": {
                String riskItem;
                String string = riskItem = "0".equals(status) ? this.getPageCache().get("riskItem") : this.getPageCache().get("errorRiskItem");
                if (!StringUtils.isNotEmpty((CharSequence)riskItem)) break;
                ListShowParameter lsp = new ListShowParameter();
                String orgId = ((DynamicObject)model.getValue(ORGENTRY, row)).getString("id");
                try {
                    Map riskItemMap = (Map)JSON.parseObject((String)riskItem, (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0]);
                    Set riskItemIds = (Set)riskItemMap.get(orgId + "-" + timeType);
                    if (riskItemIds == null || riskItemIds.isEmpty()) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"RSARiskCheckFormPlugin_33", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
                    riskItemIds.forEach(arg_0 -> ((LinkQueryPkIdCollection)linkQueryPkIdCollection).addLinkQueryPkId(arg_0));
                    lsp.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
                }
                catch (Exception e) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u7edf\u8ba1\u7c7b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RSARiskCheckFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                lsp.setCustomParam("orgId", (Object)orgId);
                lsp.setBillFormId("rsa_riskitem");
                lsp.setFormId("bos_templatetreelist");
                lsp.setFilterSchemeId("0");
                lsp.setCustomParam(RISKCHECKFORM, (Object)RISKCHECKFORM);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm((FormShowParameter)lsp);
                break;
            }
            case "riskevent": {
                String riskEventJson = this.getPageCache().get("riskEvent");
                if (!StringUtils.isNotEmpty((CharSequence)riskEventJson)) break;
                ListShowParameter lsp = new ListShowParameter();
                String orgId = ((DynamicObject)model.getValue(ORGENTRY, row)).getString("id");
                try {
                    Map riskEventMap = (Map)JSON.parseObject((String)riskEventJson, (TypeReference)new TypeReference<Map<String, Set<Long>>>(){}, (Feature[])new Feature[0]);
                    Set riskEventIds = (Set)riskEventMap.get(orgId + "-" + timeType);
                    if (riskEventIds == null || riskEventIds.isEmpty()) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"RSARiskCheckFormPlugin_33", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
                    riskEventIds.forEach(arg_0 -> ((LinkQueryPkIdCollection)linkQueryPkIdCollection).addLinkQueryPkId(arg_0));
                    lsp.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
                }
                catch (Exception e) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u7edf\u8ba1\u7c7b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RSARiskCheckFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                lsp.setCustomParam("orgId", (Object)orgId);
                lsp.setBillFormId("rsa_riskevent");
                lsp.setCustomParam(TIMETYPE, (Object)timeType);
                lsp.setFilterSchemeId("0");
                lsp.setFormId("bos_list");
                lsp.setCustomParam(RISKCHECKFORM, (Object)RISKCHECKFORM);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm((FormShowParameter)lsp);
                break;
            }
            case "riskentry": {
                String riskJson;
                String string = riskJson = "0".equals(status) ? this.getPageCache().get("riskEntryId") : this.getPageCache().get("errorRisk");
                if (!StringUtils.isNotEmpty((CharSequence)riskJson)) break;
                ListShowParameter lsp = new ListShowParameter();
                Long orgId = ((DynamicObject)model.getValue(ORGENTRY, row)).getLong("id");
                try {
                    Map riskMap = (Map)JSON.parseObject((String)riskJson, (TypeReference)new TypeReference<Map<String, List<Long>>>(){}, (Feature[])new Feature[0]);
                    List riskIds = (List)riskMap.get(orgId + "-" + timeType);
                    if (riskIds == null || riskIds.isEmpty()) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"RSARiskCheckFormPlugin_33", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
                    riskIds.forEach(arg_0 -> ((LinkQueryPkIdCollection)linkQueryPkIdCollection).addLinkQueryPkId(arg_0));
                    lsp.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
                }
                catch (Exception e) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53cd\u5e8f\u5217\u5316\u7edf\u8ba1\u7c7b\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RSARiskCheckFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                lsp.setBillFormId("rsa_risk");
                lsp.setFilterSchemeId("0");
                lsp.setFormId("bos_templatetreelist");
                lsp.setCustomParam(RISKCHECKFORM, (Object)RISKCHECKFORM);
                lsp.setCustomParam("orgid", (Object)orgId.toString());
                lsp.setShowFilter(false);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                lsp.setCaption(ResManager.loadKDString((String)"\u98ce\u9669\u5217\u8868", (String)"RSARiskCheckFormPlugin_25", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                view.showForm((FormShowParameter)lsp);
                break;
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private boolean paramValidate() {
        Object period;
        String timeType;
        boolean result = true;
        IDataModel model = this.getModel();
        Object org = model.getValue(ORG);
        StringBuilder tipSb = new StringBuilder();
        if (org == null || ((MulBasedataDynamicObjectCollection)org).isEmpty()) {
            tipSb.append(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RSARiskCheckFormPlugin_8", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            result = false;
            model.setValue(ORG, null);
        }
        String string = timeType = model.getValue(TIMETYPE) == null ? " " : model.getValue(TIMETYPE).toString();
        if (timeType.contains(BD_PERIOD)) {
            Object period2;
            Object periodType = model.getValue(PERIODTYPE);
            if (periodType == null) {
                if (tipSb.length() > 0) {
                    tipSb.append("\n\r");
                }
                tipSb.append(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u7c7b\u578b\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RSARiskCheckFormPlugin_9", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                result = false;
                model.setValue(PERIODTYPE, null);
            }
            if ((period2 = model.getValue(PERIOD)) == null) {
                if (tipSb.length() > 0) {
                    tipSb.append("\n\r");
                }
                tipSb.append(ResManager.loadKDString((String)"\u6240\u9009\u4f1a\u8ba1\u671f\u95f4\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RSARiskCheckFormPlugin_23", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                result = false;
                model.setValue(PERIOD, null);
            }
        }
        if (timeType.contains(PA_ANALYSISPERIOD) && (period = model.getValue(ANALYSISPERIOD)) == null) {
            if (tipSb.length() > 0) {
                tipSb.append("\n\r");
            }
            tipSb.append(ResManager.loadKDString((String)"\u6240\u9009\u671f\u95f4\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RSARiskCheckFormPlugin_10", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            result = false;
            model.setValue(ANALYSISPERIOD, null);
        }
        if (!result) {
            this.getView().showTipNotification(tipSb.toString());
        }
        return result;
    }

    private boolean checkPeriodMatch() {
        IDataModel model = this.getModel();
        Object scanObject = model.getValue(SCANOBJECT);
        String timeTypeString = model.getValue(TIMETYPE).toString();
        String[] timeTypes = timeTypeString.substring(1, timeTypeString.length() - 1).split(",");
        if (timeTypes.length == 2) {
            return true;
        }
        boolean noChoseCheckTag = false;
        String timeType = timeTypes[0];
        Map<Long, List> riskItemMap = null;
        if ("1".equals(scanObject)) {
            Object riskCheckItem = model.getValue(RISKCHECKITEM);
            if (riskCheckItem != null && !((MulBasedataDynamicObjectCollection)riskCheckItem).isEmpty()) {
                riskItemMap = ((MulBasedataDynamicObjectCollection)riskCheckItem).stream().collect(Collectors.toMap(x -> x.getLong(FBASEDATAID_ID), x -> x.get("fbasedataid.defaultdimension") == null ? null : ((MulBasedataDynamicObjectCollection)x.get("fbasedataid.defaultdimension")).stream().map(y -> y.getLong(FBASEDATAID_ID)).collect(Collectors.toList())));
            } else {
                noChoseCheckTag = true;
                Set<Object> objects = this.checkAvailableRiskItem();
                if (!objects.isEmpty()) {
                    Map riskItemMaps = BusinessDataServiceHelper.loadFromCache((Object[])objects.toArray(), (String)"rsa_riskitem");
                    riskItemMap = riskItemMaps.values().stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.get("defaultdimension") == null ? null : ((MulBasedataDynamicObjectCollection)x.get("defaultdimension")).stream().map(y -> y.getLong(FBASEDATAID_ID)).collect(Collectors.toList())));
                }
            }
        } else if ("0".equals(scanObject)) {
            Map riskDynMap;
            Object riskItems;
            Set<Object> riskIdSet;
            String riskIds = (String)model.getValue(RISKID_TAG);
            if (StringUtils.isNotEmpty((CharSequence)riskIds)) {
                riskIdSet = (Set)SerializationUtils.deSerializeFromBase64((String)riskIds);
            } else {
                noChoseCheckTag = true;
                riskIdSet = this.checkAvailableRisk();
            }
            if (!riskIdSet.isEmpty() && !(riskItems = (riskDynMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risk", (String)"riskitem", (QFilter[])new QFilter[]{new QFilter("id", "in", riskIdSet)})).values().stream().flatMap(x -> {
                MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)x.get("riskitem");
                return collection.stream();
            }).collect(Collectors.toSet())).isEmpty()) {
                riskItemMap = riskItems.stream().collect(Collectors.toMap(x -> x.getLong(FBASEDATAID_ID), x -> x.get("fbasedataid.defaultdimension") == null ? null : ((MulBasedataDynamicObjectCollection)x.get("fbasedataid.defaultdimension")).stream().map(y -> y.getLong(FBASEDATAID_ID)).collect(Collectors.toList()), (o1, o2) -> o1));
            }
        }
        HashSet dimensionIds = new HashSet();
        if (riskItemMap == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6267\u884c\u7684\u98ce\u9669\u68c0\u67e5\u9879\u3002", (String)"RSARiskCheckFormPlugin_7", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (List value : riskItemMap.values()) {
            dimensionIds.addAll(value);
        }
        List timeTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"pa_dimension", (QFilter[])new QFilter[]{new QFilter("id", "in", dimensionIds), new QFilter("dimensionsource", "=", (Object)timeType).or("dimensiontype", "=", (Object)"5")}, null, (int)-1);
        HashSet notMatchItemIds = new HashSet(10);
        for (Map.Entry entry : riskItemMap.entrySet()) {
            List value = (List)entry.getValue();
            if (!timeTypeIds.stream().noneMatch(value::contains)) continue;
            notMatchItemIds.add(entry.getKey());
        }
        if (!notMatchItemIds.isEmpty()) {
            if (noChoseCheckTag && riskItemMap.size() > notMatchItemIds.size()) {
                this.getPageCache().put("nomatchitem", SerializationUtils.toJsonString(notMatchItemIds));
                return true;
            }
            List riskItemNames = QueryServiceHelper.query((String)"rsa_riskitem", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", notMatchItemIds)}).stream().map(x -> x.getString("name")).collect(Collectors.toList());
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u98ce\u9669\u68c0\u67e5\u9879\uff1a%1$s \u9700\u8981\u9009\u62e9 %2$s \u8fdb\u884c\u626b\u63cf\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6267\u884c\u7684\u671f\u95f4\u7c7b\u578b\u3002", (String)"RSARiskCheckFormPlugin_24", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", riskItemNames), timeType.equals("bd_period") ? ResManager.loadKDString((String)"\u5206\u6790\u671f\u95f4", (String)"RSARiskCheckFormPlugin_26", (String)"data-rsa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4", (String)"RSARiskCheckFormPlugin_27", (String)"data-rsa-formplugin", (Object[])new Object[0])));
            return false;
        }
        return true;
    }
}

