/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.utils.DbTypeConverter;

public class BillTreeListPlugin
extends StandardTreeListPlugin {
    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        try {
            String nodeId = e.getNodeId() == null ? null : e.getNodeId().toString();
            TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(nodeId);
            Object source = e.getSource();
            if (source instanceof TreeView && "treeview".equals(((TreeView)source).getKey())) {
                this.refreshTreeNode(treeNode);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    protected void refreshTreeNode(TreeNode currentNode) {
        String groupBaseDataFormId = this.getGroupBaseDataFormId();
        if (groupBaseDataFormId == null) {
            return;
        }
        String currentId = null;
        if (currentNode != null) {
            currentId = currentNode.getId();
        }
        ITreeModel treeModel = this.getTreeModel();
        String rootId = treeModel.getRoot().getId();
        TreeView tree = (TreeView)this.getControl("treeview");
        tree.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", rootId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"BillTreeListPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]), true);
        rootNode.setIsOpened(true);
        DynamicObjectCollection channels = QueryServiceHelper.query((String)groupBaseDataFormId, (String)"id,name,parent.id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        Map<String, List<DynamicObject>> collect = channels.stream().collect(Collectors.groupingBy(it -> it.getString("parent.id")));
        List<DynamicObject> rootList = collect.get("0");
        if (rootList != null) {
            for (DynamicObject type : rootList) {
                String groupId = type.getString("id");
                TreeNode tn1 = new TreeNode(rootId, groupId, type.getString("name"), false);
                if (groupId.equals(currentId)) {
                    tn1.setIsOpened(true);
                }
                rootNode.addChild(tn1);
                this.riskGroup(tn1, groupId, collect, currentId);
            }
        }
        this.getTreeModel().setRoot(rootNode);
        tree.addNode(rootNode);
        if (currentNode == null) {
            this.treeListView.getTreeView().focusNode(rootNode);
        } else {
            this.treeListView.getTreeView().focusNode(currentNode);
        }
    }

    private String getGroupBaseDataFormId() {
        String billFormId;
        MainEntityType entityType;
        IDataEntityProperty property;
        String groupBaseDataFormId = this.getPageCache().get("groupFormId");
        if (StringUtils.isEmpty((CharSequence)groupBaseDataFormId) && (property = (entityType = EntityMetadataCache.getDataEntityType((String)(billFormId = ((ListView)this.getView()).getBillFormId()))).findProperty("group")) instanceof BasedataProp) {
            groupBaseDataFormId = ((BasedataProp)property).getBaseEntityId();
            this.getPageCache().put("groupFormId", groupBaseDataFormId);
        }
        return groupBaseDataFormId;
    }

    protected void riskGroup(TreeNode treeNode, String groupId, Map<String, List<DynamicObject>> collect, String currentId) {
        List<DynamicObject> nextGroup = collect.get(groupId);
        if (nextGroup != null && !nextGroup.isEmpty()) {
            for (DynamicObject dyn : nextGroup) {
                String nextGroupId = dyn.getString("id");
                TreeNode tn2 = new TreeNode(groupId, nextGroupId, dyn.getString("name"), false);
                if (nextGroupId.equals(currentId)) {
                    tn2.setIsOpened(true);
                }
                treeNode.addChild(tn2);
                this.riskGroup(tn2, nextGroupId, collect, currentId);
            }
        }
    }

    public void treeToolbarClick(EventObject e) {
        Control ctl = (Control)e.getSource();
        ITreeModel treeModel = this.getTreeModel();
        String entityId = this.getPageCache().get("groupFormId");
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        if (ctl.getKey().equals("btnnew")) {
            this.addGroupNode(entityId, currentNodeId);
        } else if (ctl.getKey().equals("btnedit")) {
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u6839\u8282\u70b9", (String)"BillTreeListPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9", (String)"BillTreeListPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            Long id = Long.valueOf(currentNodeId);
            Map checkResult = checker.checkRef((BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityId), new Object[]{id});
            BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)checkResult.get(id);
            BillShowParameter formShowParameter = this.createFormShowParameter(entityId, currentNodeId, "group_bar_edit");
            formShowParameter.setPkId(this.getTreeModel().getCurrentNodeId());
            boolean hasRef = refrenceResult != null && refrenceResult.isRefence();
            formShowParameter.setStatus(hasRef ? OperationStatus.VIEW : OperationStatus.EDIT);
            formShowParameter.setCustomParam("operate", (Object)(hasRef ? "view" : "edit"));
            HashMap<String, String> parentInfo = new HashMap<String, String>();
            parentInfo.put("value", currentNodeId);
            formShowParameter.setCustomParam("tree_curr_id", parentInfo);
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if (ctl.getKey().equals("btndel")) {
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9", (String)"BillTreeListPlugin_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)currentNodeId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5206\u7ec4\u8282\u70b9", (String)"BillTreeListPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
            if (currentNode == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"BillTreeListPlugin_4", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            String text = currentNode.getText();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("group_bar_del", (IFormPlugin)this);
            String strs = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u5206\u7ec4\"%s\"\uff1f", (String)"BillTreeListPlugin_5", (String)"data-rsa-formplugin", (Object[])new Object[0]), text);
            this.getView().showConfirm(strs, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
        }
    }

    private void addGroupNode(String entityId, String currentNodeId) {
        BasedataEntityType basedataEntityType;
        BillShowParameter formShowParameter = this.createFormShowParameter(entityId, currentNodeId, "group_bar_add");
        formShowParameter.setCustomParam("operate", (Object)"addnew");
        if (!currentNodeId.equals(this.getTreeModel().getRoot().getId()) && (basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityId)) != null) {
            HashMap<String, String> parentInfo = new HashMap<String, String>();
            for (IDataEntityProperty pro : basedataEntityType.getProperties()) {
                if (!(pro instanceof ParentBasedataProp)) continue;
                parentInfo.put("key", pro.getName());
                parentInfo.put("value", currentNodeId);
                formShowParameter.setCustomParam("tree_parent_id", parentInfo);
                break;
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    protected BillShowParameter createFormShowParameter(String entityId, String currentNodeId, String actionId) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId(entityId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("table", (Object)"");
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, actionId);
        formShowParameter.setCloseCallBack(callBack);
        formShowParameter.setCustomParam("id", (Object)currentNodeId);
        return formShowParameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("group_bar_add".equals(closedCallBackEvent.getActionId()) || "group_bar_edit".equals(closedCallBackEvent.getActionId()) || "newcallback".equals(closedCallBackEvent.getActionId())) {
            Object value = closedCallBackEvent.getReturnData();
            if (value != null) {
                if (!(value instanceof Map)) {
                    String currentNodeId = value.toString();
                    TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
                    this.refreshTreeNode(treeNode);
                    BillList billList = (BillList)this.getView().getControl("billlistap");
                    billList.refresh();
                    return;
                }
                String currentNodeId = (String)((Map)value).get("currentNode");
                TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId);
                this.refreshTreeNode(treeNode);
                BillList billList = (BillList)this.getView().getControl("billlistap");
                billList.refresh();
            } else {
                ITreeModel treeModel = this.getTreeModel();
                this.refreshTreeNode(treeModel.getRoot());
                BillList billList = (BillList)this.getView().getControl("billlistap");
                billList.refresh();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)this.getPageCache().get("groupFormId"));
        if (event.getResult() == MessageBoxResult.Yes && "group_bar_del".equals(event.getCallBackId())) {
            String nodeId = (String)this.getTreeModel().getCurrentNodeId();
            ArrayList list = new ArrayList();
            DynamicObjectCollection collection = this.getChildrenDynamicObject(new Object[]{nodeId}, entityType);
            if (collection != null && !collection.isEmpty()) {
                collection.forEach(c -> list.add(c.getPkValue()));
            }
            if (list.size() > 1) {
                TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(nodeId);
                String text = currentNode.getText();
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u63d0\u793a", (String)"BillTreeListPlugin_6", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5206\u7ec4%s\u5b58\u5728\u4e0b\u7ea7\u5206\u7ec4\uff0c\u6b64\u6b21\u5220\u9664\u5c06\u5220\u9664\u5206\u7ec4\u53ca\u6240\u6709\u4e0b\u7ea7\u5206\u7ec4,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BillTreeListPlugin_7", (String)"data-rsa-formplugin", (Object[])new Object[0]), text), MessageBoxOptions.YesNo, (ConfirmTypes)null, new ConfirmCallBackListener("delbygroup", (IFormPlugin)this));
            } else {
                IOperationResult result = this.deleteGroup(new Object[]{nodeId});
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BillTreeListPlugin_8", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u5220\u9664", (String)"BillTreeListPlugin_9", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                }
                if (!result.getSuccessPkIds().isEmpty()) {
                    TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId);
                    this.getTreeModel().deleteNode(node, false);
                    TreeNode parentNode = this.getTreeModel().getRoot().getTreeNode(node.getParentid());
                    if (parentNode != null) {
                        this.updatePageCache(null);
                        this.treeListView.getTreeModel().refreshNode((Object)parentNode.getId());
                        this.refreshTreeNode(parentNode);
                        this.treeListView.getTreeView().treeNodeClick(parentNode.getParentid(), parentNode.getId());
                    }
                }
            }
        } else if ("delbyall".equals(event.getCallBackId())) {
            try (EntityTraceSpan span = EntityTracer.create((String)"plugin", (String)(((Object)((Object)this)).getClass().getName() + "delete"));){
                this.delete(event);
            }
        } else if ("disablebyall".equals(event.getCallBackId())) {
            try (EntityTraceSpan span = EntityTracer.create((String)"plugin", (String)(((Object)((Object)this)).getClass().getName() + "disable"));){
                this.disable(event);
            }
        } else if ("enablebyall".equals(event.getCallBackId())) {
            try (EntityTraceSpan span = EntityTracer.create((String)"plugin", (String)(((Object)((Object)this)).getClass().getName() + "enable"));){
                this.enable(event);
            }
        } else if (event.getResult() == MessageBoxResult.Yes && "delbygroup".equals(event.getCallBackId())) {
            String nodeId = (String)this.getTreeModel().getCurrentNodeId();
            ArrayList list = new ArrayList();
            DynamicObjectCollection collection = this.getChildrenDynamicObject(new Object[]{nodeId}, entityType);
            collection.forEach(c -> list.add(c.getPkValue()));
            if (list.size() > 0) {
                IOperationResult result = this.deleteGroup(list.toArray());
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"BillTreeListPlugin_8", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u5220\u9664", (String)"BillTreeListPlugin_9", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                }
                if (!result.getSuccessPkIds().isEmpty()) {
                    TreeNode node = this.getTreeModel().getRoot().getTreeNode(nodeId);
                    this.getTreeModel().deleteNode(node, false);
                    TreeNode parentNode = this.getTreeModel().getRoot().getTreeNode(node.getParentid());
                    if (parentNode != null) {
                        this.updatePageCache(null);
                        this.treeListView.getTreeModel().refreshNode((Object)parentNode.getId());
                        this.treeListView.refreshTreeNode(parentNode.getId());
                        this.treeListView.getTreeView().treeNodeClick(parentNode.getParentid(), parentNode.getId());
                    }
                }
            }
        }
    }

    private DynamicObjectCollection getChildrenDynamicObject(Object[] ids, BasedataEntityType entityType) {
        ORM orm = ORM.create();
        String number = entityType.getNumberProperty();
        if (entityType.getProperty("longnumber") == null) {
            return null;
        }
        String entityName = entityType.getName();
        String selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
        String orderBy = "longnumber desc";
        int dbType = entityType.getPrimaryKey().getDbType();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = DbTypeConverter.safeConvert((int)dbType, (Object)ids[i]);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        DynamicObjectCollection collection = orm.query(entityName, selectFields, filters, orderBy);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            if (dynamicObject.getString("longnumber") == null || "".equals(dynamicObject.getString("longnumber").trim())) continue;
            list.add(dynamicObject.getString("longnumber"));
        }
        selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
        ParentBasedataProp parentProp = null;
        DataEntityPropertyCollection props = entityType.getProperties();
        for (IDataEntityProperty prop : props) {
            if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
            parentProp = (ParentBasedataProp)prop;
            break;
        }
        String longNumberDLM = ".";
        if (parentProp != null) {
            longNumberDLM = parentProp.getLongNumberDLM();
        }
        QFilter baseQfilter = new QFilter("id", "in", (Object)ids);
        if (ids.length > 1000) {
            return collection;
        }
        for (int i = 0; i < list.size(); ++i) {
            baseQfilter.or(new QFilter("longnumber", "like", (Object)((String)list.get(i) + longNumberDLM + "%")));
        }
        return list.isEmpty() ? collection : orm.query(entityName, selectFields, new QFilter[]{baseQfilter}, orderBy);
    }

    private void updatePageCache(List<TreeNode> treeNodes) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String treeNodesString = null;
        if (treeNodes != null) {
            treeNodesString = SerializationUtils.toJsonString(treeNodes);
        }
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        pageCache.put(matchNodesCacheKey, treeNodesString);
        pageCache.put(searchNodesCacheKey, treeNodesString);
        pageCache.put(searchIndexCacheKey, String.valueOf(0));
    }

    public IOperationResult deleteGroup(Object[] nodeIds) {
        OperationResult var26;
        try (EntityTraceSpan span = EntityTracer.create((String)"list", (String)"TreeListModel.deleteGroup");){
            String entityNumber = this.getPageCache().get("groupFormId");
            List operateList = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
            String operationKey = "";
            for (Map map : operateList) {
                String type = (String)map.get("type");
                String key = (String)map.get("key");
                if (!"delete".equals(type) || !StringUtils.isNotBlank((CharSequence)key)) continue;
                operationKey = key;
                break;
            }
            if (!StringUtils.isNotBlank((CharSequence)operationKey)) {
                OperationResult var262;
                OperationResult result = new OperationResult();
                result.setSuccess(false);
                result.setMessage(String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u57fa\u7840\u8d44\u6599%s\u6ca1\u6709\u914d\u7f6e\u5220\u9664\u64cd\u4f5c\u3002", (String)"BillTreeListPlugin_10", (String)"data-rsa-formplugin", (Object[])new Object[0]), entityNumber));
                OperationResult operationResult = var262 = result;
                return operationResult;
            }
            var26 = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])nodeIds, (OperateOption)OperateOption.create());
        }
        return var26;
    }
}

