/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.data.rsa.enums.ScoreSumWayEnum;
import kd.data.rsa.helper.CodeRuleHelper;
import kd.data.rsa.helper.MessageSendHelper;
import kd.data.rsa.helper.RiskHelper;
import kd.data.rsa.helper.UserGroupHelper;
import kd.data.rsa.helper.UserHelper;

public class EvalWithSettingFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(EvalWithSettingFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "weightsetting"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"evalusergroup", (CharSequence)name)) {
            model.setValue("weightsetting", null);
            model.setValue("weightjson_tag", null);
            return;
        }
        if (StringUtils.equals((CharSequence)"evaluser", (CharSequence)name)) {
            String scoreSumWay = (String)model.getValue("scoresumway");
            if (!StringUtils.isEmpty((CharSequence)scoreSumWay) && StringUtils.equals((CharSequence)ScoreSumWayEnum.ORG_WEIGHT.getCode(), (CharSequence)scoreSumWay)) {
                return;
            }
            model.setValue("weightsetting", null);
            model.setValue("weightjson_tag", null);
            return;
        }
        if (StringUtils.equals((CharSequence)"scoresumway", (CharSequence)name)) {
            model.setValue("weightsetting", null);
            model.setValue("weightjson_tag", null);
            return;
        }
        if (StringUtils.equals((CharSequence)"weightsetting", (CharSequence)name) && StringUtils.isEmpty((CharSequence)(newValue = (String)e.getChangeSet()[0].getNewValue()))) {
            model.beginInit();
            model.setValue("weightjson_tag", null);
            model.endInit();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"weightsetting", (CharSequence)key)) {
            this.showWeightSetting();
            return;
        }
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            this.preSubmitEvalWith();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IFormView view = this.getView();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)"evalwithsubmit", (CharSequence)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            try {
                OperationResult operationResult = this.submitEvalWith();
                if (operationResult != null && operationResult.isSuccess()) {
                    List successPkIds = operationResult.getSuccessPkIds();
                    MessageSendHelper.sendEvalWithMessage((List)successPkIds);
                    view.returnDataToParent((Object)"submit");
                    view.close();
                } else {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002", (String)"EvalWithSettingFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    logger.error(String.format("[DATA-RSA] Evalwithsubmit failed!result:%s", JSON.toJSONString((Object)operationResult)));
                }
            }
            catch (KDBizException e) {
                view.showErrorNotification(e.getMessage());
                logger.error("[DATA-RSA] Evalwithsubmit operate error!", (Throwable)e);
            }
            catch (Exception e) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\u3002\u9519\u8bef\u4fe1\u606f:%s", (String)"EvalWithSettingFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]), e.getMessage()));
                logger.error("[DATA-RSA] Evalwithsubmit operate error!", (Throwable)e);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"weightsetting", (CharSequence)actionId)) {
            List weightMapList;
            String weightJson = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isEmpty((CharSequence)weightJson)) {
                model.setValue("weightsetting", null);
                model.setValue("weightjson_tag", null);
                logger.error("[DATA-RSA] ClosedCallBack weightJson isEmpty!");
                return;
            }
            try {
                weightMapList = (List)JSON.parseObject((String)weightJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                if (weightMapList.isEmpty()) {
                    model.setValue("weightsetting", null);
                    model.setValue("weightjson_tag", null);
                    logger.error("[DATA-RSA] ClosedCallBack weightMapList isEmpty!");
                    return;
                }
            }
            catch (Exception e) {
                model.setValue("weightsetting", null);
                model.setValue("weightjson_tag", null);
                logger.error("[DATA-RSA] ClosedCallBack weightMapList isEmpty!");
                return;
            }
            for (Map weightMap : weightMapList) {
                Object evalWeight = weightMap.get("evalWeight");
                if (evalWeight != null) continue;
                model.setValue("weightsetting", null);
                model.setValue("weightjson_tag", null);
                return;
            }
            model.setValue("weightsetting", (Object)ResManager.loadKDString((String)"\u5df2\u586b\u5199", (String)"EvalWithSettingFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            model.setValue("weightjson_tag", (Object)weightJson);
        }
    }

    private void init() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String riskJson = (String)view.getFormShowParameter().getCustomParam("riskjson");
        if (StringUtils.isEmpty((CharSequence)riskJson)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"EvalWithSettingFormPlugin_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            logger.error("[DATA-RSA] EvalWithSetting init error!");
            return;
        }
        try {
            List riskIdList = (List)JSON.parseObject((String)riskJson, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
            if (riskIdList.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"EvalWithSettingFormPlugin_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                logger.error("[DATA-RSA] EvalWithSetting riskIdList isEmpty!");
                return;
            }
        }
        catch (Exception e) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"EvalWithSettingFormPlugin_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            logger.error("[DATA-RSA] EvalWithSetting Json parse error!", (Throwable)e);
            return;
        }
        model.setValue("riskjson_tag", (Object)riskJson);
    }

    private void showWeightSetting() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String scoreSumWay = (String)model.getValue("scoresumway");
        if (StringUtils.isEmpty((CharSequence)scoreSumWay)) {
            return;
        }
        String weightJson = (String)model.getValue("weightjson_tag");
        if (StringUtils.isEmpty((CharSequence)weightJson)) {
            if (StringUtils.equals((CharSequence)ScoreSumWayEnum.PERSON_WEIGHT.getCode(), (CharSequence)scoreSumWay)) {
                DynamicObjectCollection evalUserGroupDyCol = (DynamicObjectCollection)model.getValue("evalusergroup");
                DynamicObjectCollection evalUserDyCol = (DynamicObjectCollection)model.getValue("evaluser");
                if (evalUserGroupDyCol.isEmpty() && evalUserDyCol.isEmpty()) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8bc4\u4f30\u7528\u6237\u7ec4\u6216\u8bc4\u4f30\u4eba\u3002", (String)"EvalWithSettingFormPlugin_4", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set<Long> userIdSet = this.getEvalUserIdSet();
                if (userIdSet.isEmpty()) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u7684\u8bc4\u4f30\u7528\u6237\u7ec4\u4e2d\u627e\u4e0d\u5230\u53ef\u7528\u7684\u4eba\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EvalWithSettingFormPlugin_18", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    return;
                }
                List weightMapList = userIdSet.stream().map(id -> {
                    HashMap<String, Long> weightMap = new HashMap<String, Long>(4);
                    weightMap.put("evalUserId", (Long)id);
                    weightMap.put("evalWeight", null);
                    return weightMap;
                }).collect(Collectors.toList());
                weightJson = JSON.toJSONString(weightMapList);
            }
            if (StringUtils.equals((CharSequence)ScoreSumWayEnum.ORG_WEIGHT.getCode(), (CharSequence)scoreSumWay)) {
                ArrayList weightMapList = new ArrayList();
                HashMap<String, String> dutyMap = new HashMap<String, String>(4);
                dutyMap.put("orgType", "1");
                dutyMap.put("evalWeight", null);
                weightMapList.add(dutyMap);
                HashMap<String, String> unDutyMap = new HashMap<String, String>(4);
                unDutyMap.put("orgType", "2");
                unDutyMap.put("evalWeight", null);
                weightMapList.add(unDutyMap);
                weightJson = JSON.toJSONString(weightMapList);
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("rsa_weightsetting");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6743\u91cd\u8bbe\u7f6e", (String)"EvalWithSettingFormPlugin_5", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "weightsetting"));
        showParameter.setCustomParam("weightJson", (Object)weightJson);
        showParameter.setCustomParam("scoresumway", (Object)scoreSumWay);
        view.showForm(showParameter);
    }

    private void preSubmitEvalWith() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String riskJson = (String)model.getValue("riskjson_tag");
        if (StringUtils.isEmpty((CharSequence)riskJson)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u98ce\u9669\u6570\u636e\u4e3a\u7a7a\u3002", (String)"EvalWithSettingFormPlugin_7", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Long> userIdSet = this.getEvalUserIdSet();
        if (userIdSet.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u7684\u8bc4\u4f30\u7528\u6237\u7ec4\u4e2d\u627e\u4e0d\u5230\u53ef\u7528\u7684\u4eba\u5458\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EvalWithSettingFormPlugin_18", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Long> availableEvalUserIdSet = this.getAvailableEvalUserIdSet();
        if (availableEvalUserIdSet.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6743\u91cd\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"EvalWithSettingFormPlugin_19", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        String message = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u751f\u6210%s\u5f20\u98ce\u9669\u8bc4\u4f30\u5355\uff0c\u8bf7\u786e\u8ba4\u5355\u636e\u6570\u91cf\u662f\u5426\u6b63\u786e\uff0c\u786e\u8ba4\u6b63\u786e\u540e\uff0c\u5c06\u81ea\u52a8\u53d1\u9001\u6d88\u606f\u901a\u77e5\u8bc4\u4f30\u4eba\u3002", (String)"EvalWithSettingFormPlugin_8", (String)"data-rsa-formplugin", (Object[])new Object[0]), availableEvalUserIdSet.size());
        view.showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener("evalwithsubmit", (IFormPlugin)this));
    }

    private OperationResult submitEvalWith() {
        List riskIdList;
        IDataModel model = this.getModel();
        Set<Long> availableEvalUserIdSet = this.getAvailableEvalUserIdSet();
        Map mainOrgMap = UserHelper.getUserMainOrgMap(availableEvalUserIdSet);
        Long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        Long ackUserId = (Long)model.getValue("ackuser_id");
        String scoreSumWay = (String)model.getValue("scoresumway");
        String weightJson = (String)model.getValue("weightjson_tag");
        String riskJson = (String)model.getValue("riskjson_tag");
        boolean noEvalBillCodeRule = true;
        boolean noAckBillCodeRule = true;
        boolean noEvalNoCodeRule = true;
        CodeRuleServiceHelper codeRuleServiceHelper = new CodeRuleServiceHelper();
        List allCodeRuleByEntity = codeRuleServiceHelper.getAllCodeRuleByEntity("rsa_evalwith");
        for (CodeRuleInfo codeRuleInfo : allCodeRuleByEntity) {
            if (ResManager.loadKDString((String)"\u98ce\u9669\u8bc4\u4f30\u5355", (String)"EvalWithSettingFormPlugin_23", (String)"data-rsa-formplugin", (Object[])new Object[0]).equals(codeRuleInfo.getName())) {
                noEvalBillCodeRule = false;
            }
            if (ResManager.loadKDString((String)"\u8bc4\u4f30\u7ed3\u679c\u786e\u8ba4\u5355", (String)"EvalWithSettingFormPlugin_24", (String)"data-rsa-formplugin", (Object[])new Object[0]).equals(codeRuleInfo.getName())) {
                noAckBillCodeRule = false;
            }
            if (!ResManager.loadKDString((String)"\u534f\u540c\u8bc4\u4f30\u53f7", (String)"EvalWithSettingFormPlugin_20", (String)"data-rsa-formplugin", (Object[])new Object[0]).equals(codeRuleInfo.getName())) continue;
            noEvalNoCodeRule = false;
        }
        if (noEvalBillCodeRule) {
            logger.error("[DATA-RSA] SubmitEvalWith EvalBillCodeRule does not exist!");
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u98ce\u9669\u8bc4\u4f30\u5355\u7684\u53ef\u7528\u7684\u7f16\u53f7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u7f16\u53f7\u89c4\u5219\u914d\u7f6e\u60c5\u51b5\u3002", (String)"EvalWithSettingFormPlugin_25", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        if (noAckBillCodeRule) {
            logger.error("[DATA-RSA] SubmitEvalWith AckBillCodeRule does not exist!");
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u98ce\u9669\u8bc4\u4f30\u786e\u8ba4\u5355\u7684\u53ef\u7528\u7684\u7f16\u53f7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u7f16\u53f7\u89c4\u5219\u914d\u7f6e\u60c5\u51b5\u3002", (String)"EvalWithSettingFormPlugin_26", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        if (noEvalNoCodeRule) {
            logger.error("[DATA-RSA] SubmitEvalWith EvalNoCodeRule does not exist!");
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8bc4\u4f30\u53f7\u7684\u53ef\u7528\u7684\u7f16\u53f7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u7f16\u53f7\u89c4\u5219\u914d\u7f6e\u60c5\u51b5\u3002", (String)"EvalWithSettingFormPlugin_27", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject codeDy = BusinessDataServiceHelper.newDynamicObject((String)"rsa_evalwith");
        String evalNo = CodeRuleHelper.generateNumber((String)"rsa_evalwith", (DynamicObject)codeDy, null, null);
        if (StringUtils.isEmpty((CharSequence)evalNo)) {
            logger.error("[DATA-RSA] SubmitEvalWith EvalNo isEmpty!");
            throw new KDBizException(ResManager.loadKDString((String)"\u8bc4\u4f30\u53f7\u751f\u6210\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u7f16\u53f7\u89c4\u5219\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\u3002", (String)"EvalWithSettingFormPlugin_21", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        QFilter evalNoFilter = new QFilter("evalno", "=", (Object)evalNo);
        boolean exists = QueryServiceHelper.exists((String)"rsa_evalwith", (QFilter[])new QFilter[]{evalNoFilter});
        if (exists) {
            logger.error("[DATA-RSA] SubmitEvalWith EvalNo exists!");
            throw new KDBizException(ResManager.loadKDString((String)"\u8bc4\u4f30\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u89e6\u53d1\u751f\u6210\u3002", (String)"EvalWithSettingFormPlugin_10", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        if (availableEvalUserIdSet.isEmpty()) {
            logger.error("[DATA-RSA] SubmitEvalWith availableEvalUserIdSet isEmpty!");
            throw new KDBizException(ResManager.loadKDString((String)"\u53ef\u7528\u8bc4\u4f30\u4eba\u5458\u4e3a\u7a7a", (String)"EvalWithSettingFormPlugin_22", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        try {
            riskIdList = (List)JSON.parseObject((String)riskJson, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            logger.error("[DATA-RSA] SubmitEvalWith Json parse error!", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u98ce\u9669\u7f16\u53f7\u96c6\u5408\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5bf9\u5e94json\u6570\u636e\u3002", (String)"EvalWithSettingFormPlugin_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        if (riskIdList == null || riskIdList.isEmpty()) {
            logger.error("[DATA-RSA] SubmitEvalWith riskIdList isEmpty!");
            throw new KDBizException(ResManager.loadKDString((String)"\u98ce\u9669\u7f16\u53f7\u96c6\u5408\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u67e5\u770b\u5bf9\u5e94json\u6570\u636e\u3002", (String)"EvalWithSettingFormPlugin_28", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        List riskMapList = RiskHelper.checkDoingEval((List)riskIdList);
        if (!riskMapList.isEmpty()) {
            logger.error("[DATA-RSA] SubmitEvalWith checkDoingEval error!");
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7684\u98ce\u9669\u8fd8\u6709\u672a\u5b8c\u6210\u7684\u98ce\u9669\u8bc4\u4f30\u6d41\u7a0b\u3002", (String)"EvalWithSettingFormPlugin_12", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        QFilter idFilter = new QFilter("id", "in", (Object)riskIdList);
        Map riskDyMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risk", (QFilter[])new QFilter[]{idFilter});
        if (riskDyMap.isEmpty() || riskDyMap.size() != riskIdList.size()) {
            logger.error("[DATA-RSA] SubmitEvalWith riskIdList data isEmpty!");
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7684\u98ce\u9669\u5b58\u5728\u6570\u636e\u88ab\u5220\u9664\u7684\u60c5\u51b5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"EvalWithSettingFormPlugin_29", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)"rsa_riskeval_BT_S");
        DynamicObject billTypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (String)"id,number", (QFilter[])new QFilter[]{numberFilter});
        ArrayList<DynamicObject> riskEvalDyList = new ArrayList<DynamicObject>(availableEvalUserIdSet.size());
        ArrayList riskDys = new ArrayList(riskDyMap.values());
        for (Long availableEvalUserId : availableEvalUserIdSet) {
            Long dutyOrgId = mainOrgMap.getOrDefault(availableEvalUserId, rootOrgId);
            DynamicObject riskEvalDy = BusinessDataServiceHelper.newDynamicObject((String)"rsa_evalwith");
            DynamicObjectCollection entryEntityDyCol = riskEvalDy.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < riskDys.size(); ++i) {
                DynamicObject riskDy = (DynamicObject)riskDys.get(i);
                DynamicObject entryDynamicObject = new DynamicObject(entryEntityDyCol.getDynamicObjectType());
                entryDynamicObject.set("seq", (Object)(i + 1));
                entryDynamicObject.set("e_risk", riskDy.get("id"));
                entryDynamicObject.set("e_riskname", riskDy.get("name"));
                entryDynamicObject.set("e_riskdesc", riskDy.get("riskdesc"));
                entryDynamicObject.set("e_dutyorg", riskDy.get("dutyorg"));
                entryDynamicObject.set("e_occscore", (Object)0);
                entryDynamicObject.set("e_resultscore", (Object)0);
                entryDynamicObject.set("e_score", (Object)0);
                entryEntityDyCol.add((Object)entryDynamicObject);
            }
            riskEvalDy.set("billstatus", (Object)"A");
            riskEvalDy.set("billtype", (Object)billTypeDy);
            riskEvalDy.set("dutyorg", (Object)dutyOrgId);
            riskEvalDy.set("evalno", (Object)evalNo);
            riskEvalDy.set("evaluser", (Object)availableEvalUserId);
            riskEvalDy.set("ackuser", (Object)ackUserId);
            riskEvalDy.set("scoresumway", (Object)scoreSumWay);
            riskEvalDy.set("weightjson_tag", (Object)weightJson);
            riskEvalDy.set("entryentity", (Object)entryEntityDyCol);
            riskEvalDyList.add(riskEvalDy);
        }
        return SaveServiceHelper.saveOperate((String)"rsa_evalwith", (DynamicObject[])riskEvalDyList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }

    private Set<Long> getEvalUserIdSet() {
        HashSet<Long> idSet = new HashSet<Long>();
        DynamicObjectCollection evalUserGroupDyCol = (DynamicObjectCollection)this.getModel().getValue("evalusergroup");
        DynamicObjectCollection evalUserDyCol = (DynamicObjectCollection)this.getModel().getValue("evaluser");
        if (!evalUserGroupDyCol.isEmpty()) {
            List evalUserGroupIdSet = evalUserGroupDyCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
            Set userIdSet = UserGroupHelper.getUsersIdByUsrGrpIds(evalUserGroupIdSet);
            idSet.addAll(userIdSet);
        }
        if (!evalUserDyCol.isEmpty()) {
            Set userIdSet = evalUserDyCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toSet());
            idSet.addAll(userIdSet);
        }
        return idSet;
    }

    private Set<Long> getAvailableEvalUserIdSet() {
        IDataModel model = this.getModel();
        Set<Long> evalUserIdSet = this.getEvalUserIdSet();
        if (evalUserIdSet.isEmpty()) {
            return new HashSet<Long>();
        }
        String scoreSumWay = (String)model.getValue("scoresumway");
        if (StringUtils.isEmpty((CharSequence)scoreSumWay)) {
            return new HashSet<Long>();
        }
        if (StringUtils.equals((CharSequence)ScoreSumWayEnum.PERSON_WEIGHT.getCode(), (CharSequence)scoreSumWay)) {
            List weightMapList;
            String weightJson = (String)model.getValue("weightjson_tag");
            if (StringUtils.isEmpty((CharSequence)weightJson)) {
                return new HashSet<Long>();
            }
            try {
                weightMapList = (List)JSON.parseObject((String)weightJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                if (weightMapList.isEmpty()) {
                    logger.error("[DATA-RSA] EvalWithSetting weightMapList isEmpty!");
                    return new HashSet<Long>();
                }
            }
            catch (Exception e) {
                logger.error("[DATA-RSA] EvalWithSetting Json parse error!", (Throwable)e);
                return new HashSet<Long>();
            }
            return weightMapList.stream().filter(map -> {
                int evalWeight = 0;
                Object evalWeightObj = map.get("evalWeight");
                if (evalWeightObj != null && StringUtils.isNotEmpty((CharSequence)evalWeightObj.toString())) {
                    evalWeight = ((Number)map.get("evalWeight")).intValue();
                }
                return evalWeight != 0;
            }).map(map -> {
                long evalUserId = 0L;
                Object evalUserIdObj = map.get("evalUserId");
                if (evalUserIdObj != null && StringUtils.isNotEmpty((CharSequence)evalUserIdObj.toString())) {
                    evalUserId = ((Number)map.get("evalUserId")).longValue();
                }
                return evalUserId;
            }).collect(Collectors.toSet());
        }
        return evalUserIdSet;
    }
}

