/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.util.EventObject;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.RiskEventStatusEnum;
import kd.data.rsa.helper.RiskEventHelper;

public class EventHandleFormPlugin
extends AbstractFormPlugin {
    private static final String CUSTOM_EVENTID = "eventid";
    private static final String CONTROL_OK = "btnok";
    private static final String FIELD_REMARK = "remark";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_PROCESS = "process";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONTROL_OK});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (CONTROL_OK.equals(control.getKey())) {
            boolean status = (Boolean)this.getModel().getValue(FIELD_STATUS);
            boolean process = (Boolean)this.getModel().getValue(FIELD_PROCESS);
            if (!status && !process) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u5904\u7406\u72b6\u6001\u3002", (String)"EventHandleFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            String remark = (String)this.getModel().getValue(FIELD_REMARK);
            if (StringUtils.isEmpty((String)remark)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u5907\u6ce8\u8bf4\u660e\u3002", (String)"EventHandleFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            String eventIdStr = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_EVENTID);
            RiskEventStatusEnum statusEnum = null;
            statusEnum = status ? RiskEventStatusEnum.PROCESSED : RiskEventStatusEnum.PROCESSIND;
            Object[] ids = EventHandleFormPlugin.stringToArrays(eventIdStr);
            RiskEventHelper.processEvent((Object[])ids, (RiskEventStatusEnum)statusEnum, (String)remark);
            this.getView().returnDataToParent((Object)CONTROL_OK);
            this.getView().close();
        }
    }

    public static void openHandle(Object[] eventIds, AbstractFormPlugin listPlugin, String actionId, Long orgId) {
        if (!EventHandleFormPlugin.hasPermission(orgId)) {
            listPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u72b6\u6001\u6807\u6ce8\u6743\u9650", (String)"EventHandleFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (eventIds == null || eventIds.length == 0 || listPlugin == null) {
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("rsa_eventhandle");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(CUSTOM_EVENTID, (Object)EventHandleFormPlugin.arraysToString(eventIds));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)listPlugin, actionId));
        listPlugin.getView().showForm(fsp);
    }

    private static String arraysToString(Object[] pks) {
        StringBuilder idStr = new StringBuilder();
        for (Object id : pks) {
            idStr.append(id).append(',');
        }
        return idStr.substring(0, idStr.length() - 1);
    }

    private static Object[] stringToArrays(String idStr) {
        return Stream.of(idStr.split(",")).map(Long::parseLong).distinct().toArray();
    }

    protected static boolean hasPermission(Long orgId) {
        RequestContext context = RequestContext.get();
        return PermissionServiceHelper.checkPermission((Long)context.getCurrUserId(), (Long)orgId, (String)"rsa", (String)"rsa_riskevent", (String)"2POLOK68KK/R") > 0;
    }
}

