/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.rsa.helper.RiskLevelEvalCriteriaHelper;

public class ResultEffectEdit
extends AbstractFormPlugin {
    private static final String ALGO_KEY = ResultEffectEdit.class.getName();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadData();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"saveentry", (CharSequence)operateKey)) {
            this.clearEntityEmptyData();
        }
        if (StringUtils.equals((CharSequence)"deleteentry", (CharSequence)operateKey)) {
            boolean checkResult = this.checkQuote();
            args.setCancel(checkResult);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        boolean isSuccess;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"saveentry", (CharSequence)operateKey) && (isSuccess = afterDoOperationEventArgs.getOperationResult().isSuccess())) {
            this.loadData();
            RiskLevelEvalCriteriaHelper.updateRiskLevelEvaCriteria();
        }
        if (StringUtils.equals((CharSequence)"refreshentry", (CharSequence)operateKey)) {
            this.loadData();
        }
    }

    private void loadData() {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"rsa_resulteffect", (String)"id,number,name,scorefrom,scoreto", (QFilter[])new QFilter[]{statusFilter, enableFilter}, (String)"scorefrom desc", (int)10000);){
            IDataModel model = this.getModel();
            model.deleteEntryData("entryentity");
            DynamicObjectCollection dyCols = ORM.create().toPlainDynamicObjectCollection(dataSet);
            if (dyCols.isEmpty()) {
                return;
            }
            int size = dyCols.size();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", size);
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            DynamicProperty idData = entryEntity.getDynamicObjectType().getProperty("e_id");
            DynamicProperty numberData = entryEntity.getDynamicObjectType().getProperty("e_number");
            DynamicProperty nameData = entryEntity.getDynamicObjectType().getProperty("e_name");
            DynamicProperty scoreFromData = entryEntity.getDynamicObjectType().getProperty("e_scorefrom");
            DynamicProperty scoreToData = entryEntity.getDynamicObjectType().getProperty("e_scoreto");
            for (int i = 0; i < size; ++i) {
                DynamicObject dy = (DynamicObject)dyCols.get(i);
                DynamicObject entryDy = (DynamicObject)entryEntity.get(i);
                idData.setValueFast((Object)entryDy, dy.get("id"));
                numberData.setValueFast((Object)entryDy, dy.get("number"));
                nameData.setValueFast((Object)entryDy, dy.get("name"));
                scoreFromData.setValueFast((Object)entryDy, dy.get("scorefrom"));
                scoreToData.setValueFast((Object)entryDy, dy.get("scoreto"));
            }
            model.endInit();
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView("entryentity");
    }

    private void clearEntityEmptyData() {
        int count = this.getModel().getEntryRowCount("entryentity");
        HashSet<Integer> deleteRowCountSet = new HashSet<Integer>();
        for (int i = 0; i < count; ++i) {
            String number = (String)this.getModel().getValue("e_number", i);
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("e_name", i);
            Integer scoreFrom = (Integer)this.getModel().getValue("e_scorefrom", i);
            Integer scoreTo = (Integer)this.getModel().getValue("e_scoreto", i);
            if (!StringUtils.isEmpty((CharSequence)number) || name.getLocaleValue() != null || scoreFrom != null || scoreTo != null) continue;
            deleteRowCountSet.add(i);
        }
        if (deleteRowCountSet.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryRows("entryentity", deleteRowCountSet.stream().mapToInt(v -> v).toArray());
    }

    private boolean checkQuote() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length != 0) {
            int selectRowIndex = selectRows[0];
            DynamicObject rowDy = (DynamicObject)entryEntity.get(selectRowIndex);
            Long id = rowDy.getLong("e_id");
            if (id == 0L) {
                return false;
            }
            BaseDataCheckRefrence baseDataCheckRefrence = new BaseDataCheckRefrence();
            BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"rsa_resulteffect");
            if (baseDataCheckRefrence.isRefrenced(basedataEntityType, (Object)id)) {
                BaseDataCheckRefrenceResult refResult = baseDataCheckRefrence.checkRef(basedataEntityType, (Object)id);
                BaseDataRefenceKey baseDataRefenceKey = refResult.getRefenceKey();
                String refEntityKey = baseDataRefenceKey.getRefEntityKey();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)refEntityKey);
                String displayName = dataEntityType.getDisplayName().getLocaleValue();
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u884c\u5206\u5f55\u5df2\u88ab%s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ResultEffectEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0]), displayName));
                return true;
            }
        }
        return false;
    }
}

