/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.rsa.helper.RiskHelper;

public class RiskCloseFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(RiskCloseFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            try {
                this.submitCloseRisk();
                view.returnDataToParent((Object)"submit");
                view.close();
            }
            catch (KDBizException e) {
                view.showErrorNotification(e.getMessage());
                logger.error("[DATA-RSA] SubmitCloseRisk operate error!", (Throwable)e);
            }
            catch (Exception e) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\u3002\u9519\u8bef\u4fe1\u606f:%s", (String)"RiskCloseFormPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]), e.getMessage()));
                logger.error("[DATA-RSA] SubmitCloseRisk operate error!", (Throwable)e);
            }
        }
    }

    private void init() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String riskJson = (String)view.getFormShowParameter().getCustomParam("riskjson");
        if (StringUtils.isEmpty((CharSequence)riskJson)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"RiskCloseFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            logger.error("[DATA-RSA] CloseRisk init error!");
            return;
        }
        try {
            List riskIdList = (List)JSON.parseObject((String)riskJson, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
            if (riskIdList.isEmpty()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"RiskCloseFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                logger.error("[DATA-RSA] CloseRisk riskIdList isEmpty!");
                return;
            }
        }
        catch (Exception e) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"RiskCloseFormPlugin_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            logger.error("[DATA-RSA] CloseRisk Json parse error!", (Throwable)e);
            return;
        }
        model.setValue("riskjson_tag", (Object)riskJson);
    }

    private void submitCloseRisk() {
        DynamicObject[] riskDys;
        List riskIdList;
        IDataModel model = this.getModel();
        Date date = new Date();
        long userId = RequestContext.get().getCurrUserId();
        String riskJson = (String)model.getValue("riskjson_tag");
        String closeExplain = (String)model.getValue("closeexplain");
        if (StringUtils.isEmpty((CharSequence)closeExplain)) {
            logger.error("[DATA-RSA] SubmitCloseRisk closeExplain isEmpty!");
            throw new KDBizException(ResManager.loadKDString((String)"\u5173\u95ed\u8bf4\u660e\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u770b\u5bf9\u5e94\u6570\u636e\u3002", (String)"RiskCloseFormPlugin_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)riskJson)) {
            logger.error("[DATA-RSA] SubmitCloseRisk riskJson isEmpty!");
            throw new KDBizException(ResManager.loadKDString((String)"\u98ce\u9669\u6570\u636e\u4e3a\u7a7a\u3002", (String)"RiskCloseFormPlugin_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        try {
            riskIdList = (List)JSON.parseObject((String)riskJson, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            logger.error("[DATA-RSA] SubmitCloseRisk Json parse error!", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u98ce\u9669\u7f16\u53f7\u96c6\u5408\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5bf9\u5e94json\u6570\u636e\u3002", (String)"RiskCloseFormPlugin_4", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        List riskMapList = RiskHelper.checkDoingEval((List)riskIdList);
        if (!riskMapList.isEmpty()) {
            logger.error("[DATA-RSA] SubmitCloseRisk checkDoingEval error!");
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7684\u98ce\u9669\u8fd8\u6709\u672a\u5b8c\u6210\u7684\u98ce\u9669\u8bc4\u4f30\u6d41\u7a0b\u3002", (String)"RiskCloseFormPlugin_5", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        QFilter idFilter = new QFilter("id", "in", (Object)riskIdList);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        Map riskDyMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risk", (QFilter[])new QFilter[]{idFilter, billStatusFilter});
        if (riskDyMap.isEmpty() || riskDyMap.size() != riskIdList.size()) {
            logger.error("[DATA-RSA] SubmitCloseRisk riskIdList data size is error!");
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7684\u98ce\u9669\u5b58\u5728\u6570\u636e\u88ab\u5220\u9664\u6216\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u767b\u8bb0\u72b6\u6001\u7684\u60c5\u51b5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RiskCloseFormPlugin_6", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject riskDy : riskDys = BusinessDataServiceHelper.load((String)"rsa_risk", (String)"id,billstatus,closedesc,modifytime,modifier", (QFilter[])new QFilter[]{idFilter, billStatusFilter})) {
            riskDy.set("closedesc", (Object)closeExplain);
            riskDy.set("billstatus", (Object)"D");
            riskDy.set("modifytime", (Object)date);
            riskDy.set("modifier", (Object)userId);
        }
        SaveServiceHelper.update((DynamicObject[])riskDys);
    }
}

