/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.data.rsa.helper.OccurPossibilityHelper;
import kd.data.rsa.helper.OrgHelper;
import kd.data.rsa.helper.ResultEffectHelper;
import kd.data.rsa.helper.RiskAnalysisLogHelper;
import kd.data.rsa.helper.RiskHelper;
import kd.data.rsa.helper.RiskLevelEvalCriteriaHelper;

public class RiskEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(RiskEdit.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IPageCache pageCache = this.getView().getPageCache();
        String status = pageCache.get("status");
        if (status == null) {
            this.initBasicData();
            pageCache.put("status", "inited");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initControlAttr();
        this.initControlLock();
        this.initAnaEntryData();
        this.initCalEntryData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dutyOrgBaseData = (BasedataEdit)this.getControl("dutyorg");
        dutyOrgBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit riskItemBaseData = (BasedataEdit)this.getControl("riskitem");
        riskItemBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit execOrgBaseData = (BasedataEdit)this.getControl("c_execorg");
        execOrgBaseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid anaEntryGrid = (EntryGrid)this.getControl("anaentryentity");
        anaEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String fieldName = event.getFieldName();
        if (StringUtils.equals((CharSequence)"a_evalbillno", (CharSequence)fieldName)) {
            int rowIndex = event.getRowIndex();
            String evalBillNo = (String)model.getValue("a_evalbillno", rowIndex);
            QFilter evalBillNoFilter = new QFilter("evalno", "=", (Object)evalBillNo);
            QFilter ackBillTypeFilter = new QFilter("billtype.number", "=", (Object)"rsa_evalack_BT_S");
            DynamicObject evalWithDy = QueryServiceHelper.queryOne((String)"rsa_evalwith", (String)"id", (QFilter[])new QFilter[]{evalBillNoFilter, ackBillTypeFilter});
            if (evalWithDy == null) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u8bc4\u4f30\u7ed3\u679c\u786e\u8ba4\u5355[%s]\u5df2\u88ab\u5220\u9664\u6216\u4e0d\u5b58\u5728!", (String)"RiskEdit_5", (String)"data-rsa-formplugin", (Object[])new Object[0]), evalBillNo));
                return;
            }
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)evalWithDy.getLong("id"));
            billShowParameter.setFormId("rsa_evalack_layout");
            billShowParameter.setPermissionEntityId("rsa_evalwith");
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)billShowParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"dutyorg", (CharSequence)propertyName)) {
            model.setValue("riskitem", null);
            return;
        }
        if (StringUtils.equals((CharSequence)"a_occscore", (CharSequence)propertyName)) {
            EntryGrid anaEntryGrid = (EntryGrid)this.getControl("anaentryentity");
            DynamicObjectCollection anaEntryEntity = model.getEntryEntity("anaentryentity");
            int selectRowIndex = anaEntryGrid.getSelectRows()[0];
            DynamicObject rowDataDy = (DynamicObject)anaEntryEntity.get(selectRowIndex);
            this.updateAnaEntryOccData(selectRowIndex, rowDataDy);
            this.updateAnaEntryOtherData(selectRowIndex, rowDataDy);
            return;
        }
        if (StringUtils.equals((CharSequence)"a_resultscore", (CharSequence)propertyName)) {
            EntryGrid anaEntryGrid = (EntryGrid)this.getControl("anaentryentity");
            DynamicObjectCollection anaEntryEntity = model.getEntryEntity("anaentryentity");
            int selectRowIndex = anaEntryGrid.getSelectRows()[0];
            DynamicObject rowDataDy = (DynamicObject)anaEntryEntity.get(selectRowIndex);
            this.updateAnaEntryResData(selectRowIndex, rowDataDy);
            this.updateAnaEntryOtherData(selectRowIndex, rowDataDy);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            this.updateRiskScoreAndLevel();
            return;
        }
        if (StringUtils.equals((CharSequence)"checkin", (CharSequence)operateKey)) {
            Long pkId = (Long)model.getValue("id");
            boolean dataChanged = model.getDataChanged();
            if (pkId == null || pkId == 0L || dataChanged) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u98ce\u9669\u5355\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"RiskEdit_6", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey)) {
            if (!operationResult.isSuccess()) {
                model.setValue("riskscore", null);
                model.setValue("risklevel", null);
                return;
            }
            DynamicObjectCollection anaEntryEntity = this.getModel().getEntryEntity("anaentryentity");
            for (DynamicObject entryDy : anaEntryEntity) {
                String name = entryDy.getString("a_name");
                DynamicObject riskLevelDy = entryDy.getDynamicObject("a_level");
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)name)) continue;
                Long pkId = (Long)model.getValue("id");
                if (pkId == null || pkId == 0L) {
                    return;
                }
                if (riskLevelDy == null) continue;
                RiskAnalysisLogHelper.save((Long)pkId, (DynamicObject)entryDy);
                logger.error("[DATA-RSA] RiskEdit afterDoOperation saveAnalysisLog success!");
            }
            view.invokeOperation("refresh");
            return;
        }
        if (StringUtils.equals((CharSequence)"checkin", (CharSequence)operateKey) && operationResult.isSuccess()) {
            view.invokeOperation("refresh");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"dutyorg", (CharSequence)key)) {
            List orgList = OrgHelper.getPermSubOrgList((String)"rsa_risk", (String)"47156aff000000ac");
            QFilter idFilter = new QFilter("id", "in", (Object)orgList);
            evt.addCustomQFilter(idFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)"riskitem", (CharSequence)key)) {
            Long dutyOrgId = (Long)this.getModel().getValue("dutyorg_id");
            if (dutyOrgId == null || dutyOrgId == 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d23\u4efb\u90e8\u95e8\u3002", (String)"RiskEdit_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter riskItemFilter = BaseDataServiceHelper.getBaseDataFilter((String)"rsa_riskitem", (Long)dutyOrgId);
            evt.addCustomQFilter(riskItemFilter);
            return;
        }
        if (StringUtils.equals((CharSequence)"c_execorg", (CharSequence)key)) {
            List allSubOrgList = OrgHelper.getAllSubOrgList();
            QFilter idFilter = new QFilter("id", "in", (Object)allSubOrgList);
            evt.addCustomQFilter(idFilter);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("anaentryentity");
        entryEntity.clear();
    }

    private void initBasicData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String orgIdStr = (String)view.getFormShowParameter().getCustomParam("orgId");
        String riskGroupIdStr = (String)view.getFormShowParameter().getCustomParam("riskGroupId");
        if (!StringUtils.isEmpty((CharSequence)orgIdStr)) {
            Long orgId = Long.valueOf(orgIdStr);
            model.setValue("dutyorg", (Object)orgId);
        } else {
            model.setValue("dutyorg", null);
        }
        if (!StringUtils.isEmpty((CharSequence)riskGroupIdStr)) {
            model.setValue("group", (Object)Long.valueOf(riskGroupIdStr));
        }
    }

    private void initControlAttr() {
        int[] resPeakRange;
        IFormView view = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        int[] occPeakRange = OccurPossibilityHelper.getPeakRange();
        if (occPeakRange.length == 2) {
            String emptyTips = String.format("(%s, %s]", occPeakRange[0], occPeakRange[1]);
            clientViewProxy.invokeControlMethod("anaentryentity", "setColEditorProp", new Object[]{"a_occscore", "emptytip", emptyTips});
        }
        if ((resPeakRange = ResultEffectHelper.getPeakRange()).length == 2) {
            String emptyTips = String.format("(%s, %s]", resPeakRange[0], resPeakRange[1]);
            clientViewProxy.invokeControlMethod("anaentryentity", "setColEditorProp", new Object[]{"a_resultscore", "emptytip", emptyTips});
        }
    }

    private void initControlLock() {
        IDataModel model = this.getModel();
        Long curUserId = RequestContext.get().getCurrUserId();
        String appId = AppMetadataCache.getAppInfo((String)"rsa").getAppId();
        String billStatus = (String)model.getValue("billstatus");
        String permBillValue = "0";
        String permTabMonValue = "0";
        String permTabCalValue = "0";
        if (StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
            boolean modifyResult = PermissionServiceHelper.checkPermission((Long)curUserId, (String)appId, (String)"rsa_risk", (String)"4715a0df000000ac");
            if (!modifyResult) {
                permBillValue = "1";
            }
            DynamicObjectCollection anaEntryEntity = this.getModel().getEntryEntity("anaentryentity");
            for (Object entryDy : anaEntryEntity) {
                int rowIndex = entryDy.getInt("seq") - 1;
                model.setValue("a_perm", (Object)"0", rowIndex);
            }
            DynamicObjectCollection calEntryEntity = model.getEntryEntity("calentryentity");
            for (DynamicObject entryDy : calEntryEntity) {
                int rowIndex = entryDy.getInt("seq") - 1;
                model.setValue("c_perm", (Object)"0", rowIndex);
            }
            model.setValue("permbill", (Object)permBillValue);
            model.setValue("permtabmon", (Object)permTabMonValue);
            model.setValue("permtabcal", (Object)permTabCalValue);
            model.setDataChanged(false);
            return;
        }
        if (StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) {
            int updatePlanResult;
            Long dutyOrgId = (Long)model.getValue("dutyorg_id");
            DynamicObjectCollection anaEntryEntity = this.getModel().getEntryEntity("anaentryentity");
            int resRiskResult = PermissionServiceHelper.checkPermission((Long)curUserId, (Long)dutyOrgId, (String)appId, (String)"rsa_risk", (String)"3FZL+/JU99BG");
            for (DynamicObject entryDy : anaEntryEntity) {
                String entryPerm = "0";
                String name = entryDy.getString("a_name");
                int rowIndex = entryDy.getInt("seq") - 1;
                if (StringUtils.equals((CharSequence)"0", (CharSequence)name)) {
                    entryPerm = "1";
                }
                if (StringUtils.equals((CharSequence)"1", (CharSequence)name) && resRiskResult == 0) {
                    entryPerm = "1";
                }
                model.setValue("a_perm", (Object)entryPerm, rowIndex);
            }
            int monitorResult = PermissionServiceHelper.checkPermission((Long)curUserId, (Long)dutyOrgId, (String)appId, (String)"rsa_risk", (String)"4715a0df000000ac");
            if (monitorResult == 0) {
                permTabMonValue = "1";
            }
            if ((updatePlanResult = PermissionServiceHelper.checkPermission((Long)curUserId, (Long)dutyOrgId, (String)appId, (String)"rsa_risk", (String)"3FZKT9ZWVP/U")) == 0) {
                permTabCalValue = "1";
            } else {
                Long dutyUserId = (Long)model.getValue("dutyuser_id");
                boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)curUserId);
                DynamicObjectCollection calEntryEntity = model.getEntryEntity("calentryentity");
                if (!curUserId.equals(dutyUserId) && !isSuperUser) {
                    permTabCalValue = "2";
                }
                for (DynamicObject entryDy : calEntryEntity) {
                    String entryPerm = "0";
                    DynamicObject execUserDy = entryDy.getDynamicObject("c_execuser");
                    int rowIndex = entryDy.getInt("seq") - 1;
                    if (!curUserId.equals(dutyUserId) && !isSuperUser) {
                        entryPerm = execUserDy != null && curUserId.equals(execUserDy.getLong("id")) ? "2" : "1";
                    }
                    model.setValue("c_perm", (Object)entryPerm, rowIndex);
                }
            }
            model.setValue("permbill", (Object)permBillValue);
            model.setValue("permtabmon", (Object)permTabMonValue);
            model.setValue("permtabcal", (Object)permTabCalValue);
            model.setDataChanged(false);
            return;
        }
        if (StringUtils.equals((CharSequence)"D", (CharSequence)billStatus)) {
            permBillValue = "1";
            permTabMonValue = "1";
            permTabCalValue = "1";
            model.setValue("permbill", (Object)permBillValue);
            model.setValue("permtabmon", (Object)permTabMonValue);
            model.setValue("permtabcal", (Object)permTabCalValue);
            model.setDataChanged(false);
        }
    }

    private void initAnaEntryData() {
        IDataModel model = this.getModel();
        Long pkId = (Long)model.getValue("id");
        String billStatus = (String)model.getValue("billstatus");
        DynamicObjectCollection anaEntryEntity = model.getEntryEntity("anaentryentity");
        if (pkId == null || pkId == 0L) {
            model.batchCreateNewEntryRow("anaentryentity", 1);
            model.setValue("a_name", (Object)"0", 0);
            model.setDataChanged(false);
            return;
        }
        if (StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
            if (anaEntryEntity.isEmpty()) {
                model.batchCreateNewEntryRow("anaentryentity", 1);
                model.setValue("a_name", (Object)"0", 0);
                model.setDataChanged(false);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"C", (CharSequence)billStatus) && anaEntryEntity.size() == 1) {
            model.batchCreateNewEntryRow("anaentryentity", 1);
            model.setValue("a_name", (Object)"1", 1);
            model.setDataChanged(false);
        }
    }

    private void initCalEntryData() {
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        if (StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) {
            Long pkId = (Long)model.getValue("id");
            RiskHelper.updateOverDue((Long)pkId);
            logger.error("[DATA-RSA] RiskEdit initCalEntryData updateOverDue success!");
        }
    }

    private void updateAnaEntryOccData(int rowIndex, DynamicObject rowDataDy) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BigDecimal occScore = rowDataDy.getBigDecimal("a_occscore");
        DynamicObject occDy = OccurPossibilityHelper.getSingle((BigDecimal)occScore);
        if (occDy == null) {
            model.setValue("a_occscore", null, rowIndex);
            model.setValue("a_occdesc", null, rowIndex);
            model.setValue("a_score", null, rowIndex);
            model.setValue("a_level", null, rowIndex);
            model.setValue("a_leveldesc", null, rowIndex);
            int[] peakRange = OccurPossibilityHelper.getPeakRange();
            if (peakRange.length == 2) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u53d1\u751f\u53ef\u80fd\u6027\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4(%1$s,%2$s]\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0]), peakRange[0], peakRange[1]));
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u53d1\u751f\u53ef\u80fd\u6027\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskEdit_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        model.setValue("a_occdesc", (Object)occDy.getString("name"), rowIndex);
    }

    private void updateAnaEntryResData(int rowIndex, DynamicObject rowDataDy) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BigDecimal resultScore = rowDataDy.getBigDecimal("a_resultscore");
        DynamicObject resDy = ResultEffectHelper.getSingle((BigDecimal)resultScore);
        if (resDy == null) {
            model.setValue("a_resultscore", null, rowIndex);
            model.setValue("a_resultdesc", null, rowIndex);
            model.setValue("a_score", null, rowIndex);
            model.setValue("a_level", null, rowIndex);
            model.setValue("a_leveldesc", null, rowIndex);
            int[] peakRange = ResultEffectHelper.getPeakRange();
            if (peakRange.length == 2) {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u540e\u679c\u5f71\u54cd\u7a0b\u5ea6\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4(%1$s,%2$s]\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskEdit_4", (String)"data-rsa-formplugin", (Object[])new Object[0]), peakRange[0], peakRange[1]));
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u540e\u679c\u5f71\u54cd\u7a0b\u5ea6\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskEdit_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        model.setValue("a_resultdesc", (Object)resDy.getString("name"), rowIndex);
    }

    private void updateAnaEntryOtherData(int rowIndex, DynamicObject rowDataDy) {
        IDataModel model = this.getModel();
        model.setValue("a_evalbillno", null, rowIndex);
        BigDecimal resultScore = rowDataDy.getBigDecimal("a_resultscore");
        DynamicObject resDy = ResultEffectHelper.getSingle((BigDecimal)resultScore);
        if (resDy == null) {
            return;
        }
        BigDecimal occScore = rowDataDy.getBigDecimal("a_occscore");
        DynamicObject occDy = OccurPossibilityHelper.getSingle((BigDecimal)occScore);
        if (occDy == null) {
            return;
        }
        model.setValue("a_score", (Object)occScore.multiply(resultScore), rowIndex);
        DynamicObject riskLevelEvaDy = RiskLevelEvalCriteriaHelper.getSingle((Long)occDy.getLong("id"), (Long)resDy.getLong("id"));
        if (riskLevelEvaDy == null || riskLevelEvaDy.get("risklevelid") == null) {
            model.setValue("a_level", null, rowIndex);
            model.setValue("a_leveldesc", null, rowIndex);
            model.setValue("risklevel", null);
            return;
        }
        model.setValue("a_level", (Object)riskLevelEvaDy.getLong("risklevelid.id"), rowIndex);
        model.setValue("a_leveldesc", (Object)riskLevelEvaDy.getString("risklevelid.name"), rowIndex);
    }

    private void updateRiskScoreAndLevel() {
        String name;
        IDataModel model = this.getModel();
        String billStatus = (String)model.getValue("billstatus");
        DynamicObjectCollection anaEntryEntity = this.getModel().getEntryEntity("anaentryentity");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
            for (DynamicObject entryDy : anaEntryEntity) {
                name = entryDy.getString("a_name");
                if (!StringUtils.equals((CharSequence)"0", (CharSequence)name)) continue;
                BigDecimal riskScore = entryDy.getBigDecimal("a_score");
                model.setValue("riskscore", (Object)riskScore);
                DynamicObject riskLevelDy = entryDy.getDynamicObject("a_level");
                if (riskLevelDy == null) {
                    model.setValue("risklevel", null);
                    return;
                }
                model.setValue("risklevel", (Object)riskLevelDy.getLong("id"));
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) {
            for (DynamicObject entryDy : anaEntryEntity) {
                name = entryDy.getString("a_name");
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)name)) continue;
                BigDecimal riskScore = entryDy.getBigDecimal("a_score");
                DynamicObject riskLevelDy = entryDy.getDynamicObject("a_level");
                if (riskLevelDy == null) {
                    return;
                }
                model.setValue("isresidue", (Object)"1");
                model.setValue("riskscore", (Object)riskScore);
                model.setValue("risklevel", (Object)riskLevelDy.getLong("id"));
                return;
            }
        }
    }
}

