/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.data.rsa.enums.ScoreSumWayEnum;
import kd.data.rsa.helper.OccurPossibilityHelper;
import kd.data.rsa.helper.OrgHelper;
import kd.data.rsa.helper.ResultEffectHelper;
import kd.data.rsa.helper.RiskLevelEvalCriteriaHelper;

public class RiskEvalEdit
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(RiskEvalEdit.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initControlAttr();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        QFilter billTypeFilter;
        String evalNo;
        QFilter evalNoFilter;
        DynamicObject evalAck;
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"submitevalresult", (CharSequence)operateKey)) {
            boolean entryFlag;
            String submitCommitted;
            String scoreSumWay = (String)model.getValue("scoresumway");
            if (StringUtils.isEmpty((CharSequence)scoreSumWay)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5206\u6570\u6c47\u603b\u65b9\u5f0f\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u8bbe\u7f6e\u3002", (String)"RiskEvalEdit_7", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (StringUtils.equals((CharSequence)ScoreSumWayEnum.ORG_WEIGHT.getCode(), (CharSequence)scoreSumWay) && (submitCommitted = pageCache.get("submitcommitted")) == null && !(entryFlag = this.validateEntry())) {
                view.showConfirm(ResManager.loadKDString((String)"\u8bc4\u4f30\u7684\u98ce\u9669\u4e2d\uff0c\u6ca1\u6709\u8d23\u4efb\u90e8\u95e8\u4e0e\u8bc4\u4f30\u90e8\u95e8\u76f8\u540c\u7684\u98ce\u9669\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\u8bc4\u4f30\u7ed3\u679c\u3002", (String)"RiskEvalEdit_6", (String)"data-rsa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("submitevalresult", (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
            boolean dataChanged = model.getDataChanged();
            DynamicObject dataDy = model.getDataEntity();
            if (dataChanged) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ignoreValidation", String.valueOf(true));
                OperationResult operationResult = SaveServiceHelper.saveOperate((String)"rsa_evalwith", (DynamicObject[])new DynamicObject[]{dataDy}, (OperateOption)operateOption);
                if (!operationResult.isSuccess()) {
                    view.showErrorNotification(operationResult.getMessage());
                    args.setCancel(true);
                }
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"revokevalresult", (CharSequence)operateKey) && (evalAck = BusinessDataServiceHelper.loadSingleFromCache((String)"rsa_evalwith", (String)"id", (QFilter[])new QFilter[]{evalNoFilter = new QFilter("evalno", "=", (Object)(evalNo = (String)model.getValue("evalno"))), billTypeFilter = new QFilter("billtype.number", "=", (Object)"rsa_evalack_BT_S")})) != null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u98ce\u9669\u8bc4\u4f30\u786e\u8ba4\u5355\uff0c\u65e0\u6cd5\u64a4\u56de\u8bc4\u4f30\u7ed3\u679c\u3002", (String)"RiskEvalEdit_8", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IFormView view = this.getView();
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (StringUtils.equals((CharSequence)"submitevalresult", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"revokevalresult", (CharSequence)operateKey)) {
            if (operationResult.isSuccess()) {
                view.invokeOperation("refresh");
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"changeorg", (CharSequence)operateKey)) {
            List orgIds = OrgHelper.getPermSubOrgList((String)"rsa_evalwith", (String)"3K91QVPAR3AZ");
            QFilter idFilter = new QFilter("id", "in", (Object)orgIds);
            ListShowParameter lsp = new ListShowParameter();
            lsp.setFormId("bos_orgtreelistf7");
            lsp.setBillFormId("bos_org");
            lsp.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"RiskEvalEdit_4", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            lsp.setShowTitle(false);
            lsp.setLookUp(true);
            lsp.setMultiSelect(false);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            ListFilterParameter lfp = lsp.getListFilterParameter();
            lfp.setFilter(idFilter);
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("580px");
            styleCss.setWidth("960px");
            lsp.getOpenStyle().setInlineStyleCss(styleCss);
            lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "changeorg"));
            lsp.setHasRight(true);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        IDataModel model = this.getModel();
        if ("changeorg".equals(closedCallBackEvent.getActionId()) && (returnData = closedCallBackEvent.getReturnData()) instanceof ListSelectedRowCollection) {
            try {
                ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)returnData;
                if (!selectedRow.isEmpty()) {
                    Object keyValue = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
                    model.setValue("dutyorg", keyValue);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)model.getValue("id"), (String)"rsa_evalwith");
                    dynamicObject.set("dutyorg", keyValue);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u8bc4\u4f30\u90e8\u95e8\u6210\u529f\u3002", (String)"RiskEvalEdit_5", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                }
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)"submitevalresult", (CharSequence)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            pageCache.put("submitcommitted", "1");
            view.invokeOperation("submitevalresult");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"e_occscore", (CharSequence)propertyName)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            int selectRowIndex = entryGrid.getSelectRows()[0];
            DynamicObject rowDataDy = (DynamicObject)entryEntity.get(selectRowIndex);
            this.updateEntryOccData(selectRowIndex, rowDataDy);
            this.updateEntryScoreAndLevel(selectRowIndex, rowDataDy);
            return;
        }
        if (StringUtils.equals((CharSequence)"e_resultscore", (CharSequence)propertyName)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            int selectRowIndex = entryGrid.getSelectRows()[0];
            DynamicObject rowDataDy = (DynamicObject)entryEntity.get(selectRowIndex);
            this.updateEntryResData(selectRowIndex, rowDataDy);
            this.updateEntryScoreAndLevel(selectRowIndex, rowDataDy);
        }
    }

    private void initControlAttr() {
        int[] resPeakRange;
        int[] occPeakRange;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        Object callBackInfo = model.getValue("callbackinfo");
        if (callBackInfo == null || " ".equals(callBackInfo.toString()) || "".equals(callBackInfo.toString())) {
            view.setVisible(Boolean.FALSE, new String[]{"callbackinfo"});
        }
        if ((occPeakRange = OccurPossibilityHelper.getPeakRange()).length == 2) {
            String emptyTips = String.format("(%s, %s]", occPeakRange[0], occPeakRange[1]);
            clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"e_occscore", "emptytip", emptyTips});
        }
        if ((resPeakRange = ResultEffectHelper.getPeakRange()).length == 2) {
            String emptyTips = String.format("(%s, %s]", resPeakRange[0], resPeakRange[1]);
            clientViewProxy.invokeControlMethod("entryentity", "setColEditorProp", new Object[]{"e_resultscore", "emptytip", emptyTips});
        }
    }

    private boolean validateEntry() {
        IDataModel model = this.getModel();
        Long dutyOrgId = (Long)model.getValue("dutyorg_id");
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        Set eDutyOrgIdSet = entryEntity.stream().map(dy -> {
            DynamicObject eDutyOrgDy = dy.getDynamicObject("e_dutyorg");
            return eDutyOrgDy == null ? 0L : eDutyOrgDy.getLong("id");
        }).collect(Collectors.toSet());
        return eDutyOrgIdSet.contains(dutyOrgId);
    }

    private void updateEntryOccData(int rowIndex, DynamicObject rowDataDy) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BigDecimal occScore = rowDataDy.getBigDecimal("e_occscore");
        DynamicObject occDy = OccurPossibilityHelper.getSingle((BigDecimal)occScore);
        if (occDy == null) {
            model.setValue("e_occscore", null, rowIndex);
            model.setValue("e_occdesc", null, rowIndex);
            model.setValue("e_score", null, rowIndex);
            model.setValue("e_level", null, rowIndex);
            model.setValue("e_leveldesc", null, rowIndex);
            int[] peakRange = OccurPossibilityHelper.getPeakRange();
            if (peakRange.length == 0) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u53d1\u751f\u53ef\u80fd\u6027\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskEvalEdit_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            } else {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u53d1\u751f\u53ef\u80fd\u6027\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4(%1$s,%2$s]\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskEvalEdit_1", (String)"data-rsa-formplugin", (Object[])new Object[0]), peakRange[0], peakRange[1]));
            }
            return;
        }
        model.setValue("e_occdesc", (Object)occDy.getString("name"), rowIndex);
    }

    private void updateEntryResData(int rowIndex, DynamicObject rowDataDy) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BigDecimal resultScore = rowDataDy.getBigDecimal("e_resultscore");
        DynamicObject resDy = ResultEffectHelper.getSingle((BigDecimal)resultScore);
        if (resDy == null) {
            model.setValue("e_resultscore", null, rowIndex);
            model.setValue("e_resultdesc", null, rowIndex);
            model.setValue("e_score", null, rowIndex);
            model.setValue("e_level", null, rowIndex);
            model.setValue("e_leveldesc", null, rowIndex);
            int[] peakRange = ResultEffectHelper.getPeakRange();
            if (peakRange.length == 0) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u540e\u679c\u5f71\u54cd\u7a0b\u5ea6\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskEvalEdit_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            } else {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u503c\u4e0d\u5728\u540e\u679c\u5f71\u54cd\u7a0b\u5ea6\u7684\u8bc4\u4f30\u5206\u6570\u8303\u56f4(%1$s,%2$s]\u5185\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskEvalEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0]), peakRange[0], peakRange[1]));
            }
            return;
        }
        model.setValue("e_resultdesc", (Object)resDy.getString("name"), rowIndex);
    }

    private void updateEntryScoreAndLevel(int rowIndex, DynamicObject rowDataDy) {
        IDataModel model = this.getModel();
        BigDecimal resultScore = rowDataDy.getBigDecimal("e_resultscore");
        DynamicObject resDy = ResultEffectHelper.getSingle((BigDecimal)resultScore);
        if (resDy == null) {
            return;
        }
        BigDecimal occScore = rowDataDy.getBigDecimal("e_occscore");
        DynamicObject occDy = OccurPossibilityHelper.getSingle((BigDecimal)occScore);
        if (occDy == null) {
            return;
        }
        model.setValue("e_score", (Object)occScore.multiply(resultScore), rowIndex);
        DynamicObject riskLevelEvaDy = RiskLevelEvalCriteriaHelper.getSingle((Long)occDy.getLong("id"), (Long)resDy.getLong("id"));
        if (riskLevelEvaDy == null || riskLevelEvaDy.get("risklevelid") == null) {
            model.setValue("e_level", null, rowIndex);
            model.setValue("e_leveldesc", null, rowIndex);
            return;
        }
        model.setValue("e_level", (Object)riskLevelEvaDy.getLong("risklevelid.id"), rowIndex);
        model.setValue("e_leveldesc", (Object)riskLevelEvaDy.getString("risklevelid.name"), rowIndex);
    }
}

