/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.rsa.enums.RiskEventStatusEnum;
import kd.data.rsa.enums.RiskNumericalUnitEnum;
import kd.data.rsa.formplugin.helper.DimensionValueHelper;
import kd.data.rsa.formplugin.model.DimensionColumn;
import kd.data.rsa.formplugin.risksetting.EventHandleFormPlugin;

public class RiskEventEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_ORG = "org";
    private static final String FIELD_PERIOD = "period";
    private static final String FIELD_FASINDEX = "fasindex";
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_RANG = "rang";
    private static final String FIELD_OTHERDIMENSIONVALUE = "otherdimensionvalue_tag";
    private static final String FIELD_DISPLAYORG = "displayorg";
    private static final String FIELD_DISPLAYPERIOD = "displayperiod";
    private static final String FIELD_DISPLAYFASINDEX = "displayfasindex";
    private static final String FIELD_DISPLAYFASINDEXTEXT = "displayfasindextext";
    private static final String FIELD_DISPLAYVALUE = "displayvalue";
    private static final String FIELD_DISPLAYRANG = "displayrang";
    private static final String FIELD_DISPLAYUNIT = "displayunit";
    private static final String FIELD_UNIT = "unit";
    private static final String ACTION_PROCESS = "process";
    private static final String OTHERDIMENSION = "otherdimension";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{OTHERDIMENSION});
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (OTHERDIMENSION.equals(key)) {
            LargeTextEdit control = new LargeTextEdit(){

                public void detailClick(Map<String, Object> args) {
                    RiskEventEdit.this.jumpToOtherDimensionForm();
                }
            };
            control.setKey(OTHERDIMENSION);
            control.setModel(this.getModel());
            control.setView(this.getView());
            e.setControl((Control)control);
        }
    }

    private void jumpToOtherDimensionForm() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("rsa_otherdimension");
        fsp.setCaption(ResManager.loadKDString((String)"\u5176\u4ed6\u7edf\u8ba1\u7ef4\u5ea6", (String)"RiskEventEdit_7", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam(OTHERDIMENSION, (Object)((String)this.getModel().getValue("otherdimension_tag", rowIndex)));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openOtherDimension"));
        this.getView().showForm(fsp);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryEntity = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryEntity.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject riskEvent;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("createriskwork".equals(operateKey) && (riskEvent = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModel().getValue("id"), (String)"rsa_riskevent")) != null && "3".equals(riskEvent.get("status"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u9884\u8b66\u5df2\u5173\u95ed\u3002", (String)"RiskEventEdit_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("closewarn".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            Map billNos = operationResult.getBillNos();
            Object pkid = billNos.keySet().iterator().next();
            DynamicObject riskEvent = QueryServiceHelper.queryOne((String)"rsa_riskevent", (String)"status, billno", (QFilter[])new QFilter[]{new QFilter("id", "=", pkid)});
            if (riskEvent == null) {
                return;
            }
            if (RiskEventStatusEnum.CLOSE.getCode().equals(riskEvent.getString("status"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u9884\u8b66\u5df2\u5173\u95ed\u3002", (String)"RiskEventEdit_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                return;
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("rsa_closeevent");
            fsp.setCaption(ResManager.loadKDString((String)"\u5173\u95ed\u9884\u8b66", (String)"RiskEventEdit_8", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            fsp.setCustomParam("pkid", (Object)SerializationUtils.toJsonString(billNos.keySet()));
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object billId = billShowParameter.getPkId();
        MainEntityType type = e.getOriginalEntityType();
        try {
            MainEntityType newType = (MainEntityType)type.clone();
            e.setNewEntityType(newType);
            if (billId == null) {
                return;
            }
            DynamicObject currentBill = QueryServiceHelper.queryOne((String)"rsa_riskevent", (String)FIELD_OTHERDIMENSIONVALUE, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(billId.toString()))});
            String otherDimensionValue = currentBill.getString(FIELD_OTHERDIMENSIONVALUE);
            List<DimensionColumn> customerColumn = this.processDimension(otherDimensionValue);
            this.buildColumnProp(customerColumn, newType);
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public void afterLoadData(EventObject e) {
        String upper;
        IDataModel model = this.getModel();
        String string = upper = model.getValue("upper") == null ? "1" : model.getValue("upper").toString();
        if ("1".equals(upper)) {
            String otherDimensionValue = (String)model.getValue(FIELD_OTHERDIMENSIONVALUE);
            List<DimensionColumn> columnList = this.processDimension(otherDimensionValue);
            this.drawColumn(columnList);
            this.buildEdit(columnList);
            DynamicObject fasIndex = (DynamicObject)model.getValue(FIELD_FASINDEX);
            int entryRowCount = model.getEntryRowCount(ENTRY_ENTITY);
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject org = (DynamicObject)model.getValue(FIELD_ORG);
                model.setValue(FIELD_DISPLAYORG, org.get("name"), i);
                model.setValue(FIELD_DISPLAYFASINDEXTEXT, (Object)(fasIndex == null ? " " : fasIndex.getString("name")));
                String numeriCalunit = model.getValue("numericalunit").toString();
                if (StringUtils.isNotEmpty((String)numeriCalunit) && !"0".equals(numeriCalunit) && RiskNumericalUnitEnum.getEnum((String)numeriCalunit) != null) {
                    model.setValue(FIELD_UNIT, (Object)RiskNumericalUnitEnum.getEnum((String)numeriCalunit).getName(), i);
                }
                BigDecimal value = new BigDecimal(model.getValue(FIELD_DISPLAYVALUE, i) == null || StringUtils.isEmpty((String)model.getValue(FIELD_DISPLAYVALUE, i).toString()) ? "0" : model.getValue(FIELD_DISPLAYVALUE, i).toString());
                model.setValue(FIELD_DISPLAYVALUE, (Object)value, i);
                this.setColumnValue(columnList, i);
            }
            this.getModel().setDataChanged(false);
        }
        DynamicObjectCollection entry = model.getEntryEntity("remarkentryentity");
        for (int i = 0; i < entry.size() - 1; ++i) {
            for (int j = 0; j < entry.size() - 1; ++j) {
                Date date1;
                Date date = ((DynamicObject)entry.get(j)).getDate("remarkdate");
                if (!date.before(date1 = ((DynamicObject)entry.get(j + 1)).getDate("remarkdate"))) continue;
                model.moveEntryRowDown("remarkentryentity", j);
            }
        }
        this.getView().updateView("remarkentryentity");
    }

    public void buildEdit(List<DimensionColumn> columnList) {
        if (columnList == null || columnList.isEmpty()) {
            return;
        }
        Container control = (Container)this.getControl(ENTRY_ENTITY);
        IFormView view = this.getView();
        IDataModel dataModel = this.getModel();
        ArrayList<Control> list = new ArrayList<Control>(columnList.size());
        MainEntityType mainType = this.getModel().getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        for (DimensionColumn column : columnList) {
            LocaleString name = new LocaleString(column.getName());
            String key = column.getKey();
            list.add(this.buildTextFieldRuntimeMeta(control, key, name, dataModel, view, entityMeta));
        }
        if (!list.isEmpty()) {
            view.createControlIndex(list);
        }
    }

    private Control buildTextFieldRuntimeMeta(Container entryCon, String key, LocaleString name, IDataModel dataModel, IFormView view, EntityMetadata entityMeta) {
        EntryFieldAp entryFieldAp = new EntryFieldAp();
        entryFieldAp.setKey(key);
        entryFieldAp.setWidth(new LocaleString("100px"));
        entryFieldAp.setName(name);
        TextField textField = new TextField();
        textField.setName(name);
        textField.setKey(key);
        entryFieldAp.setField((Field)textField);
        TextEdit bsEdit = (TextEdit)entryFieldAp.buildRuntimeControl();
        bsEdit.setFieldKey(key);
        bsEdit.setModel(dataModel);
        bsEdit.setView(view);
        bsEdit.setEntryKey(ENTRY_ENTITY);
        entryCon.getItems().add(bsEdit);
        return bsEdit;
    }

    private List<DimensionColumn> processDimension(String otherDimensionValue) {
        List<DimensionColumn> cacheColumn = this.getDimensionColumn();
        if (cacheColumn != null && !cacheColumn.isEmpty()) {
            return cacheColumn;
        }
        List<DimensionColumn> dimensionColumnList = this.doProcessDimension(otherDimensionValue);
        this.setDimensionColumn(dimensionColumnList);
        return dimensionColumnList;
    }

    private List<DimensionColumn> doProcessDimension(String otherDimensionValue) {
        return DimensionValueHelper.processInEdit(otherDimensionValue, false);
    }

    private List<DimensionColumn> getDimensionColumn() {
        String columnStr = this.getPageCache().get("dimensionColumn");
        if (StringUtils.isEmpty((String)columnStr)) {
            return null;
        }
        return JSON.parseArray((String)columnStr, DimensionColumn.class);
    }

    private void setDimensionColumn(List<DimensionColumn> dimensionColumnList) {
        if (dimensionColumnList == null || dimensionColumnList.isEmpty()) {
            return;
        }
        String columnStr = JSON.toJSONString(dimensionColumnList);
        this.getPageCache().put("dimensionColumn", columnStr);
    }

    private void setColumnValue(List<DimensionColumn> columnList, int rowIndex) {
        if (columnList == null || columnList.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        for (DimensionColumn dimensionColumn : columnList) {
            model.setValue(dimensionColumn.getKey(), dimensionColumn.getValue(), rowIndex);
        }
    }

    private void buildColumnProp(List<DimensionColumn> columnList, MainEntityType mainEntityType) throws CloneNotSupportedException {
        if (columnList == null || columnList.isEmpty()) {
            return;
        }
        IDataEntityProperty prop = mainEntityType.findProperty(ENTRY_ENTITY);
        EntryProp entryProp = (EntryProp)prop;
        DataEntityPropertyCollection propertyCollection = entryProp._collectionItemPropertyType.getProperties();
        IDataEntityProperty templateProp = (IDataEntityProperty)propertyCollection.get((Object)FIELD_DISPLAYRANG);
        for (DimensionColumn dimensionColumn : columnList) {
            TextProp textProp = (TextProp)templateProp.clone();
            textProp.setName(dimensionColumn.getKey());
            textProp.setDisplayName(new LocaleString(dimensionColumn.getName()));
            propertyCollection.add((Object)textProp);
        }
        mainEntityType.createPropIndexsNoCache();
    }

    public void drawColumn(List<DimensionColumn> columnList) {
        if (columnList == null || columnList.isEmpty()) {
            return;
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        Map<String, Object> map = this.genEntryEntity(columnList);
        clientViewProxy.preInvokeControlMethod(ENTRY_ENTITY, "createGridColumns", new Object[]{map});
    }

    private Map<String, Object> genEntryEntity(List<DimensionColumn> columnList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rk", "rk");
        map.put("fseq", "fseq");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (columnList != null && !columnList.isEmpty()) {
            for (DimensionColumn columnObject : columnList) {
                String name = columnObject.getName();
                String key = columnObject.getKey();
                Map<String, Object> editMap = this.genTextEditor();
                list.add(this.genColumn(key, name, editMap, false));
            }
        }
        Map<String, String> fixMap = this.getFixColumn();
        Set<Map.Entry<String, String>> entrySet = fixMap.entrySet();
        ArrayList<Map<String, Object>> fixColumnList = new ArrayList<Map<String, Object>>(fixMap.size() * 2);
        fixColumnList.add(this.genRKColumn());
        fixColumnList.add(this.genSeqColumn());
        for (Map.Entry<String, String> entry : entrySet) {
            String name = entry.getValue();
            String key = entry.getKey();
            Map<String, Object> editMap = this.genTextEditor();
            Map<String, Object> stringObjectMap = this.genColumn(key, name, editMap, FIELD_DISPLAYVALUE.equals(key));
            fixColumnList.add(stringObjectMap);
        }
        fixColumnList.addAll(list);
        map.put("columns", fixColumnList);
        return map;
    }

    private Map<String, String> getFixColumn() {
        String unitCode = this.getModel().getValue("numericalunit").toString();
        LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>(6);
        columnMap.put(FIELD_DISPLAYORG, ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"RiskEventEdit_9", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        columnMap.put(FIELD_DISPLAYPERIOD, ResManager.loadKDString((String)"\u671f\u95f4", (String)"RiskEventEdit_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        columnMap.put(FIELD_DISPLAYFASINDEXTEXT, ResManager.loadKDString((String)"\u6307\u6807", (String)"RiskEventEdit_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        columnMap.put(FIELD_DISPLAYVALUE, ResManager.loadKDString((String)"\u6307\u6807\u503c", (String)"RiskEventEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        if (StringUtils.isNotEmpty((String)unitCode) && !"0".equals(unitCode)) {
            columnMap.put(FIELD_UNIT, ResManager.loadKDString((String)"\u5355\u4f4d", (String)"RiskEventEdit_5", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        }
        columnMap.put(FIELD_DISPLAYRANG, ResManager.loadKDString((String)"\u98ce\u9669\u7b49\u7ea7\u503c\u8303\u56f4", (String)"RiskEventEdit_4", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        return columnMap;
    }

    private Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", "fseq");
        map.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"RiskEventEdit_6", (String)"data-rsa-formplugin", (Object[])new Object[0])));
        map.put("isColPageFixed", true);
        map.put("visible", false);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    private Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", "rk");
        map.put("header", new LocaleString("rk"));
        map.put("visible", false);
        map.put("width", 50);
        return map;
    }

    private Map<String, Object> genColumn(String key, String name, Map<String, Object> editor, boolean isNumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", key);
        map.put("filter", true);
        map.put("l", 0);
        map.put("vi", 63);
        map.put("sort", false);
        map.put("w", new LocaleString("100px"));
        if ("accountingorg".equals(key)) {
            map.put("w", new LocaleString("200px"));
        }
        map.put("header", new LocaleString(name));
        map.put("editor", editor);
        if (isNumber) {
            map.put("text-align", "right");
        }
        return map;
    }

    private Map<String, Object> genTextEditor() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxlength", 255);
        map.put("minlength", 0);
        map.put("mi", false);
        map.put("type", "text");
        return map;
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (ACTION_PROCESS.equals(key)) {
            Object pk = this.getModel().getValue("id");
            Object orgId = this.getModel().getValue("org_id");
            DynamicObject riskEvent = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"rsa_riskevent");
            if (RiskEventStatusEnum.CLOSE.getCode().equals(riskEvent.getString("status"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5bf9\u672a\u5904\u7406\u548c\u5904\u7406\u4e2d\u4e8b\u4ef6\u505a\u72b6\u6001\u6807\u6ce8\u3002", (String)"RiskEventEdit_12", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                return;
            }
            if (pk != null && orgId != null) {
                EventHandleFormPlugin.openHandle(new Object[]{pk}, (AbstractFormPlugin)this, ACTION_PROCESS, (Long)orgId);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (ACTION_PROCESS.equals(actionId) && "btnok".equals(returnData)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6807\u6ce8\u6210\u529f\u3002", (String)"RiskEventEdit_10", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else if ("closewarn".equals(actionId)) {
            returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                DynamicObject[] load;
                Map returnDataMap = (Map)closedCallBackEvent.getReturnData();
                Set pkIds = (Set)SerializationUtils.fromJsonString((String)returnDataMap.get("pkid").toString(), Set.class);
                String closeExplain = returnDataMap.get("closeexplain").toString();
                for (DynamicObject dyn : load = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"rsa_riskevent"))) {
                    dyn.set("status", (Object)RiskEventStatusEnum.CLOSE.getCode());
                    DynamicObjectCollection remarkEntryEntity = dyn.getDynamicObjectCollection("remarkentryentity");
                    DynamicObject entry = new DynamicObject(remarkEntryEntity.getDynamicObjectType());
                    entry.set("remarkstatus", (Object)RiskEventStatusEnum.CLOSE.getCode());
                    entry.set("processremark", (Object)closeExplain);
                    entry.set("remarkdate", (Object)new Date());
                    entry.set("remarkuser", (Object)RequestContext.get().getCurrUserId());
                    remarkEntryEntity.add((Object)entry);
                }
                SaveServiceHelper.save((DynamicObject[])load);
                this.getView().invokeOperation("refresh");
            }
        } else {
            super.closedCallBack(closedCallBackEvent);
        }
    }
}

