/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.data.rsa.formplugin.risksetting.BillTreeListPlugin;

public class RiskGroupTreeListPlugin
extends BillTreeListPlugin
implements TreeNodeCheckListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshTreeNode(null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (this.getTreeModel().getCurrentNodeId() != null) {
            String currentNodeId = this.getTreeModel().getCurrentNodeId().toString();
            if (this.getTreeModel().getRoot().getId().equals(currentNodeId)) {
                return;
            }
            ArrayList<Long> nodeIds = new ArrayList<Long>(10);
            nodeIds.add(Long.parseLong(currentNodeId));
            TreeNode currentNode = this.treeListView.getTreeModel().getRoot().getTreeNode(currentNodeId);
            if (currentNode == null) {
                e.getQFilters().add(new QFilter("group", "is null", null));
            } else {
                this.getChildId(nodeIds, currentNode);
                e.getQFilters().add(new QFilter("group", "in", nodeIds));
            }
        }
    }

    private void getChildId(List<Long> nodeIds, TreeNode node) {
        List children = node.getChildren();
        if (children != null && children.size() > 0) {
            for (TreeNode child : children) {
                nodeIds.add(Long.parseLong(child.getId()));
                this.getChildId(nodeIds, child);
            }
        }
    }

    @Override
    public void treeToolbarClick(EventObject e) {
        TreeNode root;
        int nodeLevel;
        Control ctl = (Control)e.getSource();
        ITreeModel treeModel = this.getTreeModel();
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        if (ctl.getKey().equals("btnnew") && (nodeLevel = (root = treeModel.getRoot()).getNodeLevel(currentNodeId, 1)) >= 4) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u7c7b\u522b\u6700\u591a\u53ea\u652f\u63013\u4e2a\u5c42\u7ea7\u3002", (String)"RiskGroupTreeListPlugin_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        super.treeToolbarClick(e);
    }
}

