/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.data.rsa.enums.RiskNumericalUnitEnum;
import kd.data.rsa.external.FasindexHelper;

public class RiskItemEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String FIELD_FASINDEX = "fasindex";
    private static final String FIELD_DEFAULTDIMENSION = "defaultdimension";
    private static final String FIELD_OTHERDIMENSION = "otherdimension";
    private static final String FIELD_MODEL = "model";
    private static final String FIELD_CREATEORG = "createorg";
    private static final String CONTROL_PREVIEW = "preview";
    private static final String FIELD_END = "end";
    private static final String FIELD_START = "start";
    private static final String FIELD_NUMERICALUNIT = "numericalunit";
    private static final String FIELD_FASINDEXUNIT = "fasindexunit";
    private static final String FIELD_VALUETYPE = "valuetype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit defaultDimension = (BasedataEdit)this.getControl(FIELD_DEFAULTDIMENSION);
        defaultDimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit otherDimension = (BasedataEdit)this.getControl(FIELD_OTHERDIMENSION);
        otherDimension.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fasindex = (BasedataEdit)this.getControl(FIELD_FASINDEX);
        fasindex.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCopyData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_NUMERICALUNIT, FIELD_FASINDEXUNIT});
        this.unitControl(((DynamicObject)this.getModel().getValue(FIELD_FASINDEX)).getString("unitcategory"));
    }

    public void afterCreateNewData(EventObject e) {
        Object fasindex = this.getModel().getValue(FIELD_FASINDEX);
        if (fasindex == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_VALUETYPE});
        }
        String[] fields = this.getNonEditField(true);
        this.nonEditable(fields);
        this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_NUMERICALUNIT, FIELD_FASINDEXUNIT});
    }

    private String[] getNonEditField(boolean isNew) {
        String[] stringArray;
        if (isNew) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = "group";
            stringArray2[1] = FIELD_CREATEORG;
            stringArray2[2] = FIELD_DEFAULTDIMENSION;
            stringArray2[3] = FIELD_MODEL;
            stringArray2[4] = "ctrlstrategy";
            stringArray = stringArray2;
            stringArray2[5] = FIELD_FASINDEXUNIT;
        } else {
            String[] stringArray3 = new String[9];
            stringArray3[0] = "number";
            stringArray3[1] = FIELD_FASINDEX;
            stringArray3[2] = "group";
            stringArray3[3] = FIELD_CREATEORG;
            stringArray3[4] = FIELD_DEFAULTDIMENSION;
            stringArray3[5] = FIELD_MODEL;
            stringArray3[6] = "ctrlstrategy";
            stringArray3[7] = FIELD_VALUETYPE;
            stringArray = stringArray3;
            stringArray3[8] = FIELD_FASINDEXUNIT;
        }
        return stringArray;
    }

    public void afterLoadData(EventObject e) {
        Long id = (Long)this.getModel().getValue("id");
        if (id > 0L && QueryServiceHelper.exists((String)"rsa_riskevent", (QFilter[])new QFilter[]{new QFilter("riskitem", "=", (Object)id)})) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number", FIELD_FASINDEX, FIELD_VALUETYPE});
            String[] fields = this.getNonEditField(false);
            this.nonEditable(fields);
        }
        this.unitControl(((DynamicObject)this.getModel().getValue(FIELD_FASINDEX)).getString("unitcategory"));
    }

    private void nonEditable(String[] fields) {
        for (String field : fields) {
            HashMap<String, Object> cssMap = new HashMap<String, Object>(3);
            cssMap.put("id", field);
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("fc", "#b2b2b2");
            cssMap.put("item", itemMap);
            this.getView().updateControlMetadata(field, cssMap);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (CONTROL_PREVIEW.equals(evt.getItemKey())) {
            this.showFasIndexPreviewForm();
        }
    }

    private void showFasIndexPreviewForm() {
        DynamicObject fasindex = (DynamicObject)this.getModel().getValue(FIELD_FASINDEX);
        if (fasindex == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6307\u6807", (String)"RiskItemEdit_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject createorg = (DynamicObject)this.getModel().getValue(FIELD_CREATEORG);
        if (createorg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7", (String)"RiskItemEdit_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportShowParameter fsp = new ReportShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setFormId("pa_fasindex_testcalculate");
        fsp.setCustomParam(FIELD_FASINDEX, fasindex.getPkValue());
        fsp.setCustomParam("useOrgId", (Object)String.valueOf(createorg.getPkValue()));
        this.getView().showForm((FormShowParameter)fsp);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (FIELD_FASINDEX.equals(property)) {
            this.changFasindex((DynamicObject)newValue);
        } else if (FIELD_NUMERICALUNIT.equals(property)) {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("unit", this.getModel().getValue(FIELD_NUMERICALUNIT), i);
            }
        } else if (FIELD_VALUETYPE.equals(property)) {
            String unitCategory = ((DynamicObject)this.getModel().getValue(FIELD_FASINDEX)).getString("unitcategory");
            if ("01".equals(newValue) || "03".equals(newValue)) {
                if ("1".equals(unitCategory)) {
                    ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_NUMERICALUNIT);
                    ArrayList<ComboItem> data = new ArrayList<ComboItem>(5);
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e0", (String)"RiskItemEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.NULL.getCode()));
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5343", (String)"RiskItemEdit_4", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.THOUSAND.getCode()));
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e07", (String)"RiskItemEdit_5", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.TENTHOUSAND.getCode()));
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ebf", (String)"RiskItemEdit_6", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.HUNDREDMILLION.getCode()));
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"RiskItemEdit_7", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.PERCENTAGE.getCode()));
                    comboEdit.setComboItems(data);
                } else if ("2".equals(unitCategory)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_NUMERICALUNIT});
                }
                this.getModel().setValue(FIELD_NUMERICALUNIT, (Object)RiskNumericalUnitEnum.PERCENTAGE.getCode());
            } else if ("1".equals(unitCategory)) {
                ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_NUMERICALUNIT);
                ArrayList<ComboItem> data = new ArrayList<ComboItem>(5);
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e0", (String)"RiskItemEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.NULL.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5343", (String)"RiskItemEdit_4", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.THOUSAND.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e07", (String)"RiskItemEdit_5", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.TENTHOUSAND.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ebf", (String)"RiskItemEdit_6", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.HUNDREDMILLION.getCode()));
                comboEdit.setComboItems(data);
                this.getModel().setValue(FIELD_NUMERICALUNIT, (Object)RiskNumericalUnitEnum.NULL.getCode());
            } else if ("2".equals(unitCategory)) {
                this.getModel().setValue(FIELD_NUMERICALUNIT, (Object)RiskNumericalUnitEnum.NULL.getCode());
                this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_NUMERICALUNIT});
            }
        }
    }

    private void changFasindex(DynamicObject newFasindex) {
        this.getModel().setValue(FIELD_OTHERDIMENSION, null);
        if (newFasindex != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{FIELD_VALUETYPE});
            Object pk = newFasindex.get("system_id");
            this.getModel().setValue(FIELD_MODEL, pk);
            DynamicObject org = (DynamicObject)this.getModel().getValue(FIELD_CREATEORG);
            List dimensionIdList = FasindexHelper.getNecessityDimensionFromFsaindex((long)((Long)newFasindex.getPkValue()), (long)org.getLong("id"));
            Object[] ids = dimensionIdList.toArray(new Object[0]);
            this.getModel().setValue(FIELD_DEFAULTDIMENSION, (Object)ids);
            String unitcategory = newFasindex.getString("unitcategory");
            this.getModel().setValue(FIELD_NUMERICALUNIT, (Object)RiskNumericalUnitEnum.NULL.getCode());
            this.getModel().setValue(FIELD_VALUETYPE, (Object)"00");
            this.unitControl(unitcategory);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{FIELD_VALUETYPE});
            this.getModel().setValue(FIELD_DEFAULTDIMENSION, null);
            this.getModel().setValue(FIELD_MODEL, null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName;
        IDataEntityProperty property = beforeF7SelectEvent.getProperty();
        switch (propertyName = property.getName()) {
            case "defaultdimension": 
            case "otherdimension": {
                DynamicObject fasindex = (DynamicObject)this.getModel().getValue(FIELD_FASINDEX);
                if (fasindex == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6307\u6807", (String)"RiskItemEdit_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter filter = this.getFasindexFilter(fasindex, propertyName);
                if (filter != null) {
                    beforeF7SelectEvent.addCustomQFilter(filter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ef4\u5ea6", (String)"RiskItemEdit_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "fasindex": {
                List appIdList = QueryServiceHelper.queryPrimaryKeys((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)"0N9BMKTGBIA0")}, null, (int)-1);
                appIdList.add("0N9BMKTGBIA0");
                List modelIdList = QueryServiceHelper.queryPrimaryKeys((String)"pa_anasystemsetting", (QFilter[])new QFilter[]{new QFilter("modulerange", "in", (Object)appIdList.toArray(new Object[0]))}, null, (int)-1);
                beforeF7SelectEvent.addCustomQFilter(new QFilter("system", "in", (Object)modelIdList));
            }
        }
    }

    private QFilter getFasindexFilter(DynamicObject fasindex, String propertyName) {
        List idList;
        if (fasindex == null) {
            return null;
        }
        long fasindexId = (Long)fasindex.getPkValue();
        DynamicObject org = (DynamicObject)this.getModel().getValue(FIELD_CREATEORG);
        long orgId = org.getLong("id");
        List list = idList = FIELD_DEFAULTDIMENSION.equals(propertyName) ? FasindexHelper.getNecessityDimensionFromFsaindex((long)fasindexId, (long)orgId) : FasindexHelper.getDimensionFromFsaindex((long)fasindexId, (long)orgId);
        if (idList == null || idList.isEmpty()) {
            return null;
        }
        return new QFilter("id", "in", (Object)idList);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        int currentRowIndex;
        if ("newentry".equals(afterDoOperationEventArgs.getOperateKey()) && (currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity")) > 0) {
            Object endValue = this.getModel().getValue(FIELD_END, currentRowIndex - 1);
            this.getModel().setValue(FIELD_START, endValue, currentRowIndex);
        }
        if (afterDoOperationEventArgs.getSource() instanceof NewEntry) {
            this.getModel().setValue("unit", this.getModel().getValue(FIELD_NUMERICALUNIT));
        }
    }

    private void changeItemCaption(String caption) {
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>(1);
        map.put("caption", new LocaleString(caption));
        this.getView().updateControlMetadata(FIELD_FASINDEXUNIT, map);
    }

    public void unitControl(String unitcategory) {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue("unit", this.getModel().getValue(FIELD_NUMERICALUNIT), i);
        }
        if (unitcategory == null) {
            return;
        }
        String valuetype = this.getModel().getValue(FIELD_VALUETYPE).toString();
        switch (unitcategory) {
            case "1": {
                this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_NUMERICALUNIT, FIELD_FASINDEXUNIT});
                ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_NUMERICALUNIT);
                ArrayList<ComboItem> data = new ArrayList<ComboItem>();
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e0", (String)"RiskItemEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.NULL.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5343", (String)"RiskItemEdit_4", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.THOUSAND.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e07", (String)"RiskItemEdit_5", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.TENTHOUSAND.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ebf", (String)"RiskItemEdit_6", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.HUNDREDMILLION.getCode()));
                if ("01".equals(valuetype) || "03".equals(valuetype)) {
                    data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"RiskItemEdit_7", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.PERCENTAGE.getCode()));
                }
                comboEdit.setComboItems(data);
                this.changeItemCaption(ResManager.loadKDString((String)"\u6307\u6807\u5e01\u522b", (String)"RiskItemEdit_9", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                break;
            }
            case "0": {
                this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_NUMERICALUNIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_FASINDEXUNIT});
                ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_NUMERICALUNIT);
                ArrayList<ComboItem> data = new ArrayList<ComboItem>();
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e0", (String)"RiskItemEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.NULL.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5343", (String)"RiskItemEdit_4", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.THOUSAND.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e07", (String)"RiskItemEdit_5", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.TENTHOUSAND.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4ebf", (String)"RiskItemEdit_6", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.HUNDREDMILLION.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"RiskItemEdit_7", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.PERCENTAGE.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5343\u5206\u6bd4", (String)"RiskItemEdit_8", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.PERMILLAGE.getCode()));
                comboEdit.setComboItems(data);
                break;
            }
            case "2": {
                if ("01".equals(valuetype) || "03".equals(valuetype)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_NUMERICALUNIT});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{FIELD_NUMERICALUNIT});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{FIELD_FASINDEXUNIT});
                ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD_NUMERICALUNIT);
                ArrayList<ComboItem> data = new ArrayList<ComboItem>();
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e0", (String)"RiskItemEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.NULL.getCode()));
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"RiskItemEdit_7", (String)"data-rsa-formplugin", (Object[])new Object[0])), RiskNumericalUnitEnum.PERCENTAGE.getCode()));
                comboEdit.setComboItems(data);
                this.changeItemCaption(ResManager.loadKDString((String)"\u6307\u6807\u5355\u4f4d", (String)"RiskItemEdit_10", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }
}

