/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class RiskLevelEvaCriteriaEdit
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final MainEntityType DATAENTITYTYPE = EntityMetadataCache.getDataEntityType((String)"rsa_risklevelevacriteria");

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.saveRefresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("saveentry")) {
            IDataModel model = this.getModel();
            int entryRowCount = model.getEntryRowCount(ENTRY_ENTITY);
            HashSet<Integer> deleteIndexSet = new HashSet<Integer>(entryRowCount);
            ArrayList<Long> deleteIds = new ArrayList<Long>(entryRowCount);
            for (int i = 0; i < entryRowCount; ++i) {
                if (model.getValue("occurpossibility", i) != null || model.getValue("resulteffect", i) != null) continue;
                deleteIndexSet.add(i);
                Object id = this.getModel().getValue("evacriteria_id", i);
                if (Long.parseLong(id.toString()) == 0L) continue;
                deleteIds.add((Long)id);
            }
            if (!deleteIndexSet.isEmpty()) {
                this.getPageCache().put("deleterow", JSON.toJSONString(deleteIds));
                model.beginInit();
                model.deleteEntryRows(ENTRY_ENTITY, deleteIndexSet.stream().mapToInt(Integer::valueOf).toArray());
                model.endInit();
                this.getView().updateView(ENTRY_ENTITY);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        Object source = event.getSource();
        if (source instanceof Donothing && "saveentry".equals(((Donothing)source).getOperateKey())) {
            OperationResult operationResult = event.getOperationResult();
            String message = operationResult.getMessage();
            if (message != null) {
                return;
            }
            try (TXHandle h = TX.required((String)"rsa_risklevelevacriteria_savedata");){
                try {
                    this.saveEntryData();
                }
                catch (Exception e) {
                    h.markRollback();
                    throw new KDBizException(e.getMessage());
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"RiskLevelEvaCriteriaEdit_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            this.saveRefresh();
        } else if (source instanceof Refresh) {
            this.saveRefresh();
        } else if (source instanceof Donothing && "deleteentry".equals(((Donothing)source).getOperateKey())) {
            int[] selectRows;
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            String deleteRow = this.getPageCache().get("deleterow");
            ArrayList<Long> deleteIds = StringUtils.isNotEmpty((String)deleteRow) ? (ArrayList<Long>)JSON.parseObject((String)deleteRow, List.class) : new ArrayList<Long>(10);
            for (int selectRow : selectRows = entryGrid.getSelectRows()) {
                Object id = this.getModel().getValue("evacriteria_id", selectRow);
                if (Long.parseLong(id.toString()) == 0L) continue;
                deleteIds.add((Long)id);
            }
            this.getModel().deleteEntryRows(ENTRY_ENTITY, selectRows);
            this.getPageCache().put("deleterow", JSON.toJSONString(deleteIds));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        String name = e.getProperty().getName();
        if ("2".equals(model.getValue("ifmodify", rowIndex)) && ("occurpossibility".equals(name) || "resulteffect".equals(name) || "risklevel".equals(name)) && changeSet.length == 1) {
            this.getModel().setValue("ifmodify", (Object)"1", rowIndex);
        }
    }

    private void saveEntryData() {
        List deleteList;
        String deleteRow;
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount(ENTRY_ENTITY);
        ArrayList<DynamicObject> saveDyn = new ArrayList<DynamicObject>(entryRowCount);
        Map evacriteriaMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risklevelevacriteria", null);
        for (int i = 0; i < entryRowCount; ++i) {
            Object pkId;
            DynamicObject dyn;
            if (model.getValue("occurpossibility") == null) continue;
            if ("0".equals(model.getValue("ifmodify", i))) {
                DynamicObject dyn2 = new DynamicObject((DynamicObjectType)DATAENTITYTYPE);
                this.addDynObj(saveDyn, dyn2, i);
                continue;
            }
            if ("1".equals(model.getValue("ifmodify", i))) {
                Object pkId2 = ((DynamicObject)model.getValue("evacriteria", i)).get("id");
                DynamicObject dyn3 = (DynamicObject)evacriteriaMap.get(pkId2);
                if (dyn3 == null) continue;
                this.addDynObj(saveDyn, dyn3, i);
                continue;
            }
            if (!"2".equals(model.getValue("ifmodify", i))) continue;
            String number = ((DynamicObject)model.getValue("occurpossibility", i)).getString("scorefrom") + ((DynamicObject)model.getValue("resulteffect", i)).getString("scorefrom");
            if (((DynamicObject)model.getValue("evacriteria", i)).getString("number").equals(number) || (dyn = (DynamicObject)evacriteriaMap.get(pkId = ((DynamicObject)model.getValue("evacriteria", i)).get("id"))) == null) continue;
            dyn.set("number", (Object)number);
            saveDyn.add(dyn);
            this.addDynObj(saveDyn, dyn, i);
        }
        if (!saveDyn.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveDyn.toArray(new DynamicObject[0]));
        }
        if (StringUtils.isNotEmpty((String)(deleteRow = this.getPageCache().get("deleterow"))) && (deleteList = (List)JSON.parseObject((String)deleteRow, List.class)) != null && !deleteList.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)DATAENTITYTYPE, (Object[])deleteList.toArray(new Object[0]));
            this.getPageCache().remove("deleterow");
        }
    }

    private List<DynamicObject> addDynObj(List<DynamicObject> saveDyn, DynamicObject dyn, int entryIndex) {
        IDataModel model = this.getModel();
        DynamicObject occurpossibility = (DynamicObject)model.getValue("occurpossibility", entryIndex);
        DynamicObject resulteffect = (DynamicObject)model.getValue("resulteffect", entryIndex);
        String number = occurpossibility.getString("scorefrom") + resulteffect.getString("scorefrom");
        dyn.set("risklevelid", model.getValue("risklevel_id", entryIndex));
        dyn.set("number", (Object)number);
        dyn.set("occurpossibilityid", (Object)occurpossibility.getLong("id"));
        dyn.set("resulteffectid", (Object)resulteffect.getLong("id"));
        dyn.set("status", (Object)"C");
        dyn.set("enable", (Object)"1");
        saveDyn.add(dyn);
        return saveDyn;
    }

    private void saveRefresh() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Map rsaRisklevelevacriteria = BusinessDataServiceHelper.loadFromCache((String)"rsa_risklevelevacriteria", (String)"id, occurpossibilityid, resulteffectid, risklevelid", null, (String)"number desc");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("occurpossibility", new Object[0]);
        vs.addField("resulteffect", new Object[0]);
        vs.addField("risklevel", new Object[0]);
        vs.addField("evacriteria", new Object[0]);
        vs.addField("ifmodify", new Object[0]);
        for (DynamicObject value : rsaRisklevelevacriteria.values()) {
            vs.addRow(new Object[]{value.get("occurpossibilityid.id"), value.get("resulteffectid.id"), value.get("risklevelid.id"), value.get("id"), "2"});
        }
        model.beginInit();
        model.deleteEntryData(ENTRY_ENTITY);
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
        this.getModel().setDataChanged(false);
    }
}

