/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeBaseDataFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.data.rsa.formplugin.helper.ComboItemHelper;
import kd.data.rsa.formplugin.helper.FilterConditionHelper;
import kd.data.rsa.formplugin.risksetting.RiskGroupTreeListPlugin;
import kd.data.rsa.helper.OrgHelper;
import kd.data.rsa.helper.RiskHelper;

public class RiskList
extends RiskGroupTreeListPlugin {
    private static final Log logger = LogFactory.getLog(RiskList.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        String fieldName;
        super.filterContainerInit(args);
        List commonFilterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        List schemeFilterColumnList = args.getFilterContainerInitEvent().getSchemeFilterColumns();
        List permOrgList = OrgHelper.getPermOrgList((String)"rsa_risk", (String)"47150e89000000ac");
        QFilter idFilter = new QFilter("id", "in", (Object)permOrgList);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{idFilter});
        QFilter rangeFilter = new QFilter("apprange", "like", (Object)"%,0,%");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        Map riskLevelMap = BusinessDataServiceHelper.loadFromCache((String)"rsa_risklevel", (String)"id,name", (QFilter[])new QFilter[]{rangeFilter, enableFilter, statusFilter});
        for (FilterColumn filterColumn : commonFilterColumnList) {
            CommonFilterColumn commonFilterColumn;
            List<ComboItem> comboItemList;
            fieldName = filterColumn.getFieldName();
            if (StringUtils.equals((CharSequence)"dutyorg.name", (CharSequence)fieldName)) {
                comboItemList = ComboItemHelper.createComboItemList(orgMap.values());
                commonFilterColumn = (CommonFilterColumn)filterColumn;
                commonFilterColumn.setComboItems(comboItemList);
                FormShowParameter fsp = this.getView().getFormShowParameter();
                if ("riskCheckForm".equals(fsp.getCustomParam("riskCheckForm"))) {
                    filterColumn.setDefaultValue((String)fsp.getCustomParam("orgid"));
                }
            }
            if (!StringUtils.equals((CharSequence)"risklevel.name", (CharSequence)fieldName)) continue;
            comboItemList = ComboItemHelper.createComboItemList(riskLevelMap.values());
            commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setComboItems(comboItemList);
        }
        for (FilterColumn filterColumn : schemeFilterColumnList) {
            fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"dutyorg.name", (CharSequence)fieldName)) continue;
            List<String> idStrList = orgMap.values().stream().map(dy -> dy.getString("id")).collect(Collectors.toList());
            SimpleFilterRow idSimpleFilterRow = FilterConditionHelper.createBasicSimpleFilterRow("id", CompareTypeEnum.IN, idStrList);
            FilterCondition idFilterCondition = FilterConditionHelper.createBasicFilterCondition(Collections.singletonList(idSimpleFilterRow));
            if (!(filterColumn instanceof SchemeBaseDataFilterColumn)) continue;
            SchemeBaseDataFilterColumn schemeBaseDataFilterColumn = (SchemeBaseDataFilterColumn)filterColumn;
            schemeBaseDataFilterColumn.setFilter(idFilterCondition);
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        List orgIdList;
        super.setFilter(e);
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter == null) {
            return;
        }
        Object value = mainOrgQFilter.getValue();
        if (value instanceof List && !(orgIdList = (List)value).isEmpty()) {
            List subOrgList = OrgHelper.getSubOrgList((List)orgIdList);
            QFilter orgFilter = new QFilter("dutyorg.id", "in", (Object)subOrgList);
            e.setMainOrgQFilter(orgFilter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillOperationStatus billStatus = e.getParameter().getBillStatus();
        if (BillOperationStatus.ADDNEW == billStatus) {
            ControlFilters controlFilters;
            List orgIdList;
            BillShowParameter billShowParameter = e.getParameter();
            ITreeModel treeModel = this.getTreeModel();
            String currentNodeId = (String)treeModel.getCurrentNodeId();
            String rootId = treeModel.getRoot().getId();
            if (!StringUtils.equals((CharSequence)rootId, (CharSequence)currentNodeId)) {
                billShowParameter.setCustomParam("riskGroupId", (Object)currentNodeId);
            }
            if ((orgIdList = (controlFilters = ((IListView)this.getView()).getControlFilters()).getFilter("dutyorg.id")) != null && !orgIdList.isEmpty()) {
                String dutyOrgId = orgIdList.get(0).toString();
                billShowParameter.setCustomParam("orgId", (Object)dutyOrgId);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String message;
        String title;
        List closeRowList;
        String billStatus;
        ListSelectedRow row2;
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        IFormView view = this.getView();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"new", (CharSequence)operateKey)) {
            String appId;
            ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
            String dutyOrgIdStr = controlFilters.getFilter("dutyorg.id").stream().filter(idStr -> StringUtils.isNotEmpty((CharSequence)((String)idStr))).findFirst().orElse(null);
            if (StringUtils.isEmpty((CharSequence)dutyOrgIdStr)) {
                return;
            }
            Long dutyOrgId = Long.valueOf(dutyOrgIdStr);
            Long curUserId = RequestContext.get().getCurrUserId();
            int newRiskResult = PermissionServiceHelper.checkPermission((Long)curUserId, (Long)dutyOrgId, (String)(appId = AppMetadataCache.getAppInfo((String)"rsa").getAppId()), (String)"rsa_risk", (String)"47156aff000000ac");
            if (newRiskResult == 0) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u98ce\u9669\u5355\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RiskList_12", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"push", (CharSequence)operateKey) && (selectedRows = this.getSelectedRows()).size() > 1) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u98ce\u9669\u4e0b\u63a8\u751f\u6210\u98ce\u9669\u4e8b\u4ef6\u3002", (String)"RiskList_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"evalwith", (CharSequence)operateKey)) {
            selectedRows = this.getSelectedRows();
            if (selectedRows.size() == 1) {
                row2 = selectedRows.get(0);
                billStatus = row2.getBillStatus();
                if (StringUtils.equals((CharSequence)"D", (CharSequence)billStatus)) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u5df2\u5173\u95ed\u3002", (String)"RiskList_13", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                return;
            }
            if (selectedRows.size() > 1 && !(closeRowList = selectedRows.stream().filter(row -> StringUtils.equals((CharSequence)"D", (CharSequence)row.getBillStatus())).collect(Collectors.toList())).isEmpty()) {
                title = ResManager.loadKDString((String)"\u4ee5\u4e0b\u98ce\u9669\u5df2\u88ab\u5173\u95ed\uff0c\u65e0\u6cd5\u8fdb\u884c\u534f\u540c\u8bc4\u4f30\u3002", (String)"RiskList_14", (String)"data-rsa-formplugin", (Object[])new Object[0]);
                message = closeRowList.stream().map(ListSelectedRow::getBillNo).collect(Collectors.joining(";\\r\\n")) + "\u3002";
                this.getView().showMessage(title, message, MessageTypes.Default);
                args.setCancel(true);
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"closerisk", (CharSequence)operateKey)) {
            selectedRows = this.getSelectedRows();
            if (selectedRows.size() == 1) {
                row2 = selectedRows.get(0);
                billStatus = row2.getBillStatus();
                if (!StringUtils.equals((CharSequence)"C", (CharSequence)billStatus)) {
                    view.showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u767b\u8bb0\u72b6\u6001\u7684\u98ce\u9669\u8fdb\u884c\u5173\u95ed\u3002", (String)"RiskList_15", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                return;
            }
            if (selectedRows.size() > 1 && !(closeRowList = selectedRows.stream().filter(row -> !StringUtils.equals((CharSequence)"C", (CharSequence)row.getBillStatus())).collect(Collectors.toList())).isEmpty()) {
                title = ResManager.loadKDString((String)"\u4ee5\u4e0b\u98ce\u9669\u4e0d\u662f\u5df2\u767b\u8bb0\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"RiskList_16", (String)"data-rsa-formplugin", (Object[])new Object[0]);
                message = closeRowList.stream().map(ListSelectedRow::getBillNo).collect(Collectors.joining(";\\r\\n")) + "\u3002";
                this.getView().showMessage(title, message, MessageTypes.Default);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IFormView view = this.getView();
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (StringUtils.equals((CharSequence)"checkin", (CharSequence)operateKey) && operationResult.isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            return;
        }
        if (StringUtils.equals((CharSequence)"markfocusrisk", (CharSequence)operateKey) && operationResult.isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            return;
        }
        if (StringUtils.equals((CharSequence)"cmarkfocusrisk", (CharSequence)operateKey) && operationResult.isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            return;
        }
        if (StringUtils.equals((CharSequence)"evalwith", (CharSequence)operateKey) && operationResult.isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                return;
            }
            List<Long> riskIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            boolean repeatEvalFlag = this.validateRepeatEval(riskIdList);
            if (!repeatEvalFlag) {
                return;
            }
            boolean doingEvalFlag = this.validateDoingEval(riskIdList);
            if (doingEvalFlag) {
                this.showEvalWithSetting();
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"closerisk", (CharSequence)operateKey) && operationResult.isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                return;
            }
            List<Long> riskIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            boolean finishEvalFlag = this.validateFinishEval(riskIdList);
            if (!finishEvalFlag) {
                return;
            }
            boolean finishCalFlag = this.validateFinishCal(riskIdList);
            if (finishCalFlag) {
                this.showCloseRisk();
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"trackdownevent", (CharSequence)operateKey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                return;
            }
            List riskIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            QFilter riskFilter = new QFilter("risk.id", "in", riskIdList);
            List idList = QueryServiceHelper.queryPrimaryKeys((String)"rsa_riskevent", (QFilter[])new QFilter[]{riskFilter}, null, (int)10000);
            if (idList.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"RiskList_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            idList.forEach(arg_0 -> ((LinkQueryPkIdCollection)linkQueryPkIdCollection).addLinkQueryPkId(arg_0));
            ListShowParameter lsp = new ListShowParameter();
            lsp.setCaption(ResManager.loadKDString((String)"\u4e0b\u67e5-\u98ce\u9669\u9884\u8b66\u5355", (String)"RiskList_8", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            lsp.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
            lsp.setBillFormId("rsa_riskevent");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.setIsolationOrg(true);
            this.getView().showForm((FormShowParameter)lsp);
            return;
        }
        if (StringUtils.equals((CharSequence)"trackdownwork", (CharSequence)operateKey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                return;
            }
            List riskIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            QFilter riskFilter = new QFilter("riskid.id", "in", riskIdList);
            List idList = QueryServiceHelper.queryPrimaryKeys((String)"rsa_riskwork", (QFilter[])new QFilter[]{riskFilter}, null, (int)10000);
            if (idList.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"RiskList_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            idList.forEach(arg_0 -> ((LinkQueryPkIdCollection)linkQueryPkIdCollection).addLinkQueryPkId(arg_0));
            ListShowParameter lsp = new ListShowParameter();
            lsp.setCaption(ResManager.loadKDString((String)"\u4e0b\u67e5-\u98ce\u9669\u4e8b\u4ef6\u5355", (String)"RiskList_9", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            lsp.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
            lsp.setBillFormId("rsa_riskwork");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.setIsolationOrg(true);
            this.getView().showForm((FormShowParameter)lsp);
            return;
        }
        if (StringUtils.equals((CharSequence)"trackdowneval", (CharSequence)operateKey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                return;
            }
            List riskIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            QFilter riskFilter = new QFilter("entryentity.e_risk.id", "in", riskIdList);
            List idList = QueryServiceHelper.queryPrimaryKeys((String)"rsa_evalwith", (QFilter[])new QFilter[]{riskFilter}, null, (int)10000);
            HashSet idSet = new HashSet(idList);
            if (idSet.isEmpty()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"RiskList_11", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                return;
            }
            LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
            idSet.forEach(arg_0 -> ((LinkQueryPkIdCollection)linkQueryPkIdCollection).addLinkQueryPkId(arg_0));
            ListShowParameter lsp = new ListShowParameter();
            lsp.setCaption(ResManager.loadKDString((String)"\u4e0b\u67e5-\u534f\u540c\u8bc4\u4f30\u5355", (String)"RiskList_10", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            lsp.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
            lsp.setBillFormId("rsa_evalwith");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            lsp.setIsolationOrg(true);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        if (StringUtils.equals((CharSequence)"evalwith", (CharSequence)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows == null || selectedRows.isEmpty()) {
                return;
            }
            List<Long> riskIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            boolean flag = this.validateDoingEval(riskIdList);
            if (flag) {
                this.showEvalWithSetting();
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"closerisk", (CharSequence)callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.showCloseRisk();
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"evalwithsetting", (CharSequence)actionId)) {
            String result2 = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)result2)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"RiskList_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
            }
            return;
        }
        if (StringUtils.equals((CharSequence)"closerisk", (CharSequence)actionId) && StringUtils.equals((CharSequence)"submit", (CharSequence)(result = (String)closedCallBackEvent.getReturnData()))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u6210\u529f\u3002", (String)"RiskList_17", (String)"data-rsa-formplugin", (Object[])new Object[0]));
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private void showEvalWithSetting() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        List riskIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("rsa_evalwithsetting");
        showParameter.setCaption(ResManager.loadKDString((String)"\u534f\u540c\u8bc4\u4f30", (String)"RiskList_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("riskjson", (Object)JSON.toJSONString(riskIdList));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "evalwithsetting"));
        this.getView().showForm(showParameter);
    }

    private void showCloseRisk() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        List riskIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("rsa_closerisk");
        showParameter.setCaption(ResManager.loadKDString((String)"\u5173\u95ed\u98ce\u9669", (String)"RiskList_18", (String)"data-rsa-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("riskjson", (Object)JSON.toJSONString(riskIdList));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closerisk"));
        this.getView().showForm(showParameter);
    }

    private boolean validateRepeatEval(List<Long> riskIdList) {
        List riskBillNoList = RiskHelper.checkRepeatEval(riskIdList);
        if (!riskBillNoList.isEmpty()) {
            String message = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684\u6682\u5b58\u72b6\u6001\u7684\u98ce\u9669\uff08%s\uff09\u5df2\u8fdb\u884c\u8fc7\u56fa\u6709\u98ce\u9669\u8bc4\u4f30\uff0c\u5982\u518d\u6b21\u53d1\u8d77\u98ce\u9669\u8bc4\u4f30\uff0c\u5219\u4f1a\u8986\u76d6\u539f\u6765\u7684\u8bc4\u4f30\u7ed3\u679c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8bc4\u4f30\u3002", (String)"RiskList_4", (String)"data-rsa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", riskBillNoList));
            this.getView().showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener("evalwith", (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private boolean validateDoingEval(List<Long> riskIdList) {
        List riskMapList = RiskHelper.checkDoingEval(riskIdList);
        if (!riskMapList.isEmpty()) {
            if (riskMapList.size() == 1) {
                Map riskMap = (Map)riskMapList.get(0);
                String message = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684\u98ce\u9669\uff1a%1$s\u8fd8\u6709\u672a\u5b8c\u6210\u7684\u98ce\u9669\u8bc4\u4f30\u6d41\u7a0b\uff08\u8bc4\u4f30\u53f7\uff1a%2$s\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RiskList_5", (String)"data-rsa-formplugin", (Object[])new Object[0]), riskMap.get("riskBillNo"), riskMap.get("evalNo"));
                this.getView().showMessage(message);
            } else {
                String title = ResManager.loadKDString((String)"\u4ee5\u4e0b\u6240\u9009\u7684\u98ce\u9669\u8fd8\u6709\u672a\u5b8c\u6210\u7684\u98ce\u9669\u8bc4\u4f30\u6d41\u7a0b\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RiskList_6", (String)"data-rsa-formplugin", (Object[])new Object[0]);
                String message = riskMapList.stream().map(v -> String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\uff0c\u8bc4\u4f30\u53f7\uff1a%3$s", (String)"RiskList_7", (String)"data-rsa-formplugin", (Object[])new Object[0]), v.get("riskBillNo"), v.get("riskName"), v.get("evalNo"))).collect(Collectors.joining(";\\r\\n")) + "\u3002";
                this.getView().showMessage(title, message, MessageTypes.Default);
            }
            return false;
        }
        return true;
    }

    private boolean validateFinishEval(List<Long> riskIdList) {
        List riskMapList = RiskHelper.checkDoingEval(riskIdList);
        if (!riskMapList.isEmpty()) {
            if (riskMapList.size() == 1) {
                Map riskMap = (Map)riskMapList.get(0);
                String message = String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684\u98ce\u9669\uff1a%1$s\u6b63\u5728\u8fdb\u884c\u534f\u540c\u8bc4\u4f30\uff08\u8bc4\u4f30\u53f7\uff1a%2$s\uff09\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"RiskList_19", (String)"data-rsa-formplugin", (Object[])new Object[0]), riskMap.get("riskBillNo"), riskMap.get("evalNo"));
                this.getView().showMessage(message);
            } else {
                String title = ResManager.loadKDString((String)"\u4ee5\u4e0b\u98ce\u9669\u6b63\u5728\u8fdb\u884c\u534f\u540c\u8bc4\u4f30\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"RiskList_20", (String)"data-rsa-formplugin", (Object[])new Object[0]);
                String message = riskMapList.stream().map(v -> String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\uff0c\u8bc4\u4f30\u53f7\uff1a%3$s", (String)"RiskList_7", (String)"data-rsa-formplugin", (Object[])new Object[0]), v.get("riskBillNo"), v.get("riskName"), v.get("evalNo"))).collect(Collectors.joining(";\\r\\n")) + "\u3002";
                this.getView().showMessage(title, message, MessageTypes.Default);
            }
            return false;
        }
        return true;
    }

    private boolean validateFinishCal(List<Long> riskIdList) {
        List riskMapList = RiskHelper.checkFinishCal(riskIdList);
        if (!riskMapList.isEmpty()) {
            String billNoListStr = riskMapList.stream().map(v -> (String)v.get("billno")).collect(Collectors.joining("\u3001"));
            String message = String.format(ResManager.loadKDString((String)"\u6240\u9009\u98ce\u9669\uff08%s\uff09\u7684\u5e94\u5bf9\u8ba1\u5212\u8fd8\u672a\u5b8c\u6210\uff0c\u4e00\u65e6\u5173\u95ed\u540e\u5c06\u65e0\u6cd5\u66f4\u65b0\u8ba1\u5212\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5173\u95ed\u3002", (String)"RiskList_21", (String)"data-rsa-formplugin", (Object[])new Object[0]), billNoListStr);
            this.getView().showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener("closerisk", (IFormPlugin)this));
            return false;
        }
        return true;
    }
}

