/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.StringUtils;

public class RiskOtherDimensionPlugin
extends AbstractFormPlugin {
    private static final String KEY_AUTOTEXT = "key_autotext";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter fsp = (FormShowParameter)e.getSource();
        Map<String, String> otherDimInfo = this.getOtherDimInfo(fsp);
        if (otherDimInfo.isEmpty()) {
            return;
        }
        FlexPanelAp headAp = this.createDynamicPanel(otherDimInfo);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "contentpanel");
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private Map<String, String> getOtherDimInfo(FormShowParameter formShowParameter) {
        String paramStr = (String)formShowParameter.getCustomParam("otherdimension");
        if (StringUtils.isEmpty((String)paramStr)) {
            return new HashMap<String, String>(0);
        }
        return (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
    }

    private FlexPanelAp createDynamicPanel(Map<String, String> otherDimInfo) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        int i = 0;
        for (Map.Entry<String, String> entry : otherDimInfo.entrySet()) {
            FieldAp fieldAp = new FieldAp();
            fieldAp.setWidth(new LocaleString("35%"));
            fieldAp.setId(KEY_AUTOTEXT + i);
            fieldAp.setKey(KEY_AUTOTEXT + i);
            fieldAp.setName(new LocaleString(entry.getKey()));
            fieldAp.setBackColor("#FFFFFF");
            fieldAp.setLock("new,edit,view,submit,audit");
            fieldAp.setFireUpdEvt(true);
            TextField textField = new TextField();
            textField.setId(KEY_AUTOTEXT + i);
            textField.setKey(KEY_AUTOTEXT + i);
            textField.setLockedEmptyTip(new LocaleString(entry.getValue()));
            fieldAp.setField((Field)textField);
            headPanelAp.getItems().add(fieldAp);
        }
        return headPanelAp;
    }
}

