/*
 * Decompiled with CFR 0.152.
 */
package kd.data.rsa.formplugin.risksetting;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.RefBillEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.data.rsa.helper.OrgHelper;

public class RiskWorkEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IPageCache pageCache = this.getView().getPageCache();
        String status = pageCache.get("status");
        if (status == null) {
            this.initBasicData();
            pageCache.put("status", "inited");
        }
    }

    private void initBasicData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String orgIdStr = (String)view.getFormShowParameter().getCustomParam("responsibledep");
        String riskGroupIdStr = (String)view.getFormShowParameter().getCustomParam("group");
        if (!StringUtils.isEmpty((CharSequence)orgIdStr)) {
            Long orgId = Long.valueOf(orgIdStr);
            model.setValue("responsibledep", (Object)orgId);
        } else {
            model.setValue("responsibledep", null);
        }
        if (!StringUtils.isEmpty((CharSequence)riskGroupIdStr)) {
            model.setValue("group", (Object)Long.valueOf(riskGroupIdStr));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("submit".equals(operateKey) && this.getModel().getValue("riskeventidlong") != null) {
            DynamicObject riskEvent = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModel().getValue("riskeventidlong"), (String)"rsa_riskevent");
            Object value = this.getModel().getValue("id");
            DynamicObject dynamicObject = null;
            if (value != null) {
                dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)value, (String)"rsa_riskwork");
            }
            if (riskEvent != null && "3".equals(riskEvent.get("status")) && (!this.getModel().getValue("billno").equals(riskEvent.getString("riskwork")) || dynamicObject == null)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u98ce\u9669\u4e8b\u4ef6\u5173\u8054\u7684\u98ce\u9669\u9884\u8b66\u5355\u7684\u72b6\u6001\u5df2\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u65e0\u6cd5\u63d0\u4ea4\u65b0\u7684\u98ce\u9669\u4e8b\u4ef6\u3002", (String)"RiskWorkEdit_3", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("closeevent".equals(operateKey)) {
            DynamicObject riskWork = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModel().getValue("id"), (String)"rsa_riskwork");
            if (riskWork != null && "E".equals(riskWork.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u98ce\u9669\u4e8b\u4ef6\u5df2\u662f\u5173\u95ed\u72b6\u6001\u3002", (String)"RiskWorkEdit_4", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                args.setCancel(true);
            } else if (riskWork != null && !"E".equals(riskWork.getString("billstatus")) && !"D".equals(riskWork.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u7684\u98ce\u9669\u4e8b\u4ef6\u8fd8\u672a\u5904\u7f6e\u5b8c\u6210\uff0c\u4e0d\u80fd\u5173\u95ed\u4e8b\u4ef6\u3002", (String)"RiskWorkEdit_5", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
                args.setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        model.beginInit();
        ArrayList<Integer> overTimeList = new ArrayList<Integer>(10);
        long zero = System.currentTimeMillis() / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        Timestamp now = new Timestamp(zero);
        int entryRowCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            String overTime;
            Timestamp estCompleteTime = null;
            if (model.getValue("estcompletetime", i) instanceof Timestamp) {
                estCompleteTime = (Timestamp)model.getValue("estcompletetime", i);
            } else if (model.getValue("estcompletetime", i) instanceof Date) {
                estCompleteTime = new Timestamp(((Date)model.getValue("estcompletetime", i)).getTime());
            }
            if (estCompleteTime == null || (overTime = now.after(estCompleteTime) ? "1" : "0").equals(model.getValue("overtime", i).toString())) continue;
            overTimeList.add(i + 1);
            model.setValue("overtime", (Object)overTime, i);
        }
        model.endInit();
        this.getView().updateView("entryentity");
        model.setValue("ifsuperuser", (Object)(PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId()) ? "1" : "0"));
        model.setDataChanged(false);
        model.setValue("riskeventid", model.getValue("riskeventidlong"));
        model.setValue("riskid", model.getValue("riskidlong"));
        this.setEnable();
        this.updateOverTime(overTimeList);
    }

    private void updateOverTime(List<Integer> overTimeList) {
        if (!overTimeList.isEmpty()) {
            DynamicObject riskWork = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"rsa_riskwork");
            DynamicObjectCollection entryEntity = riskWork.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : entryEntity) {
                if (!overTimeList.contains(dyn.getInt("seq"))) continue;
                dyn.set("overtime", (Object)"1");
            }
            SaveServiceHelper.update((DynamicObject)riskWork);
        }
    }

    private void setEnable() {
        String billStatus = this.getModel().getValue("billstatus").toString();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("C".equals(billStatus) || "D".equals(billStatus)) {
            Boolean visible = Boolean.FALSE;
            RequestContext context = RequestContext.get();
            long currUserId = context.getCurrUserId();
            Long responsibleId = Long.valueOf(model.getValue("responsible_id").toString());
            if (responsibleId.equals(currUserId) || PermissionServiceHelper.isSuperUser((long)currUserId)) {
                visible = Boolean.TRUE;
            }
            int entryRowCount = model.getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                Long executorId;
                if (model.getValue("executor", i) == null || !(executorId = Long.valueOf(Long.parseLong(model.getValue("executor_id", i).toString()))).equals(currUserId)) continue;
                visible = Boolean.TRUE;
                break;
            }
            view.setVisible(visible, new String[]{"bar_save"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit responsibleDep = (BasedataEdit)this.getControl("responsibledep");
        BasedataEdit executeDep = (BasedataEdit)this.getControl("executedep");
        RefBillEdit risk = (RefBillEdit)this.getControl("riskid");
        responsibleDep.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        executeDep.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        risk.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        if ("estcompletetime".equals(name) && e.getChangeSet() != null && "1".equals(model.getValue("overtime", (changeData = e.getChangeSet()[0]).getRowIndex()).toString())) {
            model.setValue("overtime", (Object)"0", changeData.getRowIndex());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        IDataModel model = this.getModel();
        String propertyName = event.getProperty().getName();
        if ("executedep".equals(propertyName)) {
            event.addCustomQFilter(new QFilter("id", "in", (Object)OrgHelper.getAllSubOrgList()));
        } else if ("responsibledep".equals(propertyName)) {
            event.addCustomQFilter(new QFilter("id", "in", (Object)OrgHelper.getPermSubOrgList((String)"rsa_riskwork", (String)"47156aff000000ac")));
        } else if ("riskid".equals(propertyName)) {
            Object responsibleDep = model.getValue("responsibledep");
            if (responsibleDep == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d23\u4efb\u90e8\u95e8\u3002", (String)"RiskWorkEdit_0", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            Object group = model.getValue("group");
            if (group == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u98ce\u9669\u7c7b\u522b\u3002", (String)"RiskWorkEdit_1", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                event.setCancel(true);
                return;
            }
            DynamicObject org = (DynamicObject)responsibleDep;
            QFilter qFilter = new QFilter("dutyorg", "=", (Object)org.getLong("id"));
            qFilter.and("billstatus", "=", (Object)"C");
            qFilter.and("group", "=", model.getValue("group_id"));
            event.addCustomQFilter(qFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("closeevent".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            String pkId = null;
            Map billNos = operationResult.getBillNos();
            for (Object o : billNos.keySet()) {
                pkId = o.toString();
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("rsa_closework");
            fsp.setCustomParam("pkid", (Object)pkId);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        } else if ("audit".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("closeevent".equals(closedCallBackEvent.getActionId())) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Map returnDataMap = (Map)closedCallBackEvent.getReturnData();
                Object pkId = returnDataMap.get("pkid");
                String closeExplain = returnDataMap.get("closeexplain").toString();
                DynamicObject riskWork = BusinessDataServiceHelper.loadSingle(pkId, (String)"rsa_riskwork");
                riskWork.set("closeexplain", (Object)closeExplain);
                riskWork.set("billstatus", (Object)"E");
                SaveServiceHelper.update((DynamicObject)riskWork);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u95ed\u6210\u529f\u3002", (String)"RiskWorkEdit_2", (String)"data-rsa-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        } else {
            super.closedCallBack(closedCallBackEvent);
        }
    }
}

